/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay;

import java.awt.Color;
import java.util.Collections;

public class ColorConverter {
    private static final String HEX_CHARS = "0123456789abcdef";

    public static Color HexToColor(String givenHex, int size) {
        givenHex = givenHex.replace("#", "");
        givenHex = givenHex.toLowerCase();
        String hex = "";
        for (char c : givenHex.toCharArray()) {
            String sC = String.valueOf(c);
            hex = HEX_CHARS.contains(sC) ? hex + sC : hex + "0";
        }
        hex = hex + String.join((CharSequence)"", Collections.nCopies(Math.max(0, size - hex.length()), "0"));
        switch (hex.substring(0, size).length()) {
            case 6: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            case 8: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        return Color.WHITE;
    }

    public static String ColorToHex(Color color) {
        int[] rgba = new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
        String hexValue = "";
        for (int i = 0; i < rgba.length; ++i) {
            int intChannelValue = rgba[i];
            String hexChannelValue = Integer.toHexString(intChannelValue);
            while (hexChannelValue.length() < 2) {
                hexChannelValue = hexChannelValue + "0";
            }
            hexValue = hexValue + hexChannelValue;
        }
        while (hexValue.length() < 8) {
            hexValue = hexValue + "0";
        }
        return hexValue.substring(0, 8);
    }
}

