/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay;

import java.util.regex.Pattern;

public class VersionChecker {
    public static int SAME = 0;
    public static int LOWER = 1;
    public static int UPPER = 2;
    private String[] XYZ;
    private String separator = "";

    public VersionChecker(String version) {
        this(version, ".");
    }

    public VersionChecker(String version, String separator) {
        this.separator = separator;
        this.XYZ = this.split(version);
    }

    private String[] split(String str) {
        return str.split(Pattern.quote(this.separator));
    }

    public int compareTo(String otherVersion) {
        String[] otherXYZ = this.split(otherVersion);
        for (int i = 0; i < this.XYZ.length; ++i) {
            int n2;
            int n1 = Integer.valueOf(this.XYZ[i]);
            if (n1 < (n2 = Integer.valueOf(otherXYZ[i]).intValue())) {
                return LOWER;
            }
            if (n1 <= n2) continue;
            return UPPER;
        }
        return SAME;
    }

    public VersionDiff getVersionDifference(String otherVersion) {
        String[] otherXYZ = this.split(otherVersion);
        if (!otherXYZ[0].equals(this.XYZ[0])) {
            return VersionDiff.MAJOR;
        }
        if (!otherXYZ[1].equals(this.XYZ[1])) {
            return VersionDiff.MINOR;
        }
        if (!otherXYZ[2].equals(this.XYZ[2])) {
            return VersionDiff.PATCH;
        }
        return null;
    }

    public static enum VersionDiff {
        PATCH,
        MINOR,
        MAJOR;

    }
}

