/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.dams4k.cpsdisplay.config.VersionManagerConfig;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;

public class VersionManager {
    public String latestVersion = "0.0.0";
    public String latestReleaseURL = "";

    public VersionManager() {
        this.loadLatestVersion();
    }

    public void loadLatestVersion() {
        String mcVersion = "mc1.8.9";
        try {
            URL githubTagsURL = new URL("https://api.github.com/repos/CPSDisplay/cpsdisplay/releases/latest");
            Scanner scanner = new Scanner(githubTagsURL.openStream());
            String response = scanner.useDelimiter("\\Z").next();
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = (JsonObject)parser.parse(response);
            JsonArray assets = jsonObject.getAsJsonArray("assets");
            for (int i = 0; i < assets.size(); ++i) {
                JsonObject object = (JsonObject)assets.get(i);
                String assetName = object.get("name").getAsString();
                if (!assetName.contains(mcVersion) || assetName.contains("sources")) continue;
                String[] splitedLastestVersion = jsonObject.get("tag_name").getAsString().split("\\.");
                ArrayList<String> clearedLatestVersion = new ArrayList<String>();
                clearedLatestVersion.add(VersionManagerConfig.majorUpdate ? splitedLastestVersion[0] : "0");
                clearedLatestVersion.add(VersionManagerConfig.minorUpdate ? splitedLastestVersion[1] : "0");
                clearedLatestVersion.add(VersionManagerConfig.patchUpdate ? splitedLastestVersion[2] : "0");
                this.latestVersion = String.join((CharSequence)".", clearedLatestVersion);
                this.latestReleaseURL = object.get("browser_download_url").getAsString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

