/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.colorpicker;

import fr.dams4k.cpsdisplay.ColorConverter;
import fr.dams4k.cpsdisplay.colorpicker.ColorPickerImages;
import fr.dams4k.cpsdisplay.colorpicker.ColorPickerListener;
import fr.dams4k.cpsdisplay.colorpicker.gui.Button;
import fr.dams4k.cpsdisplay.colorpicker.gui.ButtonListener;
import fr.dams4k.cpsdisplay.colorpicker.gui.ColorPreview;
import fr.dams4k.cpsdisplay.colorpicker.gui.Label;
import fr.dams4k.cpsdisplay.colorpicker.gui.border.InventoryBorder;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.ImagePanel;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.ImageType;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.HPointerListener;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.HPointerPanel;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.PointerPanel;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.SVPointerListener;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.SVPointerPanel;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.slider.Slider;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.slider.SliderListener;
import fr.dams4k.cpsdisplay.colorpicker.gui.textfield.LimitedDocument;
import fr.dams4k.cpsdisplay.colorpicker.gui.textfield.TextField;
import fr.dams4k.cpsdisplay.colorpicker.gui.textfield.TextFieldListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class ColorPicker
extends JFrame
implements HPointerListener,
SVPointerListener,
SliderListener,
TextFieldListener,
WindowFocusListener {
    private List<ColorPickerListener> listeners = new ArrayList<ColorPickerListener>();
    private final ResourceLocation BACKGROUND_RESOURCE = new ResourceLocation("cpsdisplay", "textures/gui/options_background.png");
    private final float TEXTURES_SCALE = 3.0f;
    private final int BORDER_SIZE = 8;
    private final String HEX_CODE = "0123456789abcdef";
    private boolean alphaChannel;
    private Dimension size;
    private ImagePanel background;
    private SVPointerPanel svPointerPanel = new SVPointerPanel();
    private HPointerPanel hPointerPanel = new HPointerPanel();
    private Slider hSlider = new Slider("H", 0, 360, this.TEXTURES_SCALE);
    private Slider sSlider = new Slider("S", 0, 100, this.TEXTURES_SCALE);
    private Slider vSlider = new Slider("V", 0, 100, this.TEXTURES_SCALE);
    private Slider aSlider = new Slider("A", 0, 100, this.TEXTURES_SCALE);
    private Label hexColorLabel = new Label(I18n.func_135052_a((String)"cpsdisplay.external.label.hex_code", (Object[])new Object[0]));
    private TextField hexColorField;
    private ColorPreview oldColorPreview = new ColorPreview(Color.WHITE, this.TEXTURES_SCALE);
    private ColorPreview newColorPreview = new ColorPreview(Color.WHITE, this.TEXTURES_SCALE);
    private Button okButton = new Button(I18n.func_135052_a((String)"cpsdisplay.external.button.ok", (Object[])new Object[0]), this.TEXTURES_SCALE);
    private Button cancelButton = new Button(I18n.func_135052_a((String)"cpsdisplay.external.button.cancel", (Object[])new Object[0]), this.TEXTURES_SCALE);
    private float h = 0.0f;
    private float s = 1.0f;
    private float v = 1.0f;
    private float a = 1.0f;

    public ColorPicker(Color oldColor, boolean alphaChannel) {
        this.setColor(oldColor);
        this.alphaChannel = alphaChannel;
        this.setTitle("ColorPicker");
        this.background = new ImagePanel(this.BACKGROUND_RESOURCE, ImageType.TILING, this.TEXTURES_SCALE);
        this.background.setDarkness(0.5f);
        this.background.setLayout(new BoxLayout(this.background, 3));
        this.setContentPane(this.background);
        int sizeY = alphaChannel ? 640 : 600;
        this.size = new Dimension(320, sizeY);
        this.setSize(this.size);
        this.setMinimumSize(this.size);
        this.addColorPointers();
        this.addGradientSliders();
        this.addHexTextField();
        this.addPreviews(oldColor);
        this.addCloseButtons();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                for (ColorPickerListener listener : ColorPicker.this.listeners) {
                    listener.closed();
                }
            }
        });
        this.addWindowFocusListener(this);
        this.setDefaultCloseOperation(2);
    }

    private void addColorPointers() {
        InventoryBorder inventoryImageBorder = new InventoryBorder(this.TEXTURES_SCALE);
        JPanel colorsPanel = new JPanel(new FlowLayout(1, this.BORDER_SIZE, this.BORDER_SIZE));
        colorsPanel.setOpaque(false);
        colorsPanel.setMaximumSize(new Dimension(500, 256));
        this.background.add(colorsPanel);
        this.svPointerPanel.setImage(ColorPickerImages.svColorSelector(this.h, SVPointerPanel.sizeX, SVPointerPanel.sizeY));
        this.svPointerPanel.setPreferredSize(new Dimension(250, 250));
        this.svPointerPanel.setImageBorder(inventoryImageBorder);
        this.svPointerPanel.addListener(this);
        this.svPointerPanel.defaultX = this.s;
        this.svPointerPanel.defaultY = 1.0f - this.v;
        colorsPanel.add(this.svPointerPanel);
        this.hPointerPanel.setPreferredSize(new Dimension(32, 250));
        this.hPointerPanel.setImageBorder(inventoryImageBorder);
        this.hPointerPanel.addListener(this);
        this.hPointerPanel.defaultY = this.h;
        colorsPanel.add(this.hPointerPanel);
    }

    private void addGradientSliders() {
        JPanel sliders = new JPanel(new FlowLayout(1));
        sliders.setOpaque(false);
        this.background.add(sliders);
        this.hSlider.addListener(this);
        this.hSlider.setValue((int)(this.h * 360.0f));
        this.updateHSlider(true, true, true);
        sliders.add(this.hSlider);
        this.sSlider.addListener(this);
        this.sSlider.setValue((int)(this.s * 100.0f));
        this.updateSSlider(true, true, true);
        sliders.add(this.sSlider);
        this.vSlider.addListener(this);
        this.vSlider.setValue((int)(this.v * 100.0f));
        this.updateVSlider(true, true, true);
        sliders.add(this.vSlider);
        if (this.alphaChannel) {
            this.aSlider.addListener(this);
            this.aSlider.setValue((int)(this.a * 100.0f));
            this.updateASlider(true, true, true);
            sliders.add(this.aSlider);
        }
    }

    public void addHexTextField() {
        JPanel hexColorPanel = new JPanel(new FlowLayout());
        hexColorPanel.setOpaque(false);
        hexColorPanel.setPreferredSize(new Dimension(this.size.width, 44));
        hexColorPanel.setMaximumSize(new Dimension(this.size.width, 44));
        this.hexColorLabel.setPreferredSize(new Dimension((this.size.width - 16) / 2, 24));
        this.hexColorLabel.setMaximumSize(new Dimension((this.size.width - 16) / 2, 24));
        hexColorPanel.add(this.hexColorLabel);
        this.hexColorField = new TextField(this.TEXTURES_SCALE, this.alphaChannel ? 8 : 6);
        this.hexColorField.setPreferredSize(new Dimension(140, 32));
        this.hexColorField.setMaximumSize(new Dimension(140, 32));
        LimitedDocument document = (LimitedDocument)this.hexColorField.getDocument();
        document.anythings = false;
        document.digits = true;
        document.letters = true;
        this.hexColorField.setDocument(document);
        this.updateHexTextField();
        this.hexColorField.addTextFieldListener(this);
        hexColorPanel.add(this.hexColorField);
        this.background.add(hexColorPanel);
    }

    public void addPreviews(Color oldColor) {
        JPanel colorsPreview = new JPanel(new FlowLayout());
        colorsPreview.setOpaque(false);
        colorsPreview.setPreferredSize(new Dimension(this.size.width, 44));
        colorsPreview.setMaximumSize(new Dimension(this.size.width, 44));
        this.background.add(colorsPreview);
        this.oldColorPreview.setColor(oldColor);
        this.updateColorPreview();
        int colorPreviewWidth = 140;
        int colorPreviewHeight = 36;
        this.newColorPreview.setPreferredSize(new Dimension(colorPreviewWidth, colorPreviewHeight));
        this.newColorPreview.setMaximumSize(new Dimension(colorPreviewWidth, colorPreviewHeight));
        this.oldColorPreview.setPreferredSize(new Dimension(colorPreviewWidth, colorPreviewHeight));
        this.oldColorPreview.setMaximumSize(new Dimension(colorPreviewWidth, colorPreviewHeight));
        colorsPreview.add(this.newColorPreview);
        colorsPreview.add(this.oldColorPreview);
    }

    public void addCloseButtons() {
        JPanel closeButtons = new JPanel(new FlowLayout());
        closeButtons.setOpaque(false);
        closeButtons.setPreferredSize(new Dimension(this.size.width, 64));
        closeButtons.setMaximumSize(new Dimension(this.size.width, 64));
        this.background.add(closeButtons);
        this.cancelButton.setPreferredSize(new Dimension(140, 48));
        this.cancelButton.addButtonListener(new ButtonListener(){

            @Override
            public void buttonClicked() {
                ColorPicker.this.close();
                for (ColorPickerListener listener : ColorPicker.this.listeners) {
                    listener.closed();
                }
            }
        });
        closeButtons.add(this.cancelButton);
        this.okButton.setPreferredSize(new Dimension(140, 48));
        this.okButton.addButtonListener(new ButtonListener(){

            @Override
            public void buttonClicked() {
                ColorPicker.this.close();
                for (ColorPickerListener listener : ColorPicker.this.listeners) {
                    listener.newColor(ColorPicker.this.getColor());
                    listener.closed();
                }
            }
        });
        closeButtons.add(this.okButton);
    }

    public void popup() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void HColorChanged(float h) {
        this.HColorChanging(h);
        this.updateHexTextField();
        this.updateHSlider(false, false, true);
    }

    @Override
    public void SColorChanged(float s) {
        this.SColorChanging(s);
        this.updateHexTextField();
        this.updateSSlider(false, false, true);
    }

    @Override
    public void VColorChanged(float v) {
        this.VColorChanging(v);
        this.updateHexTextField();
        this.updateVSlider(false, false, true);
    }

    @Override
    public void sliderValueChanged(String sliderName, int value) {
        this.sliderValueChanging(sliderName, value);
        this.updateHexTextField();
    }

    @Override
    public void HColorChanging(float h) {
        this.h = h;
        this.svPointerPanel.setImage(ColorPickerImages.svColorSelector(this.h, SVPointerPanel.sizeX, SVPointerPanel.sizeY));
        this.updateAllSliders(true, true, false);
        this.updateColorPreview();
    }

    @Override
    public void SColorChanging(float s) {
        this.s = s;
        this.updateAllSliders(true, true, false);
        this.updateColorPreview();
    }

    @Override
    public void VColorChanging(float v) {
        this.v = 1.0f - v;
        this.updateAllSliders(true, true, false);
        this.updateColorPreview();
    }

    @Override
    public void sliderValueChanging(String sliderName, int value) {
        switch (sliderName) {
            case "H": {
                this.h = (float)value / 360.0f;
                break;
            }
            case "S": {
                this.s = (float)value / 100.0f;
                break;
            }
            case "V": {
                this.v = (float)value / 100.0f;
                break;
            }
            case "A": {
                this.a = (float)value / 100.0f;
            }
        }
        this.updateAllSliders(false, true, false);
        this.updateAllPointers();
        this.updateColorPreview();
    }

    public void updateAllPointers() {
        this.updateHPointer();
        this.updateSVPointer();
    }

    public void updateAllSliders(boolean updateValue, boolean updatePointer, boolean updateText) {
        this.updateHSlider(updateValue, updatePointer, updateText);
        this.updateSSlider(updateValue, updatePointer, updateText);
        this.updateVSlider(updateValue, updatePointer, updateText);
        this.updateASlider(updateValue, updatePointer, updateText);
    }

    public void updateHPointer() {
        this.hPointerPanel.setPointerY(this.h);
        this.svPointerPanel.setImage(ColorPickerImages.svColorSelector(this.h, SVPointerPanel.sizeX, SVPointerPanel.sizeY));
    }

    public void updateSVPointer() {
        this.svPointerPanel.setPointerX(this.s);
        this.svPointerPanel.setPointerY(1.0f - this.v);
    }

    public void updateColorPreview() {
        this.newColorPreview.setColor(this.getColor());
    }

    public void updateHSlider(boolean updateValue, boolean updatePointer, boolean updateText) {
        this.hSlider.setValue(Math.round(this.h * 360.0f), updateValue, updatePointer, updateText);
        PointerPanel pointerPanel = this.hSlider.getPointerPanel();
        BufferedImage image = ColorPickerImages.hColorSelector(this.hSlider.gradientSizeX, this.hSlider.gradientSizeY, ColorPickerImages.ImageDisposition.HORIZONTAL);
        pointerPanel.setImage(image);
        pointerPanel.setBrightness(1.0f - this.s);
        pointerPanel.setDarkness(1.0f - this.v);
    }

    public void updateSSlider(boolean updateValue, boolean updatePointer, boolean updateText) {
        this.sSlider.setValue(Math.round(this.s * 100.0f), updateValue, updatePointer, updateText);
        List<Color> colors = Arrays.asList(Color.WHITE, Color.getHSBColor(this.h, 1.0f, 1.0f));
        this.sSlider.setGradient(colors, 1.0f - this.v, 0.0f);
    }

    public void updateVSlider(boolean updateValue, boolean updatePointer, boolean updateText) {
        this.vSlider.setValue(Math.round(this.v * 100.0f), updateValue, updatePointer, updateText);
        List<Color> colors = Arrays.asList(Color.BLACK, Color.getHSBColor(this.h, this.s, 1.0f));
        this.vSlider.setGradient(colors);
    }

    public void updateASlider(boolean updateValue, boolean updatePointer, boolean updateText) {
        this.aSlider.setValue(Math.round(this.a * 100.0f), updateValue, updatePointer, updateText);
        Color color = this.getColor();
        Color colorAlpha0 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        List<Color> colors = Arrays.asList(colorAlpha0, this.getColorNoAlpha());
        this.aSlider.setAGradient(colors);
    }

    public void updateHexTextField() {
        String hexString = ColorConverter.ColorToHex(this.getColor());
        this.hexColorField.setText(this.alphaChannel ? hexString : hexString.substring(0, 6));
    }

    public Color getColorNoAlpha() {
        return Color.getHSBColor(this.h, this.s, this.v);
    }

    public void setColor(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.h = hsb[0];
        this.s = hsb[1];
        this.v = hsb[2];
        this.a = (float)color.getAlpha() / 255.0f;
    }

    public Color getColor() {
        Color hsbColor = this.getColorNoAlpha();
        Color color = new Color(hsbColor.getRed(), hsbColor.getGreen(), hsbColor.getBlue(), (int)(this.a * 255.0f));
        return color;
    }

    public void setOldColor(Color oldColor) {
        this.oldColorPreview.setColor(oldColor);
    }

    public void addListener(ColorPickerListener listener) {
        this.listeners.add(listener);
    }

    public void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void textChanged(String before, String after) {
        int size;
        for (char c : after.toCharArray()) {
            if (this.HEX_CODE.indexOf(c) != -1) continue;
            return;
        }
        int n = size = this.alphaChannel ? 8 : 6;
        if (after.length() == size) {
            Color color = ColorConverter.HexToColor(after, size);
            this.setColor(color);
            this.updateAllSliders(true, true, true);
            this.updateAllPointers();
            this.updateColorPreview();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent event) {
    }

    @Override
    public void windowLostFocus(WindowEvent event) {
        this.close();
    }
}

