/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.colorpicker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ColorPickerImages {
    public static BufferedImage svColorSelector(float h, int sizeX, int sizeY) {
        BufferedImage imageOut = new BufferedImage(sizeX, sizeY, 1);
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                int rgb = Color.HSBtoRGB(h, (float)x / ((float)sizeX - 1.0f), 1.0f - (float)y / ((float)sizeY - 1.0f));
                imageOut.setRGB(x, y, rgb);
            }
        }
        return imageOut;
    }

    public static BufferedImage hColorSelector(int sizeX, int sizeY) {
        return ColorPickerImages.hColorSelector(sizeX, sizeY, ImageDisposition.VERTICAL);
    }

    public static BufferedImage hColorSelector(int sizeX, int sizeY, ImageDisposition disposition) {
        BufferedImage imageOut = new BufferedImage(sizeX, sizeY, 1);
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                int rgb = 0;
                switch (disposition) {
                    case HORIZONTAL: {
                        rgb = Color.HSBtoRGB((float)x / ((float)sizeX - 1.0f), 1.0f, 1.0f);
                        break;
                    }
                    case VERTICAL: {
                        rgb = Color.HSBtoRGB((float)y / ((float)sizeY - 1.0f), 1.0f, 1.0f);
                    }
                }
                imageOut.setRGB(x, y, rgb);
            }
        }
        return imageOut;
    }

    public static BufferedImage createGradient(int sizeX, int sizeY, List<Color> colors) {
        BufferedImage imageOut = new BufferedImage(sizeX, sizeY, 1);
        int gradientWidth = sizeX / (colors.size() - 1);
        for (int i = 0; i < colors.size() - 1; ++i) {
            Color startColor = colors.get(i);
            Color endColor = colors.get(i + 1);
            for (int x = 0; x < gradientWidth; ++x) {
                float diff = 1.0f / (float)gradientWidth * (float)x;
                int rgb = ColorPickerImages.lerp(diff, startColor, endColor).getRGB();
                for (int y = 0; y < sizeY; ++y) {
                    imageOut.setRGB(gradientWidth * i + x, y, rgb);
                }
            }
        }
        return imageOut;
    }

    public static BufferedImage createAGradient(int sizeX, int sizeY, List<Color> colors) {
        BufferedImage imageOut = new BufferedImage(sizeX, sizeY, 2);
        Graphics2D graphics2D = imageOut.createGraphics();
        int gradientWidth = sizeX / (colors.size() - 1);
        for (int i = 0; i < colors.size() - 1; ++i) {
            Color startColor = colors.get(i);
            Color endColor = colors.get(i + 1);
            for (int x = 0; x < gradientWidth; ++x) {
                float diff = 1.0f / (float)gradientWidth * (float)x;
                Color color = ColorPickerImages.lerp(diff, startColor, endColor);
                graphics2D.setColor(color);
                graphics2D.drawRect(x, 0, 1, sizeY);
            }
        }
        graphics2D.dispose();
        return imageOut;
    }

    public static Color lerp(float value, Color startColor, Color endColor) {
        float startR = (float)startColor.getRed() / 255.0f;
        float startG = (float)startColor.getGreen() / 255.0f;
        float startB = (float)startColor.getBlue() / 255.0f;
        float startA = (float)startColor.getAlpha() / 255.0f;
        float endR = (float)endColor.getRed() / 255.0f;
        float endG = (float)endColor.getGreen() / 255.0f;
        float endB = (float)endColor.getBlue() / 255.0f;
        float endA = (float)endColor.getAlpha() / 255.0f;
        float r = startR + (endR - startR) * value;
        float g = startG + (endG - startG) * value;
        float b = startB + (endB - startB) * value;
        float a = startA + (endA - startA) * value;
        return new Color(r, g, b, a);
    }

    public static enum ImageDisposition {
        HORIZONTAL,
        VERTICAL;

    }
}

