/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.colorpicker.gui.border;

import fr.dams4k.cpsdisplay.colorpicker.gui.border.BorderType;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;

public class Border {
    private final Minecraft mc = Minecraft.func_71410_x();
    private BufferedImage baseImage;
    public float imageScaleFactor = 1.0f;
    public float scale = 1.0f;
    public Insets insets = new Insets(0, 0, 0, 0);
    public Image topLeftImage;
    public Image bottomLeftImage;
    public Image bottomRightImage;
    public Image topRightImage;
    public Image leftSideImage;
    public Image bottomSideImage;
    public Image rightSideImage;
    public Image topSideImage;
    public Image backgroundImage;

    public Border(String resourcePath, float scale) {
        this(resourcePath, scale, null);
    }

    public Border(ResourceLocation imageLocation, int[] originalSize, float scale, Insets insets) {
        this.scale = scale;
        if (insets != null) {
            this.insets = insets;
        }
        try {
            this.baseImage = TextureUtil.func_177053_a((InputStream)this.mc.func_110442_L().func_110536_a(imageLocation).func_110527_b());
            float xScaleFactor = (float)this.baseImage.getWidth() / (float)originalSize[0];
            float yScaleFactor = (float)this.baseImage.getHeight() / (float)originalSize[1];
            this.imageScaleFactor = xScaleFactor < yScaleFactor ? xScaleFactor : yScaleFactor;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Border(String resourcePath, float scale, Insets insets) {
        this.scale = scale;
        if (insets != null) {
            this.insets = insets;
        }
        try {
            URL iconURL = this.getClass().getClassLoader().getResource(resourcePath);
            this.baseImage = ImageIO.read(iconURL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setBorder(BorderType borderType, int x, int y, int w, int h) {
        if (this.baseImage == null) {
            return;
        }
        x = Math.round((float)x * this.imageScaleFactor);
        y = Math.round((float)y * this.imageScaleFactor);
        w = Math.max(Math.round((float)w * this.imageScaleFactor), 1);
        h = Math.max(Math.round((float)h * this.imageScaleFactor), 1);
        w = this.clamp(w, 0, this.baseImage.getWidth() - x);
        h = this.clamp(h, 0, this.baseImage.getHeight() - y);
        BufferedImage borderImage = this.resizeImage(this.baseImage.getSubimage(x, y, w, h), this.scale);
        switch (borderType) {
            case TOP_LEFT_CORNER: {
                this.topLeftImage = borderImage;
                break;
            }
            case BOTTOM_LEFT_CORNER: {
                this.bottomLeftImage = borderImage;
                break;
            }
            case BOTTOM_RIGHT_CORNER: {
                this.bottomRightImage = borderImage;
                break;
            }
            case TOP_RIGHT_CORNER: {
                this.topRightImage = borderImage;
                break;
            }
            case LEFT_SIDE: {
                this.leftSideImage = borderImage;
                break;
            }
            case BOTTOM_SIDE: {
                this.bottomSideImage = borderImage;
                break;
            }
            case RIGHT_SIDE: {
                this.rightSideImage = borderImage;
                break;
            }
            case TOP_SIDE: {
                this.topSideImage = borderImage;
                break;
            }
            case BACKGROUND: {
                this.backgroundImage = borderImage;
            }
        }
    }

    public BufferedImage resizeImage(BufferedImage inImage, float scale) {
        int outWidth = Math.round((float)inImage.getWidth() * scale);
        int outHeight = Math.round((float)inImage.getHeight() * scale);
        BufferedImage outImage = new BufferedImage(outWidth, outHeight, 2);
        Graphics2D graphics2D = outImage.createGraphics();
        graphics2D.drawImage(inImage, 0, 0, outWidth, outHeight, null);
        graphics2D.dispose();
        return outImage;
    }

    public void paintBorder(Graphics graphics, JComponent component, boolean drawBackground) {
        if (drawBackground) {
            this.paintBackground(graphics, component);
        }
        this.paintSides(graphics, component);
        this.paintCorners(graphics, component);
    }

    public int getCorrectXSize(int maxW, int imageWidth) {
        int w = maxW - this.insets.left - this.insets.right;
        return this.clamp(w, 1, imageWidth);
    }

    public int getCorrectYSize(int maxH, int imageH) {
        int h = maxH - this.insets.top - this.insets.bottom;
        return this.clamp(h, 1, imageH);
    }

    public void paintBackground(Graphics graphics, JComponent component) {
        if (this.backgroundImage == null) {
            return;
        }
        int startX = this.topLeftImage.getWidth(component) + this.insets.left;
        int startY = this.topLeftImage.getHeight(component) + this.insets.top;
        int iw = this.backgroundImage.getWidth(component);
        int ih = this.backgroundImage.getHeight(component);
        if (iw > 0 && ih > 0) {
            for (int x = startX; x < component.getWidth() - this.insets.right; x += iw) {
                for (int y = startY; y < component.getHeight() - this.insets.bottom; y += ih) {
                    int w = this.getCorrectXSize(component.getWidth() - x, iw);
                    int h = this.getCorrectYSize(component.getHeight() - y + this.insets.top, ih);
                    BufferedImage usedImage = ((BufferedImage)this.backgroundImage).getSubimage(0, 0, w, h);
                    graphics.drawImage(usedImage, x, y, w, h, component);
                }
            }
        }
    }

    public void paintCorners(Graphics graphics, JComponent component) {
        graphics.drawImage(this.topLeftImage, this.insets.left, this.insets.top, this.topLeftImage.getWidth(component), this.topLeftImage.getHeight(component), component);
        graphics.drawImage(this.bottomLeftImage, this.insets.left, component.getHeight() - this.bottomLeftImage.getHeight(component) - this.insets.bottom, this.bottomLeftImage.getWidth(component), this.bottomLeftImage.getHeight(component), component);
        graphics.drawImage(this.bottomRightImage, component.getWidth() - this.bottomRightImage.getWidth(component) - this.insets.right, component.getHeight() - this.bottomRightImage.getHeight(component) - this.insets.bottom, this.bottomRightImage.getWidth(component), this.bottomRightImage.getHeight(component), component);
        graphics.drawImage(this.topRightImage, component.getWidth() - this.topRightImage.getWidth(component) - this.insets.right, this.insets.top, this.topRightImage.getWidth(component), this.topRightImage.getHeight(component), component);
    }

    public void paintSides(Graphics graphics, JComponent component) {
        int lsMaxHeight = component.getHeight() - this.bottomLeftImage.getHeight(component);
        int lsHeight = this.leftSideImage.getHeight(component);
        int lsWidth = this.leftSideImage.getWidth(component);
        for (int y = this.topLeftImage.getHeight(component); y < lsMaxHeight; y += lsHeight) {
            int h = this.getCorrectYSize(component.getHeight() - y, lsHeight);
            BufferedImage usedLeftSideImage = ((BufferedImage)this.leftSideImage).getSubimage(0, 0, lsWidth, h);
            graphics.drawImage(usedLeftSideImage, this.insets.left, y + this.insets.top, lsWidth, h, component);
        }
        int rsMaxHeight = component.getHeight() - this.bottomRightImage.getHeight(component);
        int rsHeight = this.rightSideImage.getHeight(component);
        int rsWidth = this.rightSideImage.getWidth(component);
        for (int y = this.topRightImage.getHeight(component); y < rsMaxHeight; y += rsHeight) {
            int h = this.getCorrectYSize(component.getHeight() - y, rsHeight);
            BufferedImage usedRightSideImage = ((BufferedImage)this.rightSideImage).getSubimage(0, 0, rsWidth, h);
            graphics.drawImage(usedRightSideImage, component.getWidth() - this.rightSideImage.getWidth(component) - this.insets.right, y + this.insets.top, rsWidth, h, component);
        }
        int tsMaxWidth = component.getWidth() - this.topRightImage.getWidth(component);
        int tsHeight = this.topSideImage.getHeight(component);
        int tsWidth = this.topSideImage.getWidth(component);
        for (int x = this.topLeftImage.getWidth(component); x < tsMaxWidth; x += tsWidth) {
            int w = this.getCorrectXSize(component.getWidth() - x, tsWidth);
            BufferedImage usedTopSideImage = ((BufferedImage)this.topSideImage).getSubimage(0, 0, w, tsHeight);
            graphics.drawImage(usedTopSideImage, x + this.insets.left, this.insets.top, w, tsHeight, component);
        }
        int bsMaxWidth = component.getWidth() - this.bottomRightImage.getWidth(component);
        int bsHeight = this.bottomSideImage.getHeight(component);
        int bsWidth = this.bottomSideImage.getWidth(component);
        for (int x = this.bottomLeftImage.getWidth(component); x < bsMaxWidth; x += bsWidth) {
            int w = this.getCorrectXSize(component.getWidth() - x, bsWidth);
            BufferedImage usedBottomSideImage = ((BufferedImage)this.bottomSideImage).getSubimage(0, 0, w, bsHeight);
            graphics.drawImage(usedBottomSideImage, x + this.insets.left, component.getHeight() - this.bottomSideImage.getHeight(component) - this.insets.bottom, w, bsHeight, component);
        }
    }

    public int getWidth(ImageObserver observer) {
        return this.leftSideImage.getWidth(observer) + this.rightSideImage.getWidth(observer);
    }

    public int getHeight(ImageObserver observer) {
        return this.topSideImage.getHeight(observer) + this.bottomSideImage.getHeight(observer);
    }

    private int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

