/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer;

import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.ImagePanel;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.ImageType;
import fr.dams4k.cpsdisplay.colorpicker.gui.imagepanel.pointer.PointerListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.MouseInputListener;

public class PointerPanel
extends ImagePanel
implements MouseInputListener {
    private List<PointerListener> listeners = new ArrayList<PointerListener>();
    private boolean valuesInitialized = false;
    public float defaultX = 0.0f;
    public float defaultY = 0.0f;
    private int x = 0;
    private int y = 0;
    private boolean showXAxis = true;
    private boolean showYAxis = true;

    public PointerPanel(Image image, ImageType imageType, float scale, boolean showXAxis, boolean showYAxis) {
        super(image, imageType, scale);
        this.showXAxis = showXAxis;
        this.showYAxis = showYAxis;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public float getPointerX() {
        return (float)(this.x - this.getLeftPadding()) / (float)(this.getWidth() - this.getLeftPadding() - this.getRightPadding());
    }

    public float getPointerY() {
        return (float)(this.y - this.getTopPadding()) / (float)(this.getHeight() - this.getTopPadding() - this.getBottomPadding());
    }

    public void setPointerX(float x) {
        this.x = (int)(x * (float)(this.getWidth() - this.getLeftPadding() - this.getRightPadding())) + this.getLeftPadding();
        this.repaint();
    }

    public void setPointerY(float y) {
        this.y = (int)(y * (float)(this.getHeight() - this.getTopPadding() - this.getBottomPadding())) + this.getTopPadding();
        this.repaint();
    }

    public int getLeftPadding() {
        return this.imageBorder == null ? 0 : this.imageBorder.leftSideImage.getWidth(this);
    }

    public int getTopPadding() {
        return this.imageBorder == null ? 0 : this.imageBorder.topSideImage.getHeight(this);
    }

    public int getRightPadding() {
        return this.imageBorder == null ? 0 : this.imageBorder.rightSideImage.getWidth(this);
    }

    public int getBottomPadding() {
        return this.imageBorder == null ? 0 : this.imageBorder.bottomSideImage.getHeight(this);
    }

    public void drawXAxis(Graphics g, Color color, int size) {
        g.setColor(color);
        g.fillRect(this.x - size / 2, this.getTopPadding(), size, this.getHeight() - this.getTopPadding() - this.getBottomPadding());
    }

    public void drawYAxis(Graphics g, Color color, int size) {
        g.setColor(color);
        g.fillRect(this.getLeftPadding(), this.y - size / 2, this.getWidth() - this.getLeftPadding() - this.getRightPadding(), size);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.valuesInitialized) {
            this.setPointerX(this.defaultX);
            this.setPointerY(this.defaultY);
            this.valuesInitialized = true;
        }
        super.paintComponent(g);
        this.x = this.clampX(this.x);
        this.y = this.clampY(this.y);
        if (this.showXAxis) {
            this.drawXAxis(g, Color.WHITE, 3);
        }
        if (this.showYAxis) {
            this.drawYAxis(g, Color.WHITE, 3);
        }
        if (this.showXAxis) {
            this.drawXAxis(g, Color.BLACK, 1);
        }
        if (this.showYAxis) {
            this.drawYAxis(g, Color.BLACK, 1);
        }
        if (this.imageBorder != null) {
            this.imageBorder.paintBorder(g, this, this.drawBackground);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.x = this.clampX(e.getX());
        this.y = this.clampY(e.getY());
        this.callChangedListeners();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.x = this.clampX(e.getX());
        this.y = this.clampY(e.getY());
        this.callChangedListeners();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x = this.clampX(e.getX());
        this.y = this.clampY(e.getY());
        this.callChangingListeners();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int clampX(int x) {
        return this.clamp(x, this.getLeftPadding(), this.getWidth() - this.getRightPadding());
    }

    public int clampY(int y) {
        return this.clamp(y, this.getTopPadding(), this.getHeight() - this.getBottomPadding());
    }

    private int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    protected void callChangedListeners() {
        for (PointerListener listener : this.listeners) {
            listener.xPointerChanged(this.getPointerX());
            listener.yPointerChanged(this.getPointerY());
        }
    }

    protected void callChangingListeners() {
        for (PointerListener listener : this.listeners) {
            listener.xPointerChanging(this.getPointerX());
            listener.yPointerChanging(this.getPointerY());
        }
    }

    public void addListener(PointerListener listener) {
        this.listeners.add(listener);
    }
}

