/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.colorpicker.gui.textfield;

import fr.dams4k.cpsdisplay.ColorConverter;
import fr.dams4k.cpsdisplay.colorpicker.gui.Label;
import fr.dams4k.cpsdisplay.colorpicker.gui.border.Border;
import fr.dams4k.cpsdisplay.colorpicker.gui.border.TextFieldBorder;
import fr.dams4k.cpsdisplay.colorpicker.gui.textfield.LimitedDocument;
import fr.dams4k.cpsdisplay.colorpicker.gui.textfield.TextFieldListener;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;

public class TextField
extends JTextField
implements MouseListener,
KeyListener,
FocusListener {
    private List<TextFieldListener> textFieldListeners = new ArrayList<TextFieldListener>();
    private Border imageBorder;
    private Label label = new Label("");
    private int startX = 0;
    private String lastText = "";
    private boolean hasFocus = false;

    public TextField(float textureScale, int maxLength) {
        this.setOpaque(false);
        this.setBorder(null);
        this.imageBorder = new TextFieldBorder(textureScale);
        this.startX = (int)(textureScale * 2.0f);
        this.setDocument(new LimitedDocument(maxLength));
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    protected void paintCaret(Graphics g) {
        g.setColor(ColorConverter.HexToColor("D0D0D0", 6));
        int x = this.startX + this.label.getStringWidth(this.getText().substring(0, this.getCaretPosition()));
        int caretHeight = this.label.getFontHeight();
        g.fillRect(x - (int)(this.label.fontSize / 2.0f), this.getHeight() / 2 - (caretHeight + 8) / 2, (int)this.label.fontSize, caretHeight + 8);
        if (!this.getText().equals(this.lastText)) {
            for (TextFieldListener listener : this.textFieldListeners) {
                listener.textChanged(this.lastText, this.getText());
            }
            this.lastText = this.getText();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.imageBorder.paintBorder(g, this, true);
        int y = this.getHeight() / 2 - this.label.getFontHeight() / 2;
        this.label.paintStringWithShadow(g, this.getText(), this.startX, y);
        if (this.hasFocus) {
            this.paintCaret(g);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        float txtWidth = this.startX + this.label.getStringWidth(this.getText());
        int pos = (int)((float)x / txtWidth * (float)this.getText().length());
        this.setCaretPosition(this.clamp(pos, 0, this.getText().length()));
        this.repaint();
    }

    @Override
    public void setText(String str) {
        this.lastText = str;
        super.setText(str);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public void addTextFieldListener(TextFieldListener listener) {
        this.textFieldListeners.add(listener);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.repaint();
    }
}

