/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.config;

import fr.dams4k.cpsdisplay.ColorConverter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;

public class ModConfig {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static Configuration config;
    public static final String CATEGORY_TEXT = "display";
    public static final String CATEGORY_RAINBOW = "rainbow";
    public static final String CATEGORY_BACKGROUND = "background";
    public static final String CATEGORY_UPDATER = "updater";
    public static boolean showText;
    private static double[] positionText;
    public static double scaleText;
    public static String hexColorText;
    public static String text;
    public static boolean showTextShadow;
    public static String hexColorBackground;
    public static int marginBackground;
    public static boolean showRainbow;
    public static double speedRainbow;
    public static float hueRainbow;
    private static Property positionTextProperty;
    private static Property scaleTextProperty;
    private static Property hexColorTextProperty;
    private static Property showTextProperty;
    private static Property textProperty;
    private static Property showTextShadowProperty;
    private static Property hexColorBackgroundProperty;
    private static Property marginBackgroundProperty;
    private static Property showRainbowProperty;
    private static Property speedRainbowProperty;

    public static void preInit() {
        Path pre2_2_0Path = Paths.get(Loader.instance().getConfigDir().toString(), "cpsdisplay.cfg");
        if (Launch.minecraftHome == null) {
            Launch.minecraftHome = new File(".");
        }
        Path configFolder = Launch.minecraftHome.toPath().resolve("config").resolve("cpsdisplay");
        Path post2_2_0Path = Paths.get(configFolder.toString(), "global.cfg");
        if (Files.exists(pre2_2_0Path, new LinkOption[0])) {
            try {
                Files.move(pre2_2_0Path, post2_2_0Path, new CopyOption[0]);
            }
            catch (IOException e) {
                pre2_2_0Path.toFile().delete();
            }
        }
        File configFile = post2_2_0Path.toFile();
        config = new Configuration(configFile);
        config.load();
        ModConfig.syncConfig(true);
    }

    public static void syncConfig(boolean load) {
        if (load) {
            showTextProperty = config.get(CATEGORY_TEXT, "enable", showText);
            positionTextProperty = config.get(CATEGORY_TEXT, "position", positionText);
            scaleTextProperty = config.get(CATEGORY_TEXT, "scale", scaleText);
            hexColorTextProperty = config.get(CATEGORY_TEXT, "color", hexColorText);
            textProperty = config.get(CATEGORY_TEXT, "text", text);
            showTextShadowProperty = config.get(CATEGORY_TEXT, "shadow", showTextShadow);
            hexColorBackgroundProperty = config.get(CATEGORY_BACKGROUND, "color", hexColorBackground);
            marginBackgroundProperty = config.get(CATEGORY_BACKGROUND, "margin", marginBackground);
            showRainbowProperty = config.get(CATEGORY_RAINBOW, CATEGORY_RAINBOW, showRainbow);
            speedRainbowProperty = config.get(CATEGORY_RAINBOW, "chroma_speed", speedRainbow);
            positionText = positionTextProperty.getDoubleList();
            scaleText = scaleTextProperty.getDouble();
            hexColorText = hexColorTextProperty.getString();
            showText = showTextProperty.getBoolean();
            text = textProperty.getString();
            showTextShadow = showTextShadowProperty.getBoolean();
            hexColorBackground = hexColorBackgroundProperty.getString();
            marginBackground = marginBackgroundProperty.getInt();
            showRainbow = showRainbowProperty.getBoolean();
            speedRainbow = speedRainbowProperty.getDouble();
        } else {
            positionTextProperty.set(positionText);
            scaleTextProperty.set(scaleText);
            hexColorTextProperty.set(hexColorText);
            showTextProperty.set(showText);
            textProperty.set(text);
            showTextShadowProperty.set(showTextShadow);
            hexColorBackgroundProperty.set(hexColorBackground);
            marginBackgroundProperty.set(marginBackground);
            showRainbowProperty.set(showRainbow);
            speedRainbowProperty.set(speedRainbow);
        }
        ModConfig.saveConfig();
    }

    private static void saveConfig() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static String getFormattedString(Integer attackClicks, Integer useClicks) {
        return text.replace("{0}", attackClicks.toString()).replace("{1}", useClicks.toString()).replace("&", "\u00a7");
    }

    public static Color getChroma() {
        int rgb = Color.HSBtoRGB((float)((double)System.currentTimeMillis() * speedRainbow % 2000.0) / 2000.0f, 0.8f, 0.8f);
        return new Color(rgb);
    }

    public static void setTextPosition(int[] positionText) {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int scaleFactor = scaledResolution.func_78325_e();
        double[] positionTextPercentage = new double[]{(double)positionText[0] / (double)(ModConfig.mc.field_71443_c / scaleFactor), (double)positionText[1] / (double)(ModConfig.mc.field_71440_d / scaleFactor)};
        ModConfig.positionText = positionTextPercentage;
    }

    public static int[] getTextPosition() {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int scaleFactor = scaledResolution.func_78325_e();
        int[] realPosition = new int[]{(int)(positionText[0] * (double)(ModConfig.mc.field_71443_c / scaleFactor)), (int)(positionText[1] * (double)(ModConfig.mc.field_71440_d / scaleFactor))};
        return realPosition;
    }

    public static Color getSelectedTextColor() {
        Color textColor;
        if (!showRainbow) {
            try {
                textColor = ColorConverter.HexToColor(hexColorText, 6);
            }
            catch (Exception e) {
                textColor = Color.WHITE;
                hexColorText = "ffffff";
                ModConfig.syncConfig(false);
            }
        } else {
            textColor = ModConfig.getChroma();
        }
        return textColor;
    }

    public static Color getTextColor() {
        return ColorConverter.HexToColor(hexColorText, 6);
    }

    public static void setTextColor(Color color) {
        hexColorText = ColorConverter.ColorToHex(color);
    }

    public static Color getBackgroundColor() {
        return ColorConverter.HexToColor(hexColorBackground, 8);
    }

    public static void setBackgroundColor(Color color) {
        hexColorBackground = ColorConverter.ColorToHex(color);
    }

    static {
        showText = true;
        positionText = new double[]{0.5, 0.5};
        scaleText = 1.0;
        hexColorText = "ffffff";
        text = I18n.func_135052_a((String)"cpsdisplay.display_template.left_right", (Object[])new Object[0]);
        showTextShadow = true;
        hexColorBackground = "2a2a2a80";
        marginBackground = 4;
        showRainbow = false;
        speedRainbow = 1.0;
        hueRainbow = 0.0f;
    }
}

