/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.enums;

import net.minecraft.client.resources.I18n;

public enum ToggleEnum {
    ENABLE(true, "cpsdisplay.button.enable"),
    DISABLE(false, "cpsdisplay.button.disable");

    private final boolean enable;
    private final String text;

    private ToggleEnum(boolean enable, String text) {
        this.enable = enable;
        this.text = text;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public String getText() {
        return I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
    }

    public ToggleEnum toggle() {
        return ToggleEnum.get(!this.enable);
    }

    public static ToggleEnum get(boolean enable) {
        for (ToggleEnum val : ToggleEnum.values()) {
            if (val.isEnabled() != enable) continue;
            return val;
        }
        return null;
    }

    public static ToggleEnum get(String text) {
        for (ToggleEnum val : ToggleEnum.values()) {
            if (val.getText() != I18n.func_135052_a((String)text, (Object[])new Object[0])) continue;
            return val;
        }
        return null;
    }
}

