/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.events;

import fr.dams4k.cpsdisplay.gui.CPSOverlay;
import fr.dams4k.cpsdisplay.gui.GuiConfig;
import fr.dams4k.cpsdisplay.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ModEvents {
    private boolean attackIsPressed = false;
    private boolean useIsPressed = false;
    private List<Long> attackClicks = new ArrayList<Long>();
    private List<Long> useClicks = new ArrayList<Long>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private GameSettings gs;
    private final CPSOverlay cpsOverlay;

    public ModEvents() {
        this.gs = this.mc.field_71474_y;
        this.cpsOverlay = new CPSOverlay();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawnScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui instanceof GuiConfig) {
            this.cpsOverlay.renderOverlay(this.getAttackCPS(), this.getUseCPS());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGui(RenderGameOverlayEvent.Post gameOverlayEvent) {
        if (gameOverlayEvent.type == RenderGameOverlayEvent.ElementType.HOTBAR && !(this.mc.field_71462_r instanceof GuiIngameMenu) && !(this.mc.field_71462_r instanceof GuiConfig)) {
            this.cpsOverlay.renderOverlay(this.getAttackCPS(), this.getUseCPS());
        }
    }

    @SubscribeEvent
    public void onNewTick(TickEvent.ClientTickEvent event) {
        if (ClientProxy.CPS_OVERLAY_CONFIG.func_151470_d()) {
            this.mc.func_147108_a((GuiScreen)new GuiConfig());
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent e) {
        this.onKeyPress();
    }

    @SubscribeEvent
    public void onKeyboardEvent(InputEvent.KeyInputEvent e) {
        this.onKeyPress();
    }

    public void onKeyPress() {
        if (this.gs.field_74312_F.func_151470_d()) {
            if (!this.attackIsPressed) {
                this.attackIsPressed = true;
                this.attackClicks.add(System.currentTimeMillis());
            }
        } else {
            this.attackIsPressed = false;
        }
        if (this.gs.field_74313_G.func_151470_d()) {
            if (!this.useIsPressed) {
                this.useIsPressed = true;
                this.useClicks.add(System.currentTimeMillis());
            }
        } else {
            this.useIsPressed = false;
        }
    }

    public int getAttackCPS() {
        long currentTime = System.currentTimeMillis();
        this.attackClicks.removeIf(e -> e + 1000L < currentTime);
        return this.attackClicks.size();
    }

    public int getUseCPS() {
        long currentTime = System.currentTimeMillis();
        this.useClicks.removeIf(e -> e + 1000L < currentTime);
        return this.useClicks.size();
    }
}

