/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.gui;

import fr.dams4k.cpsdisplay.config.ModConfig;
import fr.dams4k.cpsdisplay.enums.MouseModeEnum;
import fr.dams4k.cpsdisplay.gui.CPSOverlay;
import fr.dams4k.cpsdisplay.gui.ModScreen;
import fr.dams4k.cpsdisplay.gui.MoveOverlayGui;
import fr.dams4k.cpsdisplay.gui.VersionConfig;
import fr.dams4k.cpsdisplay.gui.buttons.ModColorButton;
import fr.dams4k.cpsdisplay.gui.buttons.ModSlider;
import fr.dams4k.cpsdisplay.gui.buttons.ModSliderMainPoint;
import fr.dams4k.cpsdisplay.gui.buttons.ModTextField;
import fr.dams4k.cpsdisplay.gui.buttons.ModToggleButton;
import fr.dams4k.cpsdisplay.gui.buttons.UpdateManagerButton;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class GuiConfig
extends ModScreen {
    private ModToggleButton showTextToggle;
    private GuiButton updateManager;
    private ModSlider scaleTextSlider;
    private GuiButton modeTextButton;
    private ModToggleButton showTextShadowToggle;
    private GuiTextField textField;
    private ModColorButton colorTextButton;
    private MouseModeEnum mouseModeSelected;
    private ModColorButton colorBackgroundButton;
    private GuiLabel marginBackgroundLabel;
    private ModTextField marginBackgroundField;
    private ModToggleButton showRainbowToggle;
    private ModSlider speedRainbowSlider;
    private int diffX = 0;
    private int diffY = 0;

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addTopContainer(this.field_146294_l / 2 - 152, 10 + this.top);
        this.addVisibilityButtons(this.field_146294_l / 2 - 152, 16 + this.top);
        this.addColorButtons(this.field_146294_l / 2 + 4, 16 + this.top);
        this.updateButtons();
    }

    public void addTopContainer(int x, int y) {
        this.showTextToggle = new ModToggleButton(GuiButtons.B_SHOW_TEXT.id, x, GuiButtons.B_SHOW_TEXT.getY(y), 0, 20, I18n.func_135052_a((String)"cpsdisplay.button.show_text", (Object[])new Object[0]), "", ModConfig.showText);
        String showTextString = this.showTextToggle.getDisplayString();
        String updateManagerString = I18n.func_135052_a((String)"cpsdisplay.button.update_manager", (Object[])new Object[0]);
        int containerWidth = 302;
        int showTextStringWidth = this.field_146297_k.field_71466_p.func_78256_a(showTextString);
        int updateManagerStringWidth = Math.max(20, this.field_146297_k.field_71466_p.func_78256_a(updateManagerString) + 8);
        int showTextWidth = Math.max(showTextStringWidth + 8, containerWidth - updateManagerStringWidth - 2);
        int updateManagerWidth = containerWidth - showTextWidth;
        this.showTextToggle.field_146120_f = showTextWidth;
        this.updateManager = new UpdateManagerButton(GuiButtons.B_UPDATE_MANAGER.id, x + showTextWidth + 2, GuiButtons.B_UPDATE_MANAGER.getY(y), updateManagerWidth, 20, updateManagerString);
        this.field_146292_n.add(this.showTextToggle);
        this.field_146292_n.add(this.updateManager);
    }

    public void addVisibilityButtons(int x, int y) {
        this.mouseModeSelected = MouseModeEnum.getByText(ModConfig.text);
        this.scaleTextSlider = new ModSlider(GuiButtons.B_SCALE_TEXT.id, x, GuiButtons.B_SCALE_TEXT.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.slider.scale_text", (Object[])new Object[0]), 10.0f, 400.0f, 0.01f, (float)(ModConfig.scaleText * 100.0), 10);
        for (int i = 50; i < 400; i += 50) {
            this.scaleTextSlider.addMainPoint(new ModSliderMainPoint(i, 4.0f));
        }
        this.showTextShadowToggle = new ModToggleButton(GuiButtons.B_SHADOW_TEXT.id, x, GuiButtons.B_SHADOW_TEXT.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.button.show_shadow", (Object[])new Object[0]), "", ModConfig.showTextShadow);
        this.modeTextButton = new GuiButton(GuiButtons.B_MODE_TEXT.id, x, GuiButtons.B_MODE_TEXT.getY(y), 148, 20, "");
        this.updateMouseModeButton();
        this.textField = new GuiTextField(GuiButtons.F_TEXT.id, this.field_146289_q, x, GuiButtons.F_TEXT.getY(y), 148, 20);
        this.textField.func_146203_f(999);
        this.textField.func_146180_a(ModConfig.text);
        this.field_146292_n.add(this.scaleTextSlider);
        this.field_146292_n.add(this.showTextShadowToggle);
        this.field_146292_n.add(this.modeTextButton);
        this.textFieldList.add(this.textField);
    }

    public void addColorButtons(int x, int y) {
        this.colorTextButton = new ModColorButton(GuiButtons.COLOR_TEXT.id, x, GuiButtons.COLOR_TEXT.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.button.color_text", (Object[])new Object[0]), false);
        this.colorTextButton.setColor(ModConfig.getTextColor());
        this.colorBackgroundButton = new ModColorButton(GuiButtons.B_COLOR_BACKGROUND.id, x, GuiButtons.B_COLOR_BACKGROUND.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.button.color_background", (Object[])new Object[0]), true);
        this.colorBackgroundButton.setColor(ModConfig.getBackgroundColor());
        String labelString = I18n.func_135052_a((String)"cpsdisplay.button.margin_background", (Object[])new Object[0]);
        int stringWidth = this.field_146289_q.func_78256_a(labelString);
        this.marginBackgroundLabel = new GuiLabel(this.field_146289_q, GuiButtons.L_MARGIN_BACKGROUND.id, x + 5, GuiButtons.L_MARGIN_BACKGROUND.getY(y), stringWidth, 20, 0xFFFFFF);
        this.marginBackgroundLabel.func_175202_a(labelString);
        this.marginBackgroundField = new ModTextField(GuiButtons.L_MARGIN_BACKGROUND.id, this.field_146289_q, x + 5 + stringWidth + 10, GuiButtons.L_MARGIN_BACKGROUND.getY(y), 143 - stringWidth - 10, 20);
        this.marginBackgroundField.func_146203_f(2);
        this.marginBackgroundField.func_146180_a(Integer.toString(ModConfig.marginBackground));
        this.marginBackgroundField.letters = false;
        this.marginBackgroundField.punctuation = false;
        this.marginBackgroundField.anythings = false;
        this.marginBackgroundField.placeHolder = "\u00a7o2";
        this.showRainbowToggle = new ModToggleButton(GuiButtons.B_SHOW_RAINBOW.id, x, GuiButtons.B_SHOW_RAINBOW.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.button.show_rainbow", (Object[])new Object[0]), "", ModConfig.showRainbow);
        this.speedRainbowSlider = new ModSlider(GuiButtons.B_SPEED_RAINBOW.id, x, GuiButtons.B_SPEED_RAINBOW.getY(y), 148, 20, I18n.func_135052_a((String)"cpsdisplay.slider.speed_rainbow", (Object[])new Object[0]), 0.05f, 3.0f, 0.05f, (float)ModConfig.speedRainbow, 100);
        this.field_146292_n.add(this.colorTextButton);
        this.field_146292_n.add(this.colorBackgroundButton);
        this.field_146293_o.add(this.marginBackgroundLabel);
        this.textFieldList.add(this.marginBackgroundField);
        this.field_146292_n.add(this.showRainbowToggle);
        this.field_146292_n.add(this.speedRainbowSlider);
    }

    public void addTextButtons(int x, int y) {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        for (GuiTextField field : this.textFieldList) {
            field.func_146201_a(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (GuiTextField field : this.textFieldList) {
            field.func_146192_a(mouseX, mouseY, mouseButton);
        }
        int[] textPosition = ModConfig.getTextPosition();
        this.diffX = textPosition[0] - mouseX;
        this.diffY = textPosition[1] - mouseY;
        if (CPSOverlay.positionInOverlay(mouseX, mouseY)) {
            this.field_146297_k.func_147108_a((GuiScreen)new MoveOverlayGui(this.diffX, this.diffY));
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73876_c() {
        for (GuiTextField field : this.textFieldList) {
            field.func_146178_a();
        }
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawBackground();
        for (GuiTextField field : this.textFieldList) {
            field.func_146194_f();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (CPSOverlay.positionInOverlay(mouseX, mouseY)) {
            ArrayList<Integer> positions = CPSOverlay.getBackgroundPositions(0, 0, false);
            int x1 = positions.get(0);
            int y1 = positions.get(1);
            int x2 = positions.get(2);
            int y2 = positions.get(3);
            int color = -1711341568;
            GL11.glPushMatrix();
            GL11.glScaled((double)ModConfig.scaleText, (double)ModConfig.scaleText, (double)1.0);
            this.func_73728_b(x1 - 1, y1 - 1, y2, color);
            this.func_73728_b(x2, y1 - 1, y2, color);
            this.func_73730_a(x1 - 1, x2, y1 - 1, color);
            this.func_73730_a(x1 - 1, x2, y2, color);
            GL11.glPopMatrix();
        }
        this.updateConfig();
    }

    public void drawBackground() {
        ArrayList<Integer> positions = CPSOverlay.getBackgroundPositions(0, 0, true);
        int color = -1072689136;
        int margin = (int)((double)(this.field_146295_m / 10) * ModConfig.scaleText);
        this.func_73733_a(0, 0, this.field_146294_l, positions.get(1) - margin, color, color);
        this.func_73733_a(0, positions.get(3) + margin, this.field_146294_l, this.field_146295_m, color, color);
        this.func_73733_a(0, positions.get(1) - margin, positions.get(0) - margin, positions.get(3) + margin, color, color);
        this.func_73733_a(positions.get(2) + margin, positions.get(1) - margin, this.field_146294_l, positions.get(3) + margin, color, color);
    }

    public void updateConfig() {
        if (this.textField != null) {
            ModConfig.text = this.textField.func_146179_b();
        }
        if (this.colorTextButton != null) {
            ModConfig.setTextColor(this.colorTextButton.getColor());
        }
        if (this.showTextToggle != null) {
            ModConfig.showText = this.showTextToggle.getValue();
        }
        if (this.scaleTextSlider != null) {
            ModConfig.scaleText = (double)this.scaleTextSlider.getValue() / 100.0;
        }
        if (this.showTextShadowToggle != null) {
            ModConfig.showTextShadow = this.showTextShadowToggle.getValue();
        }
        if (this.colorBackgroundButton != null) {
            ModConfig.setBackgroundColor(this.colorBackgroundButton.getColor());
        }
        if (this.marginBackgroundField != null) {
            int margin;
            String sMargin = this.marginBackgroundField.func_146179_b();
            ModConfig.marginBackground = margin = sMargin.isEmpty() ? 0 : Integer.valueOf(sMargin);
        }
        if (this.showRainbowToggle != null) {
            ModConfig.showRainbow = this.showRainbowToggle.getValue();
        }
        if (this.speedRainbowSlider != null) {
            ModConfig.speedRainbow = this.speedRainbowSlider.getValue();
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == GuiButtons.B_MODE_TEXT.id) {
            this.mouseModeSelected = MouseModeEnum.getById(this.mouseModeSelected.getId() + 1);
            this.updateMouseModeButton();
            if (this.mouseModeSelected != MouseModeEnum.CUSTOM) {
                ModConfig.text = I18n.func_135052_a((String)this.mouseModeSelected.getText(), (Object[])new Object[0]);
            }
            this.textField.func_146180_a(ModConfig.text);
        }
        this.updateConfig();
        ModConfig.syncConfig(false);
        if (button.field_146127_k == GuiButtons.B_UPDATE_MANAGER.id) {
            this.field_146297_k.func_147108_a((GuiScreen)new VersionConfig(this));
        }
    }

    public void updateMouseModeButton() {
        if (this.modeTextButton == null) {
            return;
        }
        this.modeTextButton.field_146126_j = I18n.func_135052_a((String)"cpsdisplay.button.display_mode", (Object[])new Object[0]) + this.mouseModeSelected.getName();
    }

    public void updateButtons() {
        if (this.textField != null) {
            if (this.mouseModeSelected == MouseModeEnum.CUSTOM) {
                this.textField.func_146189_e(true);
            } else {
                this.textField.func_146189_e(false);
            }
        }
        if (this.showRainbowToggle.getValue()) {
            this.speedRainbowSlider.field_146125_m = true;
            this.colorTextButton.field_146125_m = false;
        } else {
            this.speedRainbowSlider.field_146125_m = false;
            this.colorTextButton.field_146125_m = true;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof ModColorButton)) continue;
            ModColorButton colorButton = (ModColorButton)button;
            colorButton.killColorPicker();
        }
        ModConfig.syncConfig(false);
    }

    public static enum GuiButtons {
        B_SHOW_TEXT(0),
        B_UPDATE_MANAGER(10, 0),
        B_SCALE_TEXT(1),
        B_SHADOW_TEXT(2),
        B_MODE_TEXT(3),
        F_TEXT(4),
        B_SHOW_RAINBOW(21),
        B_SPEED_RAINBOW(22),
        COLOR_TEXT(32, 22),
        B_COLOR_BACKGROUND(23),
        L_MARGIN_BACKGROUND(24),
        F_MARGIN_BACKGROUND(24);

        public final int id;
        public final int posId;

        private GuiButtons(int id) {
            this.id = id;
            this.posId = id;
        }

        private GuiButtons(int id, int posId) {
            this.id = id;
            this.posId = posId;
        }

        public int getY(int y) {
            return y + this.posId % 10 * 25;
        }
    }
}

