/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.gui;

import fr.dams4k.cpsdisplay.CPSDisplay;
import fr.dams4k.cpsdisplay.config.VersionManagerConfig;
import fr.dams4k.cpsdisplay.gui.ModScreen;
import fr.dams4k.cpsdisplay.gui.buttons.ModToggleButton;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class VersionConfig
extends ModScreen {
    private GuiScreen parent;
    private ModToggleButton majorToggle;
    private ModToggleButton minorToggle;
    private ModToggleButton patchToggle;
    private ModToggleButton autoUpdateToggle;

    public VersionConfig(GuiScreen parent) {
        this.parent = parent;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2 - 75;
        int y = 10 + this.top;
        this.addToggleButtons(x, y);
        this.field_146292_n.add(new GuiButton(GuiButtons.DONE.id, x, GuiButtons.DONE.getY(y), 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    public void addToggleButtons(int x, int y) {
        this.majorToggle = new ModToggleButton(GuiButtons.MAJOR_CHECK.id, x, GuiButtons.MAJOR_CHECK.getY(y), 150, 20, I18n.func_135052_a((String)"cpsdisplay.version.checker.major_update", (Object[])new Object[0]), "", VersionManagerConfig.majorUpdate);
        this.minorToggle = new ModToggleButton(GuiButtons.MINOR_CHECK.id, x, GuiButtons.MINOR_CHECK.getY(y), 150, 20, I18n.func_135052_a((String)"cpsdisplay.version.checker.minor_update", (Object[])new Object[0]), "", VersionManagerConfig.minorUpdate);
        this.patchToggle = new ModToggleButton(GuiButtons.PATCH_CHECK.id, x, GuiButtons.PATCH_CHECK.getY(y), 150, 20, I18n.func_135052_a((String)"cpsdisplay.version.checker.patch_update", (Object[])new Object[0]), "", VersionManagerConfig.patchUpdate);
        this.autoUpdateToggle = new ModToggleButton(GuiButtons.AUTO_UPDATE.id, x, GuiButtons.AUTO_UPDATE.getY(y) + 10, 150, 20, I18n.func_135052_a((String)"cpsdisplay.version.auto_update", (Object[])new Object[0]), "", VersionManagerConfig.autoUpdate);
        this.updateButtons();
        this.field_146292_n.add(this.majorToggle);
        this.field_146292_n.add(this.minorToggle);
        this.field_146292_n.add(this.patchToggle);
        this.field_146292_n.add(this.autoUpdateToggle);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String nextVersion = VersionConfig.nextVersion();
        int x = this.field_146294_l / 2 - 75;
        int y = GuiButtons.NEXT_UPDATE_LABEL.getY(10 + this.top);
        int width = 150;
        if (nextVersion.equals("2.2.2")) {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"cpsdisplay.version.checker.disabled", (Object[])new Object[0]), x, y, width, 0xFFFFFF);
        } else {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"cpsdisplay.version.checker.enabled", (Object[])new Object[0]).replaceAll("\\{next_version\\}", nextVersion), x, y, width, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void updateButtons() {
        VersionManagerConfig.patchUpdate = this.patchToggle.getValue();
        if (VersionManagerConfig.patchUpdate) {
            this.minorToggle.setValue(true);
            this.minorToggle.field_146124_l = false;
        } else {
            this.minorToggle.field_146124_l = true;
        }
        VersionManagerConfig.minorUpdate = this.minorToggle.getValue();
        if (VersionManagerConfig.minorUpdate) {
            this.majorToggle.setValue(true);
            this.majorToggle.field_146124_l = false;
        } else {
            this.majorToggle.field_146124_l = true;
        }
        VersionManagerConfig.majorUpdate = this.majorToggle.getValue();
        if (!VersionManagerConfig.majorUpdate) {
            this.autoUpdateToggle.setValue(false);
            this.autoUpdateToggle.field_146124_l = false;
        } else {
            this.autoUpdateToggle.field_146124_l = true;
        }
        VersionManagerConfig.autoUpdate = this.autoUpdateToggle.getValue();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.updateButtons();
        if (button.field_146127_k == GuiButtons.DONE.id) {
            this.field_146297_k.func_147108_a(this.parent);
            VersionManagerConfig.saveConfig();
            CPSDisplay.versionManager.loadLatestVersion();
        }
    }

    public static String nextVersion() {
        String[] currentVersionSplited = "2.2.2".split("\\.");
        int major = Integer.parseInt(currentVersionSplited[0]);
        int minor = Integer.parseInt(currentVersionSplited[1]);
        int patch = Integer.parseInt(currentVersionSplited[2]);
        if (VersionManagerConfig.patchUpdate) {
            ++patch;
        } else if (VersionManagerConfig.minorUpdate) {
            patch = 0;
            ++minor;
        } else if (VersionManagerConfig.majorUpdate) {
            patch = 0;
            minor = 0;
            ++major;
        }
        ArrayList<String> nextVersion = new ArrayList<String>();
        nextVersion.add(Integer.toString(major));
        nextVersion.add(Integer.toString(minor));
        nextVersion.add(Integer.toString(patch));
        return String.join((CharSequence)".", nextVersion);
    }

    public static enum GuiButtons {
        MAJOR_CHECK(0),
        MINOR_CHECK(1),
        PATCH_CHECK(2),
        NEXT_UPDATE_LABEL(3),
        AUTO_UPDATE(4),
        DONE(6);

        public final int id;

        private GuiButtons(int id) {
            this.id = id;
        }

        public int getY(int y) {
            return y + this.id % 10 * 25;
        }
    }
}

