/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.gui.buttons;

import fr.dams4k.cpsdisplay.gui.buttons.ModSliderMainPoint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class ModSlider
extends GuiButton {
    private float sliderPosition = 1.0f;
    public boolean isMouseDown;
    private String name;
    private final float min;
    private final float max;
    private final float step;
    private final int decimals;
    private final GuiPageButtonList.GuiResponder responder;
    private FormatHelper formatHelper;
    private List<ModSliderMainPoint> mainPoints = new ArrayList<ModSliderMainPoint>();

    public ModSlider(GuiPageButtonList.GuiResponder guiResponder, int idIn, int x, int y, int width, int height, String name, float min, float max, float step, float defaultValue, FormatHelper formatter, int decimals) {
        super(idIn, x, y, width, height, "");
        this.name = name;
        this.min = min;
        this.max = max;
        this.step = step;
        this.decimals = decimals;
        this.sliderPosition = this.valueToPosition(defaultValue);
        this.formatHelper = formatter;
        this.responder = guiResponder;
        this.field_146126_j = this.getDisplayString();
    }

    public ModSlider(GuiPageButtonList.GuiResponder guiResponder, int idIn, int x, int y, String name, float min, float max, float step, float defaultValue, FormatHelper formatter, int decimals) {
        this(guiResponder, idIn, x, y, 150, 20, name, min, max, step, defaultValue, formatter, decimals);
    }

    public ModSlider(int idIn, int x, int y, int width, int height, String name, float min, float max, float step, float defaultValue, int decimals) {
        this(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int p_175321_1_, boolean p_175321_2_) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int p_175319_1_, String p_175319_2_) {
            }
        }, idIn, x, y, width, height, name, min, max, step, defaultValue, new FormatHelper(){

            @Override
            public String getText(int id, String name, float value) {
                return name + ": " + value + "%";
            }
        }, decimals);
    }

    public void setValue(float value) {
        this.sliderPosition = this.valueToPosition(value);
    }

    public float getValue() {
        return (float)Math.round(this.positionToValue(this.sliderPosition) * (float)this.decimals) / (float)this.decimals;
    }

    public float valueToPosition(float value) {
        return (value - this.min) / (this.max - this.min);
    }

    public float positionToValue(float position) {
        float value = this.min + (this.max - this.min) * position;
        return value - (value + this.step / 2.0f) % this.step + this.step / 2.0f;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.formatHelper = formatHelper;
        this.field_146126_j = this.getDisplayString();
    }

    public void func_175218_a(float value, boolean updateDisplay) {
        this.sliderPosition = this.valueToPosition(value);
        this.field_146126_j = this.getDisplayString();
        if (updateDisplay) {
            this.responder.func_175320_a(this.field_146127_k, this.getValue());
        }
    }

    private String getDisplayString() {
        return this.formatHelper == null ? I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + ": " + this.getValue() : this.formatHelper.getText(this.field_146127_k, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), this.getValue());
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.isMouseDown) {
                this.sliderPosition = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                for (ModSliderMainPoint mainPoint : this.mainPoints) {
                    if (!mainPoint.isNear(this.getValue())) continue;
                    this.sliderPosition = this.valueToPosition(mainPoint.getValue());
                }
                if (this.sliderPosition < 0.0f) {
                    this.sliderPosition = 0.0f;
                }
                if (this.sliderPosition > 1.0f) {
                    this.sliderPosition = 1.0f;
                }
                this.field_146126_j = this.getDisplayString();
                this.responder.func_175320_a(this.field_146127_k, this.getValue());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.valueToPosition(this.getValue()) * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.valueToPosition(this.getValue()) * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public void setSliderPosition(float x) {
        this.sliderPosition = x;
        this.field_146126_j = this.getDisplayString();
        this.responder.func_175320_a(this.field_146127_k, this.getValue());
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderPosition = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            for (ModSliderMainPoint mainPoint : this.mainPoints) {
                if (!mainPoint.isNear(this.getValue())) continue;
                this.sliderPosition = this.valueToPosition(mainPoint.getValue());
            }
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.field_146126_j = this.getDisplayString();
            this.responder.func_175320_a(this.field_146127_k, this.getValue());
            this.isMouseDown = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.isMouseDown = false;
    }

    public void addMainPoint(ModSliderMainPoint mainPoint) {
        this.mainPoints.add(mainPoint);
    }

    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

