/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpsdisplay.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class WindowDisplay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final List<DisplayMode> macDisplayModes = Lists.newArrayList((Object[])new DisplayMode[]{new DisplayMode(2560, 1600), new DisplayMode(2880, 1800)});

    public static void updateDisplayMode() {
        try {
            HashSet set = Sets.newHashSet();
            Collections.addAll(set, Display.getAvailableDisplayModes());
            DisplayMode displaymode = Display.getDesktopDisplayMode();
            if (!set.contains(displaymode) && Util.func_110647_a() == Util.EnumOS.OSX) {
                block2: for (DisplayMode displaymode1 : macDisplayModes) {
                    boolean flag = true;
                    for (DisplayMode displaymode2 : set) {
                        if (displaymode2.getBitsPerPixel() != 32 || displaymode2.getWidth() != displaymode1.getWidth() || displaymode2.getHeight() != displaymode1.getHeight()) continue;
                        flag = false;
                        break;
                    }
                    if (flag) continue;
                    for (DisplayMode displaymode3 : set) {
                        if (displaymode3.getBitsPerPixel() != 32 || displaymode3.getWidth() != displaymode1.getWidth() / 2 || displaymode3.getHeight() != displaymode1.getHeight() / 2) continue;
                        displaymode = displaymode3;
                        continue block2;
                    }
                }
            }
            Display.setDisplayMode((DisplayMode)displaymode);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    public static void enableFullscreen() {
        try {
            WindowDisplay.updateDisplayMode();
            Display.setFullscreen((boolean)true);
            Display.setVSyncEnabled((boolean)WindowDisplay.mc.field_71474_y.field_74352_v);
            mc.func_175601_h();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    public static void disableFullscreen() {
        try {
            int displayWidth = Display.getDisplayMode().getWidth();
            int displayHeight = Display.getDisplayMode().getHeight();
            Display.setDisplayMode((DisplayMode)new DisplayMode(displayWidth, displayHeight));
            WindowDisplay.mc.field_71443_c = displayWidth;
            WindowDisplay.mc.field_71440_d = displayHeight;
            Display.setFullscreen((boolean)false);
            Display.setVSyncEnabled((boolean)WindowDisplay.mc.field_71474_y.field_74352_v);
            mc.func_175601_h();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }
}

