/*
 * Decompiled with CFR 0.152.
 */
package fr.dams4k.cpstweaker;

import fr.dams4k.cpsdisplay.VersionChecker;
import fr.dams4k.cpsdisplay.VersionManager;
import fr.dams4k.cpsdisplay.config.VersionManagerConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.CoreModManager;

public class CPSSetupTweaker
implements ITweaker {
    private static ArrayList<URL> newSourceURL = new ArrayList();

    public CPSSetupTweaker() throws Exception {
        Forge forge;
        VersionManagerConfig.preInit();
        VersionManager versionManager = new VersionManager();
        VersionChecker versionChecker = new VersionChecker("2.2.2");
        if (versionChecker.compareTo(versionManager.latestVersion) == VersionChecker.LOWER && versionManager.latestReleaseURL != "" && VersionManagerConfig.autoUpdate) {
            Path currentJarPath = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), new String[0]);
            Path modsFolder = currentJarPath.getParent();
            Path newJarPath = Paths.get(modsFolder.toString(), Paths.get(versionManager.latestReleaseURL, new String[0]).getFileName().toString());
            File oldJarFile = currentJarPath.toFile();
            Files.createDirectories(Paths.get(modsFolder.toString(), "cpsdisplay_older"), new FileAttribute[0]);
            oldJarFile.renameTo(new File(modsFolder.toString(), "cpsdisplay_older/" + oldJarFile.getName()));
            try {
                int bytesRead;
                BufferedInputStream in = new BufferedInputStream(new URL(versionManager.latestReleaseURL).openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(newJarPath.toString());
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
                newSourceURL.add(newJarPath.toUri().toURL());
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((forge = Forge.getIfPresent()) != null) {
            forge.setupLoad(this);
        }
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return "";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    private static interface Forge
    extends Platform {
        public static Forge getIfPresent() throws IOException {
            if (Launch.classLoader.getClassBytes("net.minecraftforge.common.ForgeVersion") != null) {
                return Forge.getUnchecked();
            }
            return null;
        }

        public static Forge getUnchecked() {
            return new Impl();
        }

        public static class Impl
        implements Forge {
            private static final String MIXIN_TWEAKER = "org.spongepowered.asm.launch.MixinTweaker";

            @Override
            public String getVersion() {
                try {
                    return "forge_" + ForgeVersion.class.getDeclaredField("mcVersion").get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    return "unknown";
                }
            }

            @Override
            public void setupLoad(CPSSetupTweaker tweaker) throws Exception {
                List<SourceFile> sourceFiles = this.getSourceFiles(tweaker.getClass());
                if (sourceFiles.isEmpty()) {
                    System.out.println("Not able to determine current file. Mod will NOT work");
                    return;
                }
                for (SourceFile sourceFile : sourceFiles) {
                    this.setupSourceFile(sourceFile);
                }
            }

            private void setupSourceFile(SourceFile sourceFile) throws Exception {
                Field ignoredModFile = CoreModManager.class.getDeclaredField("ignoredModFiles");
                ignoredModFile.setAccessible(true);
                ((List)ignoredModFile.get(null)).remove(sourceFile.file.getName());
                CoreModManager.getReparseableCoremods().add(sourceFile.file.getName());
                String coreMod = sourceFile.coreMod;
                if (coreMod != null && !sourceFile.mixin) {
                    Method loadCoreMod = CoreModManager.class.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
                    loadCoreMod.setAccessible(true);
                    ITweaker tweaker = (ITweaker)loadCoreMod.invoke(null, Launch.classLoader, coreMod, sourceFile.file);
                    ((List)Launch.blackboard.get("Tweaks")).add(tweaker);
                }
                if (sourceFile.mixin) {
                    try {
                        URI arg;
                        Method addContainer;
                        this.injectMixinTweaker();
                        Class<?> MixinBootstrap = Class.forName("org.spongepowered.asm.launch.MixinBootstrap");
                        Class<?> MixinPlatformManager = Class.forName("org.spongepowered.asm.launch.platform.MixinPlatformManager");
                        Object platformManager = MixinBootstrap.getDeclaredMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
                        try {
                            addContainer = MixinPlatformManager.getDeclaredMethod("addContainer", URI.class);
                            arg = sourceFile.file.toURI();
                        }
                        catch (NoSuchMethodException ignored) {
                            Class<?> IContainerHandle = Class.forName("org.spongepowered.asm.launch.platform.container.IContainerHandle");
                            Class<?> ContainerHandleURI = Class.forName("org.spongepowered.asm.launch.platform.container.ContainerHandleURI");
                            addContainer = MixinPlatformManager.getDeclaredMethod("addContainer", IContainerHandle);
                            arg = ContainerHandleURI.getDeclaredConstructor(URI.class).newInstance(sourceFile.file.toURI());
                        }
                        addContainer.invoke(platformManager, arg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private List<SourceFile> getSourceFiles(Class<?> tweakerClass) {
                String tweakerClassName = tweakerClass.getName();
                ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
                ArrayList sourceURLs = new ArrayList(newSourceURL);
                sourceURLs.addAll(Launch.classLoader.getSources());
                for (URL url : sourceURLs) {
                    try {
                        File file;
                        URI uri = url.toURI();
                        if (!"file".equals(uri.getScheme()) || !(file = new File(uri)).exists() || !file.isFile()) continue;
                        String tweakClass = null;
                        String coreMod = null;
                        boolean mixin = false;
                        try (JarFile jar = new JarFile(file);){
                            if (jar.getManifest() != null) {
                                Attributes attributes = jar.getManifest().getMainAttributes();
                                tweakClass = attributes.getValue("TweakClass");
                                coreMod = attributes.getValue("FMLCorePlugin");
                                mixin = attributes.getValue("MixinConfigs") != null;
                            }
                        }
                        if (!tweakerClassName.equals(tweakClass)) continue;
                        sourceFiles.add(new SourceFile(file, coreMod, mixin));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return sourceFiles;
            }

            private void injectMixinTweaker() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
                if (tweakClasses.contains(MIXIN_TWEAKER)) {
                    this.initMixinTweaker();
                    return;
                }
                if (Launch.blackboard.get("mixin.initialised") != null) {
                    return;
                }
                List tweaks = (List)Launch.blackboard.get("Tweaks");
                tweaks.add(this.initMixinTweaker());
            }

            private ITweaker initMixinTweaker() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                Launch.classLoader.addClassLoaderExclusion(MIXIN_TWEAKER.substring(0, MIXIN_TWEAKER.lastIndexOf(46)));
                return (ITweaker)Class.forName(MIXIN_TWEAKER, true, (ClassLoader)Launch.classLoader).newInstance();
            }

            private static class SourceFile {
                final File file;
                final String coreMod;
                final boolean mixin;

                private SourceFile(File file, String coreMod, boolean mixin) {
                    this.file = file;
                    this.coreMod = coreMod;
                    this.mixin = mixin;
                }
            }
        }
    }

    private static interface Platform {
        public String getVersion();

        default public void setupLoad(CPSSetupTweaker tweaker) throws Exception {
        }
    }
}

