/*
 * Decompiled with CFR 0.152.
 */
package io.armandukx.fullbright.config;

import io.armandukx.fullbright.Fullbright;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    private static final String file = "config/Fullbright.cfg";

    public static void init() {
        config = new Configuration(new File(file));
        try {
            config.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static String getString(String category, String key) {
        try {
            if (config.getCategory(category).containsKey(key)) {
                String string = config.get(category, key, "").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return "";
    }

    public static boolean getBoolean(String category, String key) {
        try {
            if (config.getCategory(category).containsKey(key)) {
                boolean bl = config.get(category, key, false).getBoolean();
                return bl;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringConfig(String category, String key, String value) {
        try {
            String set = config.get(category, key, value).getString();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBooleanConfig(String category, String key, boolean value) {
        try {
            boolean set = config.get(category, key, value).getBoolean();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static boolean hasKey(String category, String key) {
        try {
            if (!config.hasCategory(category)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = config.getCategory(category).containsKey(key);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return false;
    }

    public static String initString(String category, String key, String defaultValue) {
        if (!ConfigHandler.hasKey(category, key)) {
            ConfigHandler.writeStringConfig(category, key, defaultValue);
            return defaultValue;
        }
        return ConfigHandler.getString(category, key);
    }

    public static boolean initBoolean(String category, String key, boolean defaultValue) {
        if (!ConfigHandler.hasKey(category, key)) {
            ConfigHandler.writeBooleanConfig(category, key, defaultValue);
            return defaultValue;
        }
        return ConfigHandler.getBoolean(category, key);
    }

    public static void reloadConfig() {
        ConfigHandler.init();
        Fullbright.config.enabled = ConfigHandler.initBoolean("general", "enabled", true);
    }
}

