/*
 * Decompiled with CFR 0.152.
 */
package io.armandukx.fullbright.gui;

import io.armandukx.fullbright.Fullbright;
import io.armandukx.fullbright.config.ConfigHandler;
import io.armandukx.fullbright.gui.component.ToggleButton;
import io.armandukx.fullbright.utils.GuiUtils;
import io.armandukx.fullbright.utils.structs.GuiPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;

public class SettingsGui
extends GuiScreen {
    private final Map<Integer, GuiPage> pageMap = new HashMap<Integer, GuiPage>();
    private final List<GuiTextField> textFields = new ArrayList<GuiTextField>();
    private final int scrollbarWidth = 10;
    private final int scrollbarHeight = 30;
    private int scrollbarClickOffset = 0;
    private int scrollbarY = 36;
    private boolean isDragging = false;
    private int newScrollIfInside;
    private int guiWidth;
    private int guiHeight;
    private int guiX;
    private int guiY;
    private int pageNum = 0;

    public SettingsGui() {
        this.pageMap.put(0, new GuiPage().addButtons(() -> this.addButton(0, 0, Fullbright.config.enabled)));
    }

    public void func_73866_w_() {
        this.initGui(true);
    }

    public void initGui(boolean save) {
        this.updateGuiSize();
        this.scrollbarY = 36;
        this.isDragging = false;
        this.initializeComponents(save);
        this.addCategory();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.newScrollIfInside >= 36 && GuiUtils.isPointInRegion(this.guiX, this.guiY, this.guiWidth, this.guiHeight, mouseX, mouseY)) {
            this.scrollbarY = this.newScrollIfInside;
            this.newScrollIfInside = 35;
            this.initializeComponents(true);
        }
        SettingsGui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)0x7F000000);
        SettingsGui.func_73734_a((int)this.guiX, (int)this.guiY, (int)(this.guiX + this.guiWidth), (int)(this.guiY + this.guiHeight), (int)-233300955);
        GuiUtils.applyGl(() -> {
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            this.field_146289_q.func_175063_a("Fullbright", (float)this.guiX / 2.0f + 5.0f, (float)this.guiY / 2.0f + 5.0f, -14126946);
            GuiUtils.drawHorizontalLine(this.guiX / 2 + 5, (this.guiX + this.guiWidth) / 2 - 5, this.guiY / 2 + 16, -14126946);
            GuiUtils.drawVerticalLine(this.guiX / 2 + 45, this.guiY / 2 + 16, (this.guiY + this.guiHeight) / 2 - 5, -14126946);
        });
        GuiUtils.enableGlScissors();
        GuiUtils.applyGLScissors(this.guiX, this.guiY + 36, this.guiWidth, this.guiHeight - 47);
        this.pageMap.get(this.pageNum).getSettings().forEach(Runnable::run);
        this.textFields.forEach(GuiTextField::func_146194_f);
        this.field_146292_n.forEach(guiButton -> guiButton.func_146112_a(this.field_146297_k, mouseX, mouseY));
        GuiUtils.disableGlScissors();
        if (this.needsScrollbar()) {
            int scrollbarX = this.guiX + (this.guiWidth - 10);
            GuiUtils.drawScrollbar(scrollbarX, this.guiY + this.scrollbarY, scrollbarX + 10, this.guiY + this.scrollbarY + 30);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (this.pageNum == 0) {
            switch (button.field_146127_k) {
                case 0: {
                    Fullbright.config.enabled = !Fullbright.config.enabled;
                    ConfigHandler.writeBooleanConfig("general", "enabled", Fullbright.config.enabled);
                    String string = button.field_146126_j = Fullbright.config.enabled ? "On" : "Off";
                }
            }
        }
        if (button.field_146127_k == 100 && this.pageNum != 0) {
            this.func_146281_b();
            this.pageNum = 0;
            this.initGui(false);
        }
    }

    public void func_146281_b() {
        for (GuiTextField textField : this.textFields) {
            if (this.pageNum != 0) continue;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.textFields.forEach(textBox -> textBox.func_146192_a(mouseX, mouseY, mouseButton));
        if (mouseButton == 0 && this.needsScrollbar() && GuiUtils.isPointInRegion(this.guiX + (this.guiWidth - 10), this.guiY + this.scrollbarY, 10, 30, mouseX, mouseY)) {
            this.isDragging = true;
            this.scrollbarClickOffset = mouseY - (this.guiY + this.scrollbarY);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.textFields.forEach(GuiTextField::func_146178_a);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.textFields.forEach(textBox -> textBox.func_146201_a(typedChar, keyCode));
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        if (state == 0) {
            this.isDragging = false;
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.isDragging) {
            this.scrollbarY = MathHelper.func_76125_a((int)(mouseY - this.guiY - this.scrollbarClickOffset), (int)36, (int)(this.guiHeight - 30 - 11));
            this.initializeComponents(true);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getEventDWheel();
        if (this.needsScrollbar() && dWheel != 0) {
            dWheel = -Integer.signum(dWheel) * 10;
            this.newScrollIfInside = MathHelper.func_76125_a((int)(this.scrollbarY + dWheel), (int)36, (int)(this.guiHeight - 30 - 11));
        }
    }

    private void addButton(int id, int count, boolean curVal) {
        int translateValue = count * 45 + this.calculateScrollTranslate();
        this.field_146292_n.add(new ToggleButton(id, this.guiX + this.guiWidth - 35, this.guiY + 37 + translateValue, curVal ? "On" : "Off"));
    }

    private void addTextField(int id, int count, String curVal) {
        int translateValue = count * 45 + this.calculateScrollTranslate();
        GuiTextField textBox = new GuiTextField(id, this.field_146289_q, this.guiX + this.guiWidth - 101, this.guiY + 38 + translateValue, 90, 16);
        textBox.func_146180_a(curVal);
        this.textFields.add(textBox);
    }

    private void addSetting(String title, String description, int count) {
        int translateValue = count * 45 + this.calculateScrollTranslate();
        SettingsGui.func_73734_a((int)(this.guiX + 95), (int)(this.guiY + 36 + translateValue), (int)(this.guiX + this.guiWidth - 10), (int)(this.guiY + 76 + translateValue), (int)-13616302);
        SettingsGui.func_73734_a((int)(this.guiX + 95), (int)(this.guiY + 36 + translateValue), (int)(this.guiX + this.guiWidth - 10), (int)(this.guiY + 56 + translateValue), (int)-14603975);
        this.field_146289_q.func_78276_b(title, this.guiX + 100, this.guiY + 41 + translateValue, -1);
        this.field_146289_q.func_78276_b(description, this.guiX + 100, this.guiY + 62 + translateValue, -8355712);
    }

    private void addCategory() {
        this.field_146292_n.add(new ToggleButton(100, this.guiX + 15, this.guiY + 40, "General"));
    }

    private void updateGuiSize() {
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        this.guiWidth = Math.min(scaledResolution.func_78326_a() - 100 / scaledResolution.func_78325_e(), 600);
        this.guiHeight = Math.min(scaledResolution.func_78328_b() - 100 / scaledResolution.func_78325_e(), 400);
        this.guiX = (scaledResolution.func_78326_a() - this.guiWidth) / 2;
        this.guiY = (scaledResolution.func_78328_b() - this.guiHeight) / 2;
    }

    private boolean needsScrollbar() {
        double visibleHeight;
        double totalContent = (this.pageMap.get(this.pageNum).getSettings().size() - 1) * 90 + 80;
        return totalContent > (visibleHeight = (double)(this.guiHeight - 47)) * 2.0;
    }

    private int calculateScrollTranslate() {
        if (!this.needsScrollbar()) {
            return 0;
        }
        double percentScroll = ((double)this.scrollbarY - 36.0) / (double)(this.guiHeight - 30 - 47);
        double totalContent = (this.pageMap.get(this.pageNum).getSettings().size() - 1) * 90 + 80;
        double visibleHeight = this.guiHeight - 47;
        return (int)((totalContent - 2.0 * visibleHeight) * percentScroll / -2.0);
    }

    private void initializeComponents(boolean save) {
        if (save) {
            this.func_146281_b();
        }
        GuiPage curPage = this.pageMap.get(this.pageNum);
        this.field_146292_n.removeIf(button -> button.field_146127_k < 100);
        for (Runnable buttonRunnable : curPage.getButtons()) {
            buttonRunnable.run();
        }
        this.textFields.clear();
        for (Runnable textFieldRunnable : curPage.getTextFields()) {
            textFieldRunnable.run();
        }
    }
}

