/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixins.common;

import me.jellysquid.mods.phosphor.api.ILightingEngineProvider;
import me.jellysquid.mods.phosphor.mod.world.lighting.LightingEngine;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class MixinWorld
implements ILightingEngineProvider {
    private LightingEngine lightingEngine;

    @Shadow
    public abstract boolean func_175648_a(BlockPos var1, int var2, boolean var3);

    @Override
    public LightingEngine getLightingEngine() {
        return this.lightingEngine;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.lightingEngine = new LightingEngine((World)this);
    }

    @Inject(method={"checkLightFor"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkLightFor(EnumSkyBlock type, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!this.func_175648_a(pos, 16, false)) {
            cir.setReturnValue(false);
        }
        this.lightingEngine.scheduleLightUpdate(type, pos);
        cir.setReturnValue(true);
    }
}

