/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mod.world.lighting;

import atomicstryker.dynamiclights.client.DynamicLights;
import me.jellysquid.mods.phosphor.mixins.client.ClientChunkProviderAccessor;
import me.jellysquid.mods.phosphor.mixins.common.ServerChunkProviderAccessor;
import me.jellysquid.mods.phosphor.mod.world.lighting.LightingEngine;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;

public class LightingEngineHelpers {
    private static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();

    static IBlockState posToState(BlockPos pos, Chunk chunk) {
        return LightingEngineHelpers.posToState(pos, chunk.func_76587_i()[pos.func_177956_o() >> 4]);
    }

    static IBlockState posToState(BlockPos pos, ExtendedBlockStorage section) {
        IBlockState state;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (section != null && (state = section.func_150819_a(x & 0xF, y & 0xF, z & 0xF).func_176223_P()) != null) {
            return state;
        }
        return DEFAULT_BLOCK_STATE;
    }

    static int getLightValueForState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (LightingEngine.isDynamicLightsLoaded) {
            return DynamicLights.getLightValue((Block)state.func_177230_c(), (IBlockAccess)world, (BlockPos)pos);
        }
        return state.func_177230_c().getLightValue(world, pos);
    }

    public static Chunk getLoadedChunk(IChunkProvider chunkProvider, int x, int z) {
        if (chunkProvider instanceof ChunkProviderServer) {
            LongHashMap<Chunk> chunkStorage = ((ServerChunkProviderAccessor)chunkProvider).getChunkStorage();
            return (Chunk)chunkStorage.func_76164_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        }
        if (chunkProvider instanceof ChunkProviderClient) {
            LongHashMap<Chunk> chunkStorage = ((ClientChunkProviderAccessor)chunkProvider).getChunkStorage();
            return (Chunk)chunkStorage.func_76164_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        }
        return chunkProvider.func_73154_d(x, z);
    }
}

