/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.components;

import cc.polyfrost.oneconfig.libs.elementa.ElementaVersion;
import cc.polyfrost.oneconfig.libs.elementa.UIComponent;
import cc.polyfrost.oneconfig.libs.elementa.components.Window;
import cc.polyfrost.oneconfig.libs.elementa.constraints.resolution.ConstraintResolutionGui;
import cc.polyfrost.oneconfig.libs.elementa.constraints.resolution.ConstraintResolver;
import cc.polyfrost.oneconfig.libs.elementa.constraints.resolution.ConstraintResolverV2;
import cc.polyfrost.oneconfig.libs.elementa.constraints.resolution.ResolverNode;
import cc.polyfrost.oneconfig.libs.elementa.effects.ScissorEffect;
import cc.polyfrost.oneconfig.libs.elementa.impl.Platform;
import cc.polyfrost.oneconfig.libs.elementa.utils.InvalidUsageKt;
import cc.polyfrost.oneconfig.libs.elementa.utils.OptionsKt;
import cc.polyfrost.oneconfig.libs.universal.UChat;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 `2\u00020\u0001:\u0001`B\u0013\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0014J\u0017\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0014J\u000f\u0010\u001e\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u000eJ\u0015\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001e\u0010\u0014J\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001f\u0010\fJ\u000f\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020 H\u0016\u00a2\u0006\u0004\b#\u0010\"J\u000f\u0010$\u001a\u00020 H\u0016\u00a2\u0006\u0004\b$\u0010\"J\u000f\u0010%\u001a\u00020 H\u0016\u00a2\u0006\u0004\b%\u0010\"J\u000f\u0010&\u001a\u00020 H\u0016\u00a2\u0006\u0004\b&\u0010\"J\u000f\u0010'\u001a\u00020 H\u0016\u00a2\u0006\u0004\b'\u0010\"J\u001f\u0010*\u001a\u00020\u00012\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 H\u0016\u00a2\u0006\u0004\b*\u0010+J-\u00101\u001a\u0002002\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015\u00a2\u0006\u0004\b1\u00102J\u001f\u00106\u001a\u00020\n2\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b6\u00107J'\u00108\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b8\u0010\u001aJ\u000f\u00109\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b9\u0010\u000eJ\u0017\u0010;\u001a\u00020\n2\u0006\u0010:\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010=\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b=\u0010\fJ\r\u0010>\u001a\u00020\n\u00a2\u0006\u0004\b>\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010?\u001a\u0004\b@\u0010AR\u0016\u0010B\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CRi\u0010G\u001aI\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u000200\u0018\u00010D8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0018\u0010M\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010?R\u001c\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00010P8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010RR(\u0010T\u001a\u0004\u0018\u00010\u00012\b\u0010S\u001a\u0004\u0018\u00010\u00018\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bT\u0010N\u001a\u0004\bU\u0010VR$\u0010W\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010N\u001a\u0004\bX\u0010V\"\u0004\bY\u0010\fR\u0016\u0010[\u001a\u00020Z8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u001a\u0010\u0007\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010]\u001a\u0004\b^\u0010_\u00a8\u0006a"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/components/Window;", "Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "", "animationFPS", "<init>", "(I)V", "Lcc/polyfrost/oneconfig/libs/elementa/ElementaVersion;", "version", "(Lcc/polyfrost/oneconfig/libs/elementa/ElementaVersion;I)V", "component", "", "addFloatingComponent", "(Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;)V", "afterInitialization", "()V", "animationFrame", "dealWithFocusRequests", "Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;", "matrixStack", "doDraw", "(Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;)V", "", "mouseX", "mouseY", "button", "doMouseClick", "(DDI)V", "draw", "drawEmbedded$Elementa", "drawEmbedded", "drawFloatingComponents", "focus", "", "getBottom", "()F", "getHeight", "getLeft", "getRight", "getTop", "getWidth", "x", "y", "hitTest", "(FF)Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "left", "top", "right", "bottom", "", "isAreaVisible", "(DDDD)Z", "", "typedChar", "keyCode", "keyType", "(CI)V", "mouseClick", "mouseRelease", "delta", "mouseScroll", "(D)V", "removeFloatingComponent", "unfocus", "I", "getAnimationFPS", "()I", "cancelDrawing", "Z", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "clickInterceptor", "Lkotlin/jvm/functions/Function3;", "getClickInterceptor$Elementa", "()Lkotlin/jvm/functions/Function3;", "setClickInterceptor$Elementa", "(Lkotlin/jvm/functions/Function3;)V", "componentRequestingFocus", "Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "currentMouseButton", "", "floatingComponents", "Ljava/util/List;", "<set-?>", "focusedComponent", "getFocusedComponent", "()Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "hoveredFloatingComponent", "getHoveredFloatingComponent", "setHoveredFloatingComponent", "", "systemTime", "J", "Lcc/polyfrost/oneconfig/libs/elementa/ElementaVersion;", "getVersion$Elementa", "()Lcc/polyfrost/oneconfig/libs/elementa/ElementaVersion;", "Companion", "Elementa"})
public final class Window
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ElementaVersion version;
    private final int animationFPS;
    private long systemTime;
    private int currentMouseButton;
    @NotNull
    private List<UIComponent> floatingComponents;
    @Nullable
    private UIComponent hoveredFloatingComponent;
    @Nullable
    private UIComponent focusedComponent;
    @Nullable
    private UIComponent componentRequestingFocus;
    private boolean cancelDrawing;
    @Nullable
    private Function3<? super Double, ? super Double, ? super Integer, Boolean> clickInterceptor;
    @NotNull
    private static final ConcurrentLinkedQueue<Function0<Unit>> renderOperations = new ConcurrentLinkedQueue();

    @JvmOverloads
    public Window(@NotNull ElementaVersion version, int animationFPS) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.version = version;
        this.animationFPS = animationFPS;
        this.systemTime = -1L;
        this.currentMouseButton = -1;
        this.floatingComponents = new ArrayList();
        super.setParent(this);
    }

    public /* synthetic */ Window(ElementaVersion elementaVersion, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 244;
        }
        this(elementaVersion, n);
    }

    @NotNull
    public final ElementaVersion getVersion$Elementa() {
        return this.version;
    }

    public final int getAnimationFPS() {
        return this.animationFPS;
    }

    @Nullable
    public final UIComponent getHoveredFloatingComponent() {
        return this.hoveredFloatingComponent;
    }

    public final void setHoveredFloatingComponent(@Nullable UIComponent uIComponent) {
        this.hoveredFloatingComponent = uIComponent;
    }

    @Nullable
    public final UIComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    @Nullable
    public final Function3<Double, Double, Integer, Boolean> getClickInterceptor$Elementa() {
        return this.clickInterceptor;
    }

    public final void setClickInterceptor$Elementa(@Nullable Function3<? super Double, ? super Double, ? super Integer, Boolean> function3) {
        this.clickInterceptor = function3;
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window(int animationFPS) {
        this(ElementaVersion.Companion.getV0$Elementa(), animationFPS);
    }

    public /* synthetic */ Window(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 244;
        }
        this(n);
    }

    @Override
    public void afterInitialization() {
        Companion.enqueueRenderOperation((Function0<Unit>)((Function0)afterInitialization.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        ElementaVersion this_$iv = this.version;
        boolean $i$f$enableFor = false;
        ElementaVersion prevVersion$iv = ElementaVersion.Companion.getActive();
        ElementaVersion.Companion.setActive(this_$iv);
        try {
            boolean bl = false;
            this.doDraw(matrixStack);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            ElementaVersion.Companion.setActive(prevVersion$iv);
        }
    }

    private final void doDraw(UMatrixStack matrixStack) {
        if (this.cancelDrawing) {
            return;
        }
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        long startTime = System.nanoTime();
        Iterator<Function0<Unit>> iterator = renderOperations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"renderOperations.iterator()");
        Iterator<Function0<Unit>> it = iterator;
        while (it.hasNext() && System.nanoTime() - startTime < TimeUnit.MILLISECONDS.toNanos(5L)) {
            it.next().invoke();
            it.remove();
        }
        if (this.systemTime == -1L) {
            this.systemTime = System.currentTimeMillis();
        }
        try {
            if (System.currentTimeMillis() - this.systemTime > TimeUnit.SECONDS.toMillis(5L)) {
                this.systemTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(5L);
            }
            long target = System.currentTimeMillis() + (long)(1000 / this.animationFPS);
            int animationFrames = (int)(target - this.systemTime) * this.animationFPS / 1000;
            int n = RangesKt.coerceAtMost((int)animationFrames, (int)RangesKt.coerceAtLeast((int)(this.animationFPS / 30), (int)1));
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it2 = n2++;
                boolean bl = false;
                this.animationFrame();
                this.systemTime += (long)(1000 / this.getAnimationFPS());
            }
            this.hoveredFloatingComponent = null;
            Pair<Float, Float> pair = this.getMousePosition();
            float mouseX = ((Number)pair.component1()).floatValue();
            float mouseY = ((Number)pair.component2()).floatValue();
            for (UIComponent component2 : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
                if (!component2.isPointInside(mouseX, mouseY)) continue;
                this.hoveredFloatingComponent = component2;
                break;
            }
            this.mouseMove(this);
            this.beforeDraw(matrixStack);
            super.draw(matrixStack);
        }
        catch (Throwable e) {
            ConstraintResolutionGui constraintResolutionGui;
            String guiName;
            String string;
            this.cancelDrawing = true;
            Object object = Platform.Companion.getPlatform$Elementa().getCurrentScreen();
            if (object == null) {
                string = "<unknown>";
            } else {
                Class<?> clazz = object.getClass();
                if (clazz == null) {
                    string = "<unknown>";
                } else {
                    string = clazz.getSimpleName();
                    if (string == null) {
                        string = guiName = "<unknown>";
                    }
                }
            }
            if (e instanceof StackOverflowError) {
                System.out.println((Object)"Elementa: Cyclic constraint structure detected!");
                System.out.println((Object)"If you are a developer, set the environment variable \"elementa.dev=true\" to assist in debugging the issue.");
            } else {
                System.out.println((Object)"Elementa: encountered an error while drawing a GUI");
            }
            System.out.println((Object)Intrinsics.stringPlus((String)"Gui name: ", (Object)guiName));
            e.printStackTrace();
            ScissorEffect.Companion.setCurrentScissorState(null);
            GL11.glDisable((int)3089);
            Platform platform = Platform.Companion.getPlatform$Elementa();
            if (e instanceof StackOverflowError && OptionsKt.getElementaDev()) {
                List<ResolverNode> list;
                String string2 = System.getProperty("elementa.dev.cycle_resolver", "2");
                if (Intrinsics.areEqual((Object)string2, (Object)"2")) {
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                } else if (Intrinsics.areEqual((Object)string2, (Object)"1")) {
                    list = new ConstraintResolver(this).getCyclicNodes();
                } else {
                    System.out.println((Object)"Invalid value for \"elementa.dev.cycle_resolver\", falling back to V2 solver.");
                    list = new ConstraintResolverV2(this).getCyclicNodes();
                }
                List<ResolverNode> cyclicNodes = list;
                constraintResolutionGui = new ConstraintResolutionGui(guiName, this, cyclicNodes);
            } else {
                UChat.chat((Object)"\u00a7cElementa encountered an error while drawing a GUI. Check your logs for more information.");
                constraintResolutionGui = null;
            }
            platform.setCurrentScreen((Object)constraintResolutionGui);
        }
    }

    public final void drawEmbedded$Elementa(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        super.draw(matrixStack);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawFloatingComponents(matrixStack)", imports={}))
    public final void drawFloatingComponents() {
        this.drawFloatingComponents(new UMatrixStack());
    }

    public final void drawFloatingComponents(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Iterator<UIComponent> it = this.floatingComponents.iterator();
        while (it.hasNext()) {
            UIComponent component2 = it.next();
            if (Companion.ofOrNull(component2) == null) {
                it.remove();
                continue;
            }
            component2.drawCompat(matrixStack);
        }
    }

    @Override
    public void mouseScroll(double delta) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Pair<Float, Float> pair = this.getMousePosition();
        float mouseX = ((Number)pair.component1()).floatValue();
        float mouseY = ((Number)pair.component2()).floatValue();
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside(mouseX, mouseY)) continue;
            floatingComponent.mouseScroll(delta);
            return;
        }
        super.mouseScroll(delta);
    }

    @Override
    public void mouseClick(double mouseX, double mouseY, int button) {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        Pair<Double, Double> pair = this.pixelCoordinatesToPixelCenter$Elementa(mouseX, mouseY);
        double adjustedX = ((Number)pair.component1()).doubleValue();
        double adjustedY = ((Number)pair.component2()).doubleValue();
        this.doMouseClick(adjustedX, adjustedY, button);
    }

    private final void doMouseClick(double mouseX, double mouseY, int button) {
        this.currentMouseButton = button;
        Function3<? super Double, ? super Double, ? super Integer, Boolean> function3 = this.clickInterceptor;
        if (function3 != null) {
            Function3<? super Double, ? super Double, ? super Integer, Boolean> it = function3;
            boolean bl = false;
            if (((Boolean)it.invoke((Object)mouseX, (Object)mouseY, (Object)button)).booleanValue()) {
                return;
            }
        }
        for (UIComponent floatingComponent : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!floatingComponent.isPointInside((float)mouseX, (float)mouseY)) continue;
            floatingComponent.mouseClick(mouseX, mouseY, button);
            this.dealWithFocusRequests();
            return;
        }
        super.mouseClick(mouseX, mouseY, button);
        this.dealWithFocusRequests();
    }

    private final void dealWithFocusRequests() {
        if (this.componentRequestingFocus == null) {
            this.unfocus();
        } else if (!Intrinsics.areEqual((Object)this.componentRequestingFocus, (Object)this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
    }

    @Override
    public void mouseRelease() {
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        super.mouseRelease();
        this.currentMouseButton = -1;
    }

    @Override
    public void keyType(char typedChar, int keyCode) {
        char character;
        InvalidUsageKt.requireMainThread$default(null, 1, null);
        char c = character = CharCategory.PRIVATE_USE.contains(typedChar) ? (char)'\u0000' : typedChar;
        if (this.focusedComponent != null) {
            UIComponent uIComponent = this.focusedComponent;
            if (uIComponent != null) {
                uIComponent.keyType(character, keyCode);
            }
        } else {
            super.keyType(character, keyCode);
        }
    }

    @Override
    public void animationFrame() {
        if (this.currentMouseButton != -1) {
            Pair<Float, Float> pair = this.getMousePosition();
            float mouseX = ((Number)pair.component1()).floatValue();
            float mouseY = ((Number)pair.component2()).floatValue();
            if (this.version.compareTo((Enum)ElementaVersion.Companion.getV2$Elementa()) >= 0) {
                this.dragMouse(mouseX, mouseY, this.currentMouseButton);
            } else {
                this.dragMouse((int)mouseX, (int)mouseY, this.currentMouseButton);
            }
        }
        if (this.componentRequestingFocus != null && !Intrinsics.areEqual((Object)this.componentRequestingFocus, (Object)this.focusedComponent)) {
            if (this.focusedComponent != null) {
                UIComponent uIComponent = this.focusedComponent;
                if (uIComponent != null) {
                    uIComponent.loseFocus();
                }
            }
            UIComponent uIComponent = this.focusedComponent = this.componentRequestingFocus;
            if (uIComponent != null) {
                uIComponent.focus();
            }
        }
        this.componentRequestingFocus = null;
        super.animationFrame();
    }

    @Override
    public float getLeft() {
        return 0.0f;
    }

    @Override
    public float getTop() {
        return 0.0f;
    }

    @Override
    public float getWidth() {
        return UResolution.getScaledWidth();
    }

    @Override
    public float getHeight() {
        return UResolution.getScaledHeight();
    }

    @Override
    public float getRight() {
        return this.getWidth();
    }

    @Override
    public float getBottom() {
        return this.getHeight();
    }

    public final boolean isAreaVisible(double left2, double top, double right, double bottom) {
        if (right < (double)this.getLeft() || left2 > (double)this.getRight() || bottom < (double)this.getTop() || top > (double)this.getBottom()) {
            return false;
        }
        ScissorEffect.ScissorState scissorState = ScissorEffect.Companion.getCurrentScissorState();
        if (scissorState == null) {
            return true;
        }
        ScissorEffect.ScissorState currentScissor = scissorState;
        double sf = UResolution.getScaleFactor();
        double realX = (double)currentScissor.getX() / sf;
        double realWidth = (double)currentScissor.getWidth() / sf;
        double bottomY = ((double)UResolution.getScaledHeight() * sf - (double)currentScissor.getY()) / sf;
        double realHeight = (double)currentScissor.getHeight() / sf;
        return right > realX && left2 < realX + realWidth && bottom >= bottomY - realHeight && top <= bottomY;
    }

    public final void addFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        if (this.floatingComponents.contains(component2)) {
            return;
        }
        this.floatingComponents.add(component2);
    }

    public final void removeFloatingComponent(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.floatingComponents.remove(component2);
    }

    @Override
    @NotNull
    public UIComponent hitTest(float x, float y) {
        for (UIComponent component2 : CollectionsKt.reversed((Iterable)this.floatingComponents)) {
            if (!component2.isPointInside(x, y)) continue;
            return component2.hitTest(x, y);
        }
        return super.hitTest(x, y);
    }

    public final void focus(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        this.componentRequestingFocus = component2;
    }

    public final void unfocus() {
        if (this.isInitialized()) {
            InvalidUsageKt.requireMainThread$default(null, 1, null);
        }
        UIComponent uIComponent = this.focusedComponent;
        if (uIComponent != null) {
            uIComponent.loseFocus();
        }
        this.focusedComponent = null;
    }

    @JvmOverloads
    public Window(@NotNull ElementaVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this(version, 0, 2, null);
    }

    @Deprecated(message="Add ElementaVersion as the first argument to opt-in to improved behavior.")
    @JvmOverloads
    public Window() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000fR \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/components/Window$Companion;", "", "<init>", "()V", "Lkotlin/Function0;", "", "operation", "enqueueRenderOperation", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "component", "Lcc/polyfrost/oneconfig/libs/elementa/components/Window;", "of", "(Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;)Lcc/polyfrost/oneconfig/libs/elementa/components/Window;", "ofOrNull", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "renderOperations", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public final void enqueueRenderOperation(@NotNull Runnable operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            renderOperations.add(new Function0<Unit>(operation){
                final /* synthetic */ Runnable $operation;
                {
                    this.$operation = $operation;
                    super(0);
                }

                public final void invoke() {
                    this.$operation.run();
                }
            });
        }

        public final void enqueueRenderOperation(@NotNull Function0<Unit> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            renderOperations.add(operation);
        }

        @NotNull
        public final Window of(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Window window = this.ofOrNull(component2);
            if (window == null) {
                throw new IllegalStateException("No window parent? It's possible you haven't called Window.addChild() at this point in time.");
            }
            return window;
        }

        @Nullable
        public final Window ofOrNull(@NotNull UIComponent component2) {
            Window window;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Window window2 = component2.getCachedWindow$Elementa();
            if (window2 == null) {
                Companion $this$ofOrNull_u24lambda_u2d0 = this;
                boolean bl = false;
                UIComponent current = component2;
                while (!(current instanceof Window) && current.getHasParent() && !Intrinsics.areEqual((Object)current.getParent(), (Object)current)) {
                    current = current.getParent();
                }
                UIComponent uIComponent = current;
                window = uIComponent instanceof Window ? (Window)uIComponent : null;
            } else {
                window = window2;
            }
            return window;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

