/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.components.input;

import cc.polyfrost.oneconfig.libs.elementa.UIComponent;
import cc.polyfrost.oneconfig.libs.elementa.components.input.AbstractTextInput;
import cc.polyfrost.oneconfig.libs.elementa.components.input.UIMultilineTextInput;
import cc.polyfrost.oneconfig.libs.elementa.constraints.HeightConstraint;
import cc.polyfrost.oneconfig.libs.elementa.constraints.SuperConstraint;
import cc.polyfrost.oneconfig.libs.elementa.dsl.ConstraintsKt;
import cc.polyfrost.oneconfig.libs.elementa.dsl.UtilitiesKt;
import cc.polyfrost.oneconfig.libs.elementa.utils.TextKt;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001BY\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J#\u0010\u001d\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010 \u001a\u00020\u00112\n\u0010\u001f\u001a\u00060\u001cR\u00020\u0001H\u0014\u00a2\u0006\u0004\b \u0010!J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010*\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b,\u0010-R\u0018\u0010#\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010.\u00a8\u0006/"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/components/input/UIMultilineTextInput;", "Lcc/polyfrost/oneconfig/libs/elementa/components/input/AbstractTextInput;", "", "placeholder", "", "shadow", "Ljava/awt/Color;", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "<init>", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;)V", "getText", "()Ljava/lang/String;", "onEnterPressed", "()V", "recalculateDimensions", "", "x", "y", "Lcc/polyfrost/oneconfig/libs/elementa/components/input/AbstractTextInput$LinePosition;", "screenPosToVisualPos", "(FF)Lcc/polyfrost/oneconfig/libs/elementa/components/input/AbstractTextInput$LinePosition;", "pos", "scrollIntoView", "(Lcc/polyfrost/oneconfig/libs/elementa/components/input/AbstractTextInput$LinePosition;)V", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;", "maxHeight", "setMaxHeight", "(Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;)Lcc/polyfrost/oneconfig/libs/elementa/components/input/UIMultilineTextInput;", "", "maxLines", "setMaxLines", "(I)Lcc/polyfrost/oneconfig/libs/elementa/components/input/UIMultilineTextInput;", "text", "", "textToLines", "(Ljava/lang/String;)Ljava/util/List;", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;", "Elementa"})
public final class UIMultilineTextInput
extends AbstractTextInput {
    @Nullable
    private HeightConstraint maxHeight;

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        super(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor);
    }

    public /* synthetic */ UIMultilineTextInput(String string, boolean bl, Color color, Color color2, boolean bl2, Color color3, Color color4, Color color5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Color color6;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
            color = color6;
        }
        if ((n & 8) != 0) {
            color2 = new Color(64, 139, 229);
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            color3 = new Color(176, 176, 176);
        }
        if ((n & 0x40) != 0) {
            color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
            color4 = color6;
        }
        if ((n & 0x80) != 0) {
            color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
            color5 = color6;
        }
        this(string, bl, color, color2, bl2, color3, color4, color5);
    }

    @NotNull
    public final UIMultilineTextInput setMaxHeight(@NotNull HeightConstraint maxHeight) {
        UIMultilineTextInput uIMultilineTextInput;
        Intrinsics.checkNotNullParameter((Object)maxHeight, (String)"maxHeight");
        UIMultilineTextInput $this$setMaxHeight_u24lambda_u2d0 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u2d0.maxHeight = maxHeight;
        return uIMultilineTextInput;
    }

    @NotNull
    public final UIMultilineTextInput setMaxLines(int maxLines) {
        UIMultilineTextInput uIMultilineTextInput;
        UIMultilineTextInput $this$setMaxLines_u24lambda_u2d1 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxLines_u24lambda_u2d1.maxHeight = UtilitiesKt.pixels$default(Float.valueOf($this$setMaxLines_u24lambda_u2d1.getLineHeight() * (float)maxLines), false, false, 3, null);
        return uIMultilineTextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return CollectionsKt.joinToString$default((Iterable)this.getTextualLines(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getText.1.INSTANCE, (int)30, null);
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char[] cArray = new char[]{'\n'};
        return StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AbstractTextInput.LinePosition visualPos = pos.toVisualPos();
        float visualLineOffset = (float)visualPos.getLine() * -this.getLineHeight();
        if (this.getTargetVerticalScrollingOffset() < visualLineOffset) {
            this.setTargetVerticalScrollingOffset(visualLineOffset);
        } else if (visualLineOffset - this.getLineHeight() < this.getTargetVerticalScrollingOffset() - this.getHeight()) {
            this.setTargetVerticalScrollingOffset(this.getTargetVerticalScrollingOffset() + (visualLineOffset - this.getLineHeight() - (this.getTargetVerticalScrollingOffset() - this.getHeight())));
        }
    }

    @Override
    protected void recalculateDimensions() {
        if (this.maxHeight == null) {
            return;
        }
        SuperConstraint superConstraint = UtilitiesKt.pixels$default(Float.valueOf(this.getLineHeight() * (float)this.getVisualLines().size()), false, false, 3, null);
        HeightConstraint heightConstraint = this.maxHeight;
        Intrinsics.checkNotNull((Object)heightConstraint);
        this.setHeight(ConstraintsKt.coerceAtMost(superConstraint, heightConstraint));
    }

    @Override
    protected void onEnterPressed() {
        if (UKeyboard.isShiftKeyDown()) {
            this.commitTextAddition("\n");
            this.getUpdateAction().invoke((Object)this.getText());
        } else {
            this.getActivateAction().invoke((Object)this.getText());
        }
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        float textScale = this.getTextScale();
        if (!this.getActive() && !this.hasText()) {
            String textToDraw = (String)TextKt.splitStringToWidthTruncated$default(this.getPlaceholder(), this.getWidth(), textScale, 1, false, false, null, null, 240, null).get(0);
            this.drawUnselectedText(matrixStack, textToDraw, this.getLeft(), 0);
            super.draw(matrixStack);
            return;
        }
        if (this.hasSelection()) {
            this.getCursorComponent().hide(true);
        } else if (this.getActive()) {
            UIComponent.unhide$default(this.getCursorComponent(), false, 1, null);
            object = this.getCursor().toScreenPos();
            float cursorPosX = ((Number)object.component1()).floatValue();
            float cursorPosY = ((Number)object.component2()).floatValue();
            this.getCursorComponent().setX(UtilitiesKt.pixels$default(Float.valueOf(cursorPosX), false, false, 3, null));
            this.getCursorComponent().setY(UtilitiesKt.pixels$default(Float.valueOf(cursorPosY), false, false, 3, null));
        }
        object = this.getSelection();
        AbstractTextInput.LinePosition selectionStart = (AbstractTextInput.LinePosition)object.component1();
        AbstractTextInput.LinePosition selectionEnd = (AbstractTextInput.LinePosition)object.component2();
        Iterator<AbstractTextInput.VisualLine> iterator = this.getVisualLines().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            String string2;
            int n2;
            String string3;
            int n3;
            int i = n++;
            AbstractTextInput.VisualLine visualLine = iterator.next();
            float topOffset = this.getLineHeight() * (float)i * this.getTextScale() + this.getVerticalScrollingOffset();
            if (topOffset < -this.getLineHeight() * this.getTextScale() || topOffset > this.getHeight() + this.getLineHeight() * this.getTextScale()) continue;
            if (!this.hasSelection() || i < selectionStart.getLine() || i > selectionEnd.getLine()) {
                this.drawUnselectedText(matrixStack, visualLine.getText(), this.getLeft(), i);
                continue;
            }
            if (i == selectionStart.getLine() && selectionStart.getColumn() > 0) {
                String string4 = visualLine.getText();
                int n4 = 0;
                n3 = selectionStart.getColumn();
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n4, n3);
                string3 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string3 = "";
            }
            String startText = string3;
            if (selectionStart.getLine() == selectionEnd.getLine()) {
                String string7 = visualLine.getText();
                n3 = selectionStart.getColumn();
                n2 = selectionEnd.getColumn();
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n3, n2);
                string2 = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else if (i > selectionStart.getLine() && i < selectionEnd.getLine()) {
                string2 = visualLine.getText();
            } else if (i == selectionStart.getLine()) {
                String string10 = visualLine.getText();
                n3 = selectionStart.getColumn();
                String string11 = string10;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(n3);
                string2 = string12;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
            } else if (i == selectionEnd.getLine()) {
                String string13 = visualLine.getText();
                n3 = 0;
                int n5 = selectionEnd.getColumn();
                String string14 = string13;
                if (string14 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string15 = string14.substring(n3, n5);
                string2 = string15;
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = "";
            }
            String selectedText2 = string2;
            if (i == selectionEnd.getLine() && selectionEnd.getColumn() < this.getVisualLines().get(i).getLength()) {
                String string16 = visualLine.getText();
                n2 = selectionEnd.getColumn();
                String string17 = string16;
                if (string17 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string18 = string17.substring(n2);
                string = string18;
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            String endText = string;
            float startTextWidth = UtilitiesKt.width$default(startText, textScale, null, 2, null);
            float selectedTextWidth = UtilitiesKt.width$default(selectedText2, textScale, null, 2, null);
            float newlinePadding = i < selectionEnd.getLine() ? UtilitiesKt.width(' ', textScale) : 0.0f;
            if (((CharSequence)startText).length() > 0) {
                this.drawUnselectedText(matrixStack, startText, this.getLeft(), i);
            }
            if (((CharSequence)selectedText2).length() > 0 || !(newlinePadding == 0.0f)) {
                this.drawSelectedText(matrixStack, selectedText2, this.getLeft() + startTextWidth, this.getLeft() + startTextWidth + selectedTextWidth + newlinePadding, i);
            }
            if (!(((CharSequence)endText).length() > 0)) continue;
            this.drawUnselectedText(matrixStack, endText, this.getLeft() + startTextWidth + selectedTextWidth, i);
        }
        super.draw(matrixStack);
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float realY = y - this.getVerticalScrollingOffset();
        if (realY <= 0.0f) {
            return new AbstractTextInput.LinePosition(0, 0, true);
        }
        int line = (int)(realY / (this.getLineHeight() * this.getTextScale()));
        if (line > CollectionsKt.getLastIndex(this.getVisualLines())) {
            return new AbstractTextInput.LinePosition(CollectionsKt.getLastIndex(this.getVisualLines()), ((AbstractTextInput.VisualLine)CollectionsKt.last(this.getVisualLines())).getText().length(), true);
        }
        String text = this.getVisualLines().get(line).getText();
        int column = 0;
        float currWidth = 0.0f;
        if (x <= 0.0f) {
            return new AbstractTextInput.LinePosition(line, 0, true);
        }
        if (x >= this.getWidth()) {
            return new AbstractTextInput.LinePosition(line, this.getVisualLines().get(line).getText().length(), true);
        }
        String string = text;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int n = 0;
        int n2 = cArray2.length;
        while (n < n2) {
            char c = cArray2[n];
            ++n;
            float charWidth = UtilitiesKt.width(c, this.getTextScale());
            if (currWidth + charWidth / (float)2 >= x) {
                return new AbstractTextInput.LinePosition(line, column, true);
            }
            currWidth += charWidth;
            int n3 = column;
            column = n3 + 1;
        }
        return new AbstractTextInput.LinePosition(line, column, true);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 128, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 192, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 224, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 240, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        this(placeholder, shadow, selectionBackgroundColor, null, false, null, null, null, 248, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow, null, null, false, null, null, null, 252, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, false, null, null, false, null, null, null, 254, null);
    }

    @JvmOverloads
    public UIMultilineTextInput() {
        this(null, false, null, null, false, null, null, null, 255, null);
    }
}

