/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.constraints.animation;

import cc.polyfrost.oneconfig.libs.elementa.UIComponent;
import cc.polyfrost.oneconfig.libs.elementa.constraints.ConstraintType;
import cc.polyfrost.oneconfig.libs.elementa.constraints.HeightConstraint;
import cc.polyfrost.oneconfig.libs.elementa.constraints.animation.AnimationComponent;
import cc.polyfrost.oneconfig.libs.elementa.constraints.animation.AnimationStrategy;
import cc.polyfrost.oneconfig.libs.elementa.constraints.debug.ConstraintDebugger;
import cc.polyfrost.oneconfig.libs.elementa.constraints.debug.ConstraintDebuggerKt;
import cc.polyfrost.oneconfig.libs.elementa.constraints.resolution.ConstraintVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B/\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u0004\u0018\u00010\u00108\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0017\u0010\t\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\b\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\b\u0010)\u001a\u0004\b,\u0010+R\"\u0010.\u001a\u00020-8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/constraints/animation/HeightAnimationComponent;", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/animation/AnimationComponent;", "", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/animation/AnimationStrategy;", "strategy", "", "totalFrames", "oldConstraint", "newConstraint", "delay", "<init>", "(Lcc/polyfrost/oneconfig/libs/elementa/constraints/animation/AnimationStrategy;ILcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;I)V", "", "animationFrame", "()V", "Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "component", "getHeightImpl", "(Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;)F", "getTextScale", "to", "(Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;)Lcc/polyfrost/oneconfig/libs/elementa/constraints/animation/HeightAnimationComponent;", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/ConstraintType;", "type", "visitImpl", "(Lcc/polyfrost/oneconfig/libs/elementa/constraints/resolution/ConstraintVisitor;Lcc/polyfrost/oneconfig/libs/elementa/constraints/ConstraintType;)V", "cachedValue", "F", "getCachedValue", "()Ljava/lang/Float;", "setCachedValue", "(F)V", "constrainTo", "Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "getConstrainTo", "()Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;", "setConstrainTo", "(Lcc/polyfrost/oneconfig/libs/elementa/UIComponent;)V", "Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;", "getNewConstraint", "()Lcc/polyfrost/oneconfig/libs/elementa/constraints/HeightConstraint;", "getOldConstraint", "", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "Elementa"})
public final class HeightAnimationComponent
extends AnimationComponent<Float>
implements HeightConstraint {
    @NotNull
    private final HeightConstraint oldConstraint;
    @NotNull
    private final HeightConstraint newConstraint;
    private float cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    public HeightAnimationComponent(@NotNull AnimationStrategy strategy, int totalFrames, @NotNull HeightConstraint oldConstraint, @NotNull HeightConstraint newConstraint, int delay2) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)oldConstraint, (String)"oldConstraint");
        Intrinsics.checkNotNullParameter((Object)newConstraint, (String)"newConstraint");
        super(strategy, totalFrames, delay2, null);
        this.oldConstraint = oldConstraint;
        this.newConstraint = newConstraint;
        this.recalculate = true;
    }

    @NotNull
    public final HeightConstraint getOldConstraint() {
        return this.oldConstraint;
    }

    @NotNull
    public final HeightConstraint getNewConstraint() {
        return this.newConstraint;
    }

    @Override
    @NotNull
    public Float getCachedValue() {
        return Float.valueOf(this.cachedValue);
    }

    @Override
    public void setCachedValue(float f) {
        this.cachedValue = f;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    public float getHeightImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        float startX = this.oldConstraint.getHeight(component2);
        float finalX = this.newConstraint.getHeight(component2);
        return startX + (finalX - startX) * this.getPercentComplete();
    }

    @Override
    public float getTextScale(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ConstraintDebugger debugger = ConstraintDebuggerKt.getConstraintDebugger();
        if (debugger != null) {
            return debugger.evaluate(this, ConstraintType.HEIGHT, component2);
        }
        if (this.getRecalculate()) {
            this.setCachedValue(this.getHeightImpl(component2));
            this.setRecalculate(false);
        }
        return this.getCachedValue().floatValue();
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        this.oldConstraint.animationFrame();
        this.newConstraint.animationFrame();
    }

    @NotNull
    public HeightAnimationComponent to(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        HeightAnimationComponent $this$to_u24lambda_u2d0 = this;
        boolean bl = false;
        throw new UnsupportedOperationException("Constraint.to(UIComponent) is not available in this context!");
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.oldConstraint.visit(visitor, type, false);
        this.newConstraint.visit(visitor, type, false);
    }
}

