/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal;

import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.Bracket;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.Delimiter;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.StaggeredDelimiterProcessor;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.AsteriskDelimiterProcessor;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.AutolinkInlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.BackslashInlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.BackticksInlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.EntityInlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.HtmlInlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.InlineContentParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.InlineParserState;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.ParsedInline;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.ParsedInlineImpl;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.Position;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.Scanner;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.util.Escaping;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.util.LinkScanner;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.util.Parsing;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.HardLineBreak;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.Image;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.Link;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.LinkReferenceDefinition;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.Node;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.SoftLineBreak;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.SourceSpans;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.Text;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.InlineParser;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.InlineParserContext;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.SourceLines;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.delimiter.DelimiterProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InlineParserImpl
implements InlineParser,
InlineParserState {
    private final BitSet specialCharacters;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final InlineParserContext context;
    private final Map<Character, List<InlineContentParser>> inlineParsers;
    private Scanner scanner;
    private boolean includeSourceSpans;
    private int trailingSpaces;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(InlineParserContext inlineParserContext) {
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(inlineParserContext.getCustomDelimiterProcessors());
        this.context = inlineParserContext;
        this.inlineParsers = new HashMap<Character, List<InlineContentParser>>();
        this.inlineParsers.put(Character.valueOf('\\'), Collections.singletonList(new BackslashInlineParser()));
        this.inlineParsers.put(Character.valueOf('`'), Collections.singletonList(new BackticksInlineParser()));
        this.inlineParsers.put(Character.valueOf('&'), Collections.singletonList(new EntityInlineParser()));
        this.inlineParsers.put(Character.valueOf('<'), Arrays.asList(new AutolinkInlineParser(), new HtmlInlineParser()));
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.delimiterProcessors.keySet(), this.inlineParsers.keySet());
    }

    public static BitSet calculateSpecialCharacters(Set<Character> delimiterCharacters, Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character c : delimiterCharacters) {
            bitSet.set(c.charValue());
        }
        for (Character c : characters) {
            bitSet.set(c.charValue());
        }
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(33);
        bitSet.set(10);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map2 = new HashMap<Character, DelimiterProcessor>();
        InlineParserImpl.addDelimiterProcessors(Arrays.asList(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), map2);
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map2);
        return map2;
    }

    @Override
    public Scanner scanner() {
        return this.scanner;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map2) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char closing;
            char opening = delimiterProcessor.getOpeningCharacter();
            if (opening == (closing = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor old = map2.get(Character.valueOf(opening));
                if (old != null && old.getOpeningCharacter() == old.getClosingCharacter()) {
                    StaggeredDelimiterProcessor s;
                    if (old instanceof StaggeredDelimiterProcessor) {
                        s = (StaggeredDelimiterProcessor)old;
                    } else {
                        s = new StaggeredDelimiterProcessor(opening);
                        s.add(old);
                    }
                    s.add(delimiterProcessor);
                    map2.put(Character.valueOf(opening), s);
                    continue;
                }
                InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map2);
                continue;
            }
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map2);
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map2);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    @Override
    public void parse(SourceLines lines, Node block) {
        List<? extends Node> nodes;
        this.reset(lines);
        while ((nodes = this.parseInline()) != null) {
            for (Node node2 : nodes) {
                block.appendChild(node2);
            }
        }
        this.processDelimiters(null);
        this.mergeChildTextNodes(block);
    }

    void reset(SourceLines lines) {
        this.scanner = Scanner.of(lines);
        this.includeSourceSpans = !lines.getSourceSpans().isEmpty();
        this.trailingSpaces = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
    }

    private Text text(SourceLines sourceLines) {
        Text text = new Text(sourceLines.getContent());
        text.setSourceSpans(sourceLines.getSourceSpans());
        return text;
    }

    private List<? extends Node> parseInline() {
        List<? extends Node> nodes;
        DelimiterProcessor delimiterProcessor;
        char c = this.scanner.peek();
        switch (c) {
            case '[': {
                return Collections.singletonList(this.parseOpenBracket());
            }
            case '!': {
                return Collections.singletonList(this.parseBang());
            }
            case ']': {
                return Collections.singletonList(this.parseCloseBracket());
            }
            case '\n': {
                return Collections.singletonList(this.parseLineBreak());
            }
            case '\u0000': {
                return null;
            }
        }
        if (!this.specialCharacters.get(c)) {
            return Collections.singletonList(this.parseText());
        }
        List<InlineContentParser> inlineParsers = this.inlineParsers.get(Character.valueOf(c));
        if (inlineParsers != null) {
            Position position = this.scanner.position();
            for (InlineContentParser inlineParser : inlineParsers) {
                ParsedInline parsedInline = inlineParser.tryParse(this);
                if (parsedInline instanceof ParsedInlineImpl) {
                    ParsedInlineImpl parsedInlineImpl = (ParsedInlineImpl)parsedInline;
                    Node node2 = parsedInlineImpl.getNode();
                    this.scanner.setPosition(parsedInlineImpl.getPosition());
                    if (this.includeSourceSpans && node2.getSourceSpans().isEmpty()) {
                        node2.setSourceSpans(this.scanner.getSource(position, this.scanner.position()).getSourceSpans());
                    }
                    return Collections.singletonList(node2);
                }
                this.scanner.setPosition(position);
            }
        }
        if ((delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c))) != null && (nodes = this.parseDelimiters(delimiterProcessor, c)) != null) {
            return nodes;
        }
        return Collections.singletonList(this.parseText());
    }

    private List<? extends Node> parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return null;
        }
        List<Text> characters = res.characters;
        this.lastDelimiter = new Delimiter(characters, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return characters;
    }

    private Node parseOpenBracket() {
        Position start = this.scanner.position();
        this.scanner.next();
        Position contentPosition = this.scanner.position();
        Text node2 = this.text(this.scanner.getSource(start, contentPosition));
        this.addBracket(Bracket.link(node2, start, contentPosition, this.lastBracket, this.lastDelimiter));
        return node2;
    }

    private Node parseBang() {
        Position start = this.scanner.position();
        this.scanner.next();
        if (this.scanner.next('[')) {
            Position contentPosition = this.scanner.position();
            Text node2 = this.text(this.scanner.getSource(start, contentPosition));
            this.addBracket(Bracket.image(node2, start, contentPosition, this.lastBracket, this.lastDelimiter));
            return node2;
        }
        return this.text(this.scanner.getSource(start, this.scanner.position()));
    }

    private Node parseCloseBracket() {
        Position beforeClose = this.scanner.position();
        this.scanner.next();
        Position afterClose = this.scanner.position();
        Bracket opener = this.lastBracket;
        if (opener == null) {
            return this.text(this.scanner.getSource(beforeClose, afterClose));
        }
        if (!opener.allowed) {
            this.removeLastBracket();
            return this.text(this.scanner.getSource(beforeClose, afterClose));
        }
        String dest = null;
        String title = null;
        if (this.scanner.next('(')) {
            this.scanner.whitespace();
            dest = this.parseLinkDestination(this.scanner);
            if (dest == null) {
                this.scanner.setPosition(afterClose);
            } else {
                int whitespace = this.scanner.whitespace();
                if (whitespace >= 1) {
                    title = this.parseLinkTitle(this.scanner);
                    this.scanner.whitespace();
                }
                if (!this.scanner.next(')')) {
                    this.scanner.setPosition(afterClose);
                    dest = null;
                    title = null;
                }
            }
        }
        if (dest == null) {
            String label;
            LinkReferenceDefinition definition;
            String ref = this.parseLinkLabel(this.scanner);
            if (ref == null) {
                this.scanner.setPosition(afterClose);
            }
            if ((ref == null || ref.isEmpty()) && !opener.bracketAfter) {
                ref = this.scanner.getSource(opener.contentPosition, beforeClose).getContent();
            }
            if (ref != null && (definition = this.context.getLinkReferenceDefinition(label = Escaping.normalizeLabelContent(ref))) != null) {
                dest = definition.getDestination();
                title = definition.getTitle();
            }
        }
        if (dest != null) {
            Node linkOrImage = opener.image ? new Image(dest, title) : new Link(dest, title);
            Node node2 = opener.node.getNext();
            while (node2 != null) {
                Node next = node2.getNext();
                linkOrImage.appendChild(node2);
                node2 = next;
            }
            if (this.includeSourceSpans) {
                linkOrImage.setSourceSpans(this.scanner.getSource(opener.markerPosition, this.scanner.position()).getSourceSpans());
            }
            this.processDelimiters(opener.previousDelimiter);
            this.mergeChildTextNodes(linkOrImage);
            opener.node.unlink();
            this.removeLastBracket();
            if (!opener.image) {
                Bracket bracket = this.lastBracket;
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
            }
            return linkOrImage;
        }
        this.removeLastBracket();
        this.scanner.setPosition(afterClose);
        return this.text(this.scanner.getSource(beforeClose, afterClose));
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private String parseLinkDestination(Scanner scanner) {
        String dest;
        char delimiter = scanner.peek();
        Position start = scanner.position();
        if (!LinkScanner.scanLinkDestination(scanner)) {
            return null;
        }
        if (delimiter == '<') {
            String rawDestination = scanner.getSource(start, scanner.position()).getContent();
            dest = rawDestination.substring(1, rawDestination.length() - 1);
        } else {
            dest = scanner.getSource(start, scanner.position()).getContent();
        }
        return Escaping.unescapeString(dest);
    }

    private String parseLinkTitle(Scanner scanner) {
        Position start = scanner.position();
        if (!LinkScanner.scanLinkTitle(scanner)) {
            return null;
        }
        String rawTitle = scanner.getSource(start, scanner.position()).getContent();
        String title = rawTitle.substring(1, rawTitle.length() - 1);
        return Escaping.unescapeString(title);
    }

    String parseLinkLabel(Scanner scanner) {
        if (!scanner.next('[')) {
            return null;
        }
        Position start = scanner.position();
        if (!LinkScanner.scanLinkLabelContent(scanner)) {
            return null;
        }
        Position end = scanner.position();
        if (!scanner.next(']')) {
            return null;
        }
        String content = scanner.getSource(start, end).getContent();
        if (content.length() > 999) {
            return null;
        }
        return content;
    }

    private Node parseLineBreak() {
        this.scanner.next();
        if (this.trailingSpaces >= 2) {
            return new HardLineBreak();
        }
        return new SoftLineBreak();
    }

    private Node parseText() {
        int end;
        char c;
        Position start = this.scanner.position();
        this.scanner.next();
        while ((c = this.scanner.peek()) != '\u0000' && !this.specialCharacters.get(c)) {
            this.scanner.next();
        }
        SourceLines source = this.scanner.getSource(start, this.scanner.position());
        String content = source.getContent();
        if (c == '\n') {
            end = Parsing.skipBackwards(' ', content, content.length() - 1, 0) + 1;
            this.trailingSpaces = content.length() - end;
            content = content.substring(0, end);
        } else if (c == '\u0000') {
            end = Parsing.skipSpaceTabBackwards(content, content.length() - 1, 0) + 1;
            content = content.substring(0, end);
        }
        Text text = new Text(content);
        text.setSourceSpans(source.getSourceSpans());
        return text;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int before = this.scanner.peekPreviousCodePoint();
        Position start = this.scanner.position();
        int delimiterCount = this.scanner.matchMultiple(delimiterChar);
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.scanner.setPosition(start);
            return null;
        }
        ArrayList<Text> delimiters = new ArrayList<Text>();
        this.scanner.setPosition(start);
        Position positionBefore = start;
        while (this.scanner.next(delimiterChar)) {
            delimiters.add(this.text(this.scanner.getSource(positionBefore, this.scanner.position())));
            positionBefore = this.scanner.position();
        }
        int after = this.scanner.peekCodePoint();
        boolean beforeIsPunctuation = before == 0 || Parsing.isPunctuationCodePoint(before);
        boolean beforeIsWhitespace = before == 0 || Parsing.isWhitespaceCodePoint(before);
        boolean afterIsPunctuation = after == 0 || Parsing.isPunctuationCodePoint(after);
        boolean afterIsWhitespace = after == 0 || Parsing.isWhitespaceCodePoint(after);
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        return new DelimiterData(delimiters, canOpen, canClose);
    }

    private void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            Text delimiter;
            int i;
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose() || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int usedDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen() && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    usedDelims = delimiterProcessor.process(opener, closer);
                    if (usedDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen()) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            for (i = 0; i < usedDelims; ++i) {
                delimiter = opener.characters.remove(opener.characters.size() - 1);
                delimiter.unlink();
            }
            for (i = 0; i < usedDelims; ++i) {
                delimiter = closer.characters.remove(0);
                delimiter.unlink();
            }
            this.removeDelimitersBetween(opener, closer);
            if (opener.length() == 0) {
                this.removeDelimiterAndNodes(opener);
            }
            if (closer.length() != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNodes(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNodes(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    private void mergeChildTextNodes(Node node2) {
        if (node2.getFirstChild() == null) {
            return;
        }
        this.mergeTextNodesInclusive(node2.getFirstChild(), node2.getLastChild());
    }

    private void mergeTextNodesInclusive(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node2 = fromNode; node2 != null; node2 = node2.getNext()) {
            if (node2 instanceof Text) {
                Text text = (Text)node2;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                this.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
                this.mergeChildTextNodes(node2);
            }
            if (node2 == toNode) break;
        }
        this.mergeIfNeeded(first, last, length);
    }

    private void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            SourceSpans sourceSpans = null;
            if (this.includeSourceSpans) {
                sourceSpans = new SourceSpans();
                sourceSpans.addAll(first.getSourceSpans());
            }
            Node stop = last.getNext();
            for (Node node2 = first.getNext(); node2 != stop; node2 = node2.getNext()) {
                sb.append(((Text)node2).getLiteral());
                if (sourceSpans != null) {
                    sourceSpans.addAll(node2.getSourceSpans());
                }
                Node unlink = node2;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
            if (sourceSpans != null) {
                first.setSourceSpans(sourceSpans.getSourceSpans());
            }
        }
    }

    private static class DelimiterData {
        final List<Text> characters;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(List<Text> characters, boolean canOpen, boolean canClose) {
            this.characters = characters;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }
}

