/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal;

import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.Position;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.inline.Scanner;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.util.Escaping;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.internal.util.LinkScanner;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.LinkReferenceDefinition;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.node.SourceSpan;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.SourceLine;
import cc.polyfrost.oneconfig.libs.elementa.impl.commonmark.parser.SourceLines;
import java.util.ArrayList;
import java.util.List;

public class LinkReferenceDefinitionParser {
    private State state = State.START_DEFINITION;
    private final List<SourceLine> paragraphLines = new ArrayList<SourceLine>();
    private final List<LinkReferenceDefinition> definitions = new ArrayList<LinkReferenceDefinition>();
    private final List<SourceSpan> sourceSpans = new ArrayList<SourceSpan>();
    private StringBuilder label;
    private String normalizedLabel;
    private String destination;
    private char titleDelimiter;
    private StringBuilder title;
    private boolean referenceValid = false;

    public void parse(SourceLine line) {
        this.paragraphLines.add(line);
        if (this.state == State.PARAGRAPH) {
            return;
        }
        Scanner scanner = Scanner.of(SourceLines.of(line));
        while (scanner.hasNext()) {
            boolean success;
            switch (this.state) {
                case START_DEFINITION: {
                    success = this.startDefinition(scanner);
                    break;
                }
                case LABEL: {
                    success = this.label(scanner);
                    break;
                }
                case DESTINATION: {
                    success = this.destination(scanner);
                    break;
                }
                case START_TITLE: {
                    success = this.startTitle(scanner);
                    break;
                }
                case TITLE: {
                    success = this.title(scanner);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown parsing state: " + (Object)((Object)this.state));
                }
            }
            if (success) continue;
            this.state = State.PARAGRAPH;
            return;
        }
    }

    public void addSourceSpan(SourceSpan sourceSpan) {
        this.sourceSpans.add(sourceSpan);
    }

    SourceLines getParagraphLines() {
        return SourceLines.of(this.paragraphLines);
    }

    List<SourceSpan> getParagraphSourceSpans() {
        return this.sourceSpans;
    }

    List<LinkReferenceDefinition> getDefinitions() {
        this.finishReference();
        return this.definitions;
    }

    State getState() {
        return this.state;
    }

    private boolean startDefinition(Scanner scanner) {
        scanner.whitespace();
        if (!scanner.next('[')) {
            return false;
        }
        this.state = State.LABEL;
        this.label = new StringBuilder();
        if (!scanner.hasNext()) {
            this.label.append('\n');
        }
        return true;
    }

    private boolean label(Scanner scanner) {
        Position start = scanner.position();
        if (!LinkScanner.scanLinkLabelContent(scanner)) {
            return false;
        }
        this.label.append(scanner.getSource(start, scanner.position()).getContent());
        if (!scanner.hasNext()) {
            this.label.append('\n');
            return true;
        }
        if (scanner.next(']')) {
            if (!scanner.next(':')) {
                return false;
            }
            if (this.label.length() > 999) {
                return false;
            }
            String normalizedLabel = Escaping.normalizeLabelContent(this.label.toString());
            if (normalizedLabel.isEmpty()) {
                return false;
            }
            this.normalizedLabel = normalizedLabel;
            this.state = State.DESTINATION;
            scanner.whitespace();
            return true;
        }
        return false;
    }

    private boolean destination(Scanner scanner) {
        scanner.whitespace();
        Position start = scanner.position();
        if (!LinkScanner.scanLinkDestination(scanner)) {
            return false;
        }
        String rawDestination = scanner.getSource(start, scanner.position()).getContent();
        this.destination = rawDestination.startsWith("<") ? rawDestination.substring(1, rawDestination.length() - 1) : rawDestination;
        int whitespace = scanner.whitespace();
        if (!scanner.hasNext()) {
            this.referenceValid = true;
            this.paragraphLines.clear();
        } else if (whitespace == 0) {
            return false;
        }
        this.state = State.START_TITLE;
        return true;
    }

    private boolean startTitle(Scanner scanner) {
        scanner.whitespace();
        if (!scanner.hasNext()) {
            this.state = State.START_DEFINITION;
            return true;
        }
        this.titleDelimiter = '\u0000';
        char c = scanner.peek();
        switch (c) {
            case '\"': 
            case '\'': {
                this.titleDelimiter = c;
                break;
            }
            case '(': {
                this.titleDelimiter = (char)41;
            }
        }
        if (this.titleDelimiter != '\u0000') {
            this.state = State.TITLE;
            this.title = new StringBuilder();
            scanner.next();
            if (!scanner.hasNext()) {
                this.title.append('\n');
            }
        } else {
            this.finishReference();
            this.state = State.START_DEFINITION;
        }
        return true;
    }

    private boolean title(Scanner scanner) {
        Position start = scanner.position();
        if (!LinkScanner.scanLinkTitleContent(scanner, this.titleDelimiter)) {
            return false;
        }
        this.title.append(scanner.getSource(start, scanner.position()).getContent());
        if (!scanner.hasNext()) {
            this.title.append('\n');
            return true;
        }
        scanner.next();
        scanner.whitespace();
        if (scanner.hasNext()) {
            return false;
        }
        this.referenceValid = true;
        this.finishReference();
        this.paragraphLines.clear();
        this.state = State.START_DEFINITION;
        return true;
    }

    private void finishReference() {
        if (!this.referenceValid) {
            return;
        }
        String d = Escaping.unescapeString(this.destination);
        String t = this.title != null ? Escaping.unescapeString(this.title.toString()) : null;
        LinkReferenceDefinition definition = new LinkReferenceDefinition(this.normalizedLabel, d, t);
        definition.setSourceSpans(this.sourceSpans);
        this.sourceSpans.clear();
        this.definitions.add(definition);
        this.label = null;
        this.referenceValid = false;
        this.normalizedLabel = null;
        this.destination = null;
        this.title = null;
    }

    static enum State {
        START_DEFINITION,
        LABEL,
        DESTINATION,
        START_TITLE,
        TITLE,
        PARAGRAPH;

    }
}

