/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.markdown.drawables;

import cc.polyfrost.oneconfig.libs.elementa.components.UIBlock;
import cc.polyfrost.oneconfig.libs.elementa.markdown.DrawState;
import cc.polyfrost.oneconfig.libs.elementa.markdown.HeaderLevelConfig;
import cc.polyfrost.oneconfig.libs.elementa.markdown.MarkdownComponent;
import cc.polyfrost.oneconfig.libs.elementa.markdown.drawables.Drawable;
import cc.polyfrost.oneconfig.libs.elementa.markdown.drawables.HeaderDrawable;
import cc.polyfrost.oneconfig.libs.elementa.markdown.drawables.ParagraphDrawable;
import cc.polyfrost.oneconfig.libs.elementa.markdown.selection.Cursor;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ3\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010,\u001a\u0004\u0018\u00010+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001a\u00105\u001a\u00020$8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00109R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010:\u00a8\u0006;"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/HeaderDrawable;", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/Drawable;", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/MarkdownComponent;", "md", "", "level", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/ParagraphDrawable;", "paragraph", "<init>", "(Lcc/polyfrost/oneconfig/libs/elementa/markdown/MarkdownComponent;ILcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/ParagraphDrawable;)V", "", "mouseX", "mouseY", "", "dragged", "mouseButton", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lcc/polyfrost/oneconfig/libs/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lcc/polyfrost/oneconfig/libs/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;", "matrixStack", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/DrawState;", "state", "", "draw", "(Lcc/polyfrost/oneconfig/libs/universal/UMatrixStack;Lcc/polyfrost/oneconfig/libs/elementa/markdown/DrawState;)V", "x", "y", "width", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "", "dividerWidth", "Ljava/lang/Double;", "getDividerWidth", "()Ljava/lang/Double;", "setDividerWidth", "(Ljava/lang/Double;)V", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/HeaderLevelConfig;", "headerConfig", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/HeaderLevelConfig;", "id", "Ljava/lang/String;", "getId$Elementa", "()Ljava/lang/String;", "I", "Lcc/polyfrost/oneconfig/libs/elementa/markdown/drawables/ParagraphDrawable;", "Elementa"})
public final class HeaderDrawable
extends Drawable {
    private final int level;
    @NotNull
    private final ParagraphDrawable paragraph;
    @NotNull
    private final String id;
    @Nullable
    private Double dividerWidth;
    @NotNull
    private final HeaderLevelConfig headerConfig;

    public HeaderDrawable(@NotNull MarkdownComponent md, int level, @NotNull ParagraphDrawable paragraph) {
        HeaderLevelConfig headerLevelConfig;
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        super(md);
        this.level = level;
        this.paragraph = paragraph;
        this.id = CollectionsKt.joinToString$default((Iterable)this.paragraph.getTextDrawables(), (CharSequence)" ", null, null, (int)0, null, (Function1)id.1.INSTANCE, (int)30, null);
        this.paragraph.setParent(this);
        switch (this.level) {
            case 1: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel1();
                break;
            }
            case 2: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel2();
                break;
            }
            case 3: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel3();
                break;
            }
            case 4: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel4();
                break;
            }
            case 5: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel5();
                break;
            }
            case 6: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel6();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.headerConfig = headerLevelConfig;
        this.paragraph.setHeaderConfig$Elementa(this.headerConfig);
        Drawable.Companion.trim(this.paragraph);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return CollectionsKt.listOf((Object)this.paragraph);
    }

    @NotNull
    public final String getId$Elementa() {
        return this.id;
    }

    @Nullable
    public final Double getDividerWidth() {
        return this.dividerWidth;
    }

    public final void setDividerWidth(@Nullable Double d) {
        this.dividerWidth = d;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float spaceBefore = this.getInsertSpaceBefore() ? this.headerConfig.getVerticalSpaceBefore() : 0.0f;
        float spaceAfter = this.getInsertSpaceAfter() ? this.headerConfig.getVerticalSpaceAfter() : 0.0f;
        this.paragraph.layout(x, y + spaceBefore, width);
        float height = spaceBefore + this.paragraph.getHeight() + spaceAfter + (this.headerConfig.getHasDivider() ? this.headerConfig.getSpaceBeforeDivider() + this.headerConfig.getDividerWidth() : 0.0f);
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, spaceBefore, 0.0f, spaceAfter));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.paragraph.drawCompat(matrixStack, state);
        if (this.headerConfig.getHasDivider()) {
            float y = this.getLayout().getBottom() - this.getLayout().getMargin().getBottom() - this.headerConfig.getDividerWidth();
            Double d = this.dividerWidth;
            UIBlock.Companion.drawBlockSized(matrixStack, this.headerConfig.getDividerColor(), this.getX() + state.getXShift(), y + state.getYShift(), d == null ? (double)this.getWidth() : d, this.headerConfig.getDividerWidth());
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.paragraph.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.paragraph.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.paragraph.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text = this.paragraph.selectedText(asMarkdown);
        return asMarkdown ? StringsKt.repeat((CharSequence)"#", (int)this.level) + ' ' + text : text;
    }
}

