/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.elementa.utils;

import cc.polyfrost.oneconfig.libs.elementa.utils.ObservableAddEvent;
import cc.polyfrost.oneconfig.libs.elementa.utils.ObservableClearEvent;
import cc.polyfrost.oneconfig.libs.elementa.utils.ObservableListEvent;
import cc.polyfrost.oneconfig.libs.elementa.utils.ObservableListKt;
import cc.polyfrost.oneconfig.libs.elementa.utils.ObservableRemoveEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010+\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\t\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\t\u0010\u000eJ%\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0011\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0004\b\u0016\u0010\nJ\u001e\u0010\u0017\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0096\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0018\u0010\u0018\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\bH\u0096\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0096\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0004\b!\u0010\u001bJ\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0096\u0001\u00a2\u0006\u0004\b#\u0010$J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0004\b#\u0010%J\u0017\u0010&\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b&\u0010\nJ\u001d\u0010'\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b'\u0010\u0013J\u0017\u0010(\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b(\u0010\u0019J\u001d\u0010)\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b)\u0010\u0013J \u0010*\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J!\u0010.\u001a\u00020\r2\u0010\u0010-\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010,H\u0016\u00a2\u0006\u0004\b.\u0010/J&\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0096\u0001\u00a2\u0006\u0004\b2\u00103J\u001d\u00106\u001a\u00020\r2\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0002\u00a2\u0006\u0004\b6\u00107R\u0014\u0010:\u001a\u00020\u000b8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010;\u00a8\u0006<"}, d2={"Lcc/polyfrost/oneconfig/libs/elementa/utils/ObservableList;", "T", "", "Ljava/util/Observable;", "wrapped", "<init>", "(Ljava/util/List;)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(ILjava/util/Collection;)Z", "(Ljava/util/Collection;)Z", "clear", "()V", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "lastIndexOf", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "Ljava/util/Comparator;", "c", "sort", "(Ljava/util/Comparator;)V", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "Lcc/polyfrost/oneconfig/libs/elementa/utils/ObservableListEvent;", "event", "update", "(Lcc/polyfrost/oneconfig/libs/elementa/utils/ObservableListEvent;)V", "getSize", "()I", "size", "Ljava/util/List;", "Elementa"})
public final class ObservableList<T>
extends Observable
implements List<T>,
KMutableList {
    @NotNull
    private final List<T> wrapped;

    public ObservableList(@NotNull List<T> wrapped) {
        Intrinsics.checkNotNullParameter(wrapped, (String)"wrapped");
        this.wrapped = wrapped;
    }

    public int getSize() {
        return this.wrapped.size();
    }

    @Override
    public boolean contains(Object element) {
        return this.wrapped.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.wrapped.containsAll(elements);
    }

    @Override
    public T get(int index) {
        return this.wrapped.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.wrapped.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.wrapped.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.wrapped.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.wrapped.listIterator(index);
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.wrapped.subList(fromIndex, toIndex);
    }

    private final void update(ObservableListEvent<T> event) {
        this.setChanged();
        this.notifyObservers(event);
    }

    @Override
    public boolean add(T element) {
        if (this.wrapped.add(element)) {
            this.update(new ObservableAddEvent<T>(ObservableListKt.withIndex(element, CollectionsKt.getLastIndex(this.wrapped))));
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, T element) {
        this.wrapped.add(index, element);
        this.update(new ObservableAddEvent<T>(ObservableListKt.withIndex(element, index)));
    }

    @Override
    public boolean remove(Object element) {
        int index = this.wrapped.indexOf(element);
        if (index != -1) {
            this.wrapped.remove(index);
            this.update(new ObservableRemoveEvent<Object>(ObservableListKt.withIndex(element, index)));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = this.wrapped.size();
        if (this.wrapped.addAll(elements)) {
            Iterable $this$forEachIndexed$iv = elements;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void element;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int i = n;
                boolean bl = false;
                this.update(new ObservableAddEvent<void>(ObservableListKt.withIndex(element, i + size)));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.wrapped.addAll(index, elements)) {
            Iterable $this$forEachIndexed$iv = elements;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void element;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int i = n;
                boolean bl = false;
                this.update(new ObservableAddEvent<void>(ObservableListKt.withIndex(element, i + index)));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = elements;
        boolean initial$iv = false;
        boolean $i$f$fold = false;
        boolean accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void element;
            Object element$iv;
            Object t = element$iv = iterator.next();
            boolean acc = accumulator$iv;
            boolean bl = false;
            int index = this.wrapped.indexOf(element);
            if (index != -1) {
                this.wrapped.remove(index);
                this.update(new ObservableRemoveEvent<void>(ObservableListKt.withIndex(element, index)));
            }
            accumulator$iv = acc || index != -1;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = this.wrapped;
        ObservableList observableList = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!elements.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return observableList.removeAll((List)destination$iv$iv);
    }

    @Override
    public void sort(@Nullable Comparator<? super T> c) {
        Collections.sort(this.wrapped, c);
    }

    @Override
    public void clear() {
        List oldChildren = CollectionsKt.toList((Iterable)this.wrapped);
        this.wrapped.clear();
        this.update(new ObservableClearEvent(oldChildren));
    }

    @Override
    public T set(int index, T element) {
        T t;
        T it = t = this.wrapped.set(index, element);
        boolean bl = false;
        this.update(new ObservableRemoveEvent<T>(ObservableListKt.withIndex(it, index)));
        this.update(new ObservableAddEvent<T>(ObservableListKt.withIndex(element, index)));
        return t;
    }

    public T removeAt(int index) {
        T t;
        T it = t = this.wrapped.remove(index);
        boolean bl = false;
        this.update(new ObservableRemoveEvent<T>(ObservableListKt.withIndex(it, index)));
        return t;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

