/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher;

import cc.polyfrost.oneconfig.libs.universal.UDesktop;
import cc.polyfrost.oneconfig.utils.Multithreading;
import cc.polyfrost.oneconfig.utils.NetworkUtils;
import cc.polyfrost.oneconfig.utils.Notifications;
import cc.polyfrost.oneconfig.utils.commands.CommandManager;
import club.sk1er.patcher.asm.render.screen.GuiChatTransformer;
import club.sk1er.patcher.commands.PatcherCommand;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.config.PatcherSoundConfig;
import club.sk1er.patcher.ducks.FontRendererExt;
import club.sk1er.patcher.hooks.EntityRendererHook;
import club.sk1er.patcher.hooks.MinecraftHook;
import club.sk1er.patcher.render.ScreenshotPreview;
import club.sk1er.patcher.screen.PatcherMenuEditor;
import club.sk1er.patcher.screen.render.caching.HUDCaching;
import club.sk1er.patcher.screen.render.overlay.ArmorStatusRenderer;
import club.sk1er.patcher.screen.render.overlay.GlanceRenderer;
import club.sk1er.patcher.screen.render.overlay.ImagePreview;
import club.sk1er.patcher.screen.render.overlay.metrics.MetricsRenderer;
import club.sk1er.patcher.screen.render.title.TitleFix;
import club.sk1er.patcher.tweaker.PatcherTweaker;
import club.sk1er.patcher.util.chat.ChatHandler;
import club.sk1er.patcher.util.enhancement.EnhancementManager;
import club.sk1er.patcher.util.enhancement.ReloadListener;
import club.sk1er.patcher.util.forge.EntrypointCaching;
import club.sk1er.patcher.util.fov.FovHandler;
import club.sk1er.patcher.util.keybind.FunctionKeyChanger;
import club.sk1er.patcher.util.keybind.KeybindDropModifier;
import club.sk1er.patcher.util.keybind.MousePerspectiveKeybindHandler;
import club.sk1er.patcher.util.keybind.linux.LinuxKeybindFix;
import club.sk1er.patcher.util.screenshot.AsyncScreenshots;
import club.sk1er.patcher.util.status.ProtocolVersionDetector;
import club.sk1er.patcher.util.world.SavesWatcher;
import club.sk1er.patcher.util.world.render.culling.EntityCulling;
import club.sk1er.patcher.util.world.render.entity.EntityRendering;
import club.sk1er.patcher.util.world.sound.SoundHandler;
import club.sk1er.patcher.util.world.sound.audioswitcher.AudioSwitcher;
import com.google.gson.JsonObject;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="patcher", name="Patcher", version="1.10.3", clientSideOnly=true)
public class Patcher {
    @Mod.Instance(value="patcher")
    public static Patcher instance;
    public static final String VERSION = "1.10.3";
    private final Logger logger = LogManager.getLogger((String)"Patcher");
    private final File logsDirectory;
    private final Set<String> blacklistedServers;
    private final File blacklistedServersFile;
    private final SavesWatcher savesWatcher;
    private final AudioSwitcher audioSwitcher;
    private KeyBinding dropModifier;
    private KeyBinding hideScreen;
    private KeyBinding customDebug;
    private KeyBinding clearShaders;
    private PatcherConfig patcherConfig;
    private PatcherSoundConfig patcherSoundConfig;
    private boolean loadedGalacticFontRenderer;
    private boolean isEssential;

    public Patcher() {
        this.logsDirectory = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "logs" + File.separator);
        this.blacklistedServers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.blacklistedServersFile = new File("./config/blacklisted_servers.txt");
        this.savesWatcher = new SavesWatcher();
        this.audioSwitcher = new AudioSwitcher();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        EntrypointCaching.INSTANCE.onInit();
        this.dropModifier = new KeybindDropModifier();
        this.hideScreen = new FunctionKeyChanger.KeybindHideScreen();
        this.customDebug = new FunctionKeyChanger.KeybindCustomDebug();
        this.clearShaders = new FunctionKeyChanger.KeybindClearShaders();
        this.registerKeybinds(this.dropModifier, this.hideScreen, this.customDebug, this.clearShaders);
        this.patcherConfig = PatcherConfig.INSTANCE;
        this.patcherSoundConfig = new PatcherSoundConfig(null, null);
        SoundHandler soundHandler = new SoundHandler();
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        resourceManager.func_110542_a((IResourceManagerReloadListener)soundHandler);
        resourceManager.func_110542_a((IResourceManagerReloadListener)new ReloadListener());
        this.registerCommands(new PatcherCommand(), new AsyncScreenshots.FavoriteScreenshot(), new AsyncScreenshots.DeleteScreenshot(), new AsyncScreenshots.UploadScreenshot(), new AsyncScreenshots.CopyScreenshot(), new AsyncScreenshots.ScreenshotsFolder());
        this.registerEvents(new Object[]{this, soundHandler, this.dropModifier, this.audioSwitcher, new EntityRendering(), new FovHandler(), new ChatHandler(), new GlanceRenderer(), new EntityCulling(), new ArmorStatusRenderer(), new PatcherMenuEditor(), new ImagePreview(), new TitleFix(), new LinuxKeybindFix(), new MetricsRenderer(), new HUDCaching(), new EntityRendererHook(), MinecraftHook.INSTANCE, ScreenshotPreview.INSTANCE, new MousePerspectiveKeybindHandler()});
        this.checkLogs();
        this.loadBlacklistedServers();
        this.fixSettings();
        this.savesWatcher.watch();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (!this.loadedGalacticFontRenderer) {
            this.loadedGalacticFontRenderer = true;
            FontRenderer galacticFontRenderer = Minecraft.func_71410_x().field_71464_q;
            if (galacticFontRenderer instanceof FontRendererExt) {
                ((FontRendererExt)galacticFontRenderer).patcher$getFontRendererHook().create();
            }
        }
        this.isEssential = Loader.isModLoaded((String)"essential");
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        List activeModList = Loader.instance().getActiveModList();
        Notifications notifications = Notifications.INSTANCE;
        this.detectIncompatibilities(activeModList, notifications);
        this.detectReplacements(activeModList, notifications);
        long time = System.currentTimeMillis() - PatcherTweaker.clientLoadTime;
        if (PatcherConfig.startupNotification) {
            notifications.send("Minecraft Startup", "Minecraft started in " + time / 1000L + " seconds.");
        }
        this.logger.info("Minecraft started in {}ms.", new Object[]{time});
        if (!"1.8.9".equals("1.8.9") || ForgeVersion.getVersion().contains("2318")) {
            return;
        }
        notifications.send("Patcher", "Outdated Forge has been detected (" + ForgeVersion.getVersion() + "). Click to open the Forge website to download the latest version.", 30000.0f, () -> {
            String updateLink = "https://files.minecraftforge.net/net/minecraftforge/forge/index_1.8.9.html";
            try {
                UDesktop.browse((URI)URI.create(updateLink));
            }
            catch (Exception openException) {
                this.logger.error("Failed to open Forge website.", (Throwable)openException);
                notifications.send("Patcher", "Failed to open Forge website. Link is now copied to your clipboard.");
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(updateLink), null);
                }
                catch (Exception clipboardException) {
                    this.logger.error("Failed to copy Forge website to clipboard.", (Throwable)clipboardException);
                    notifications.send("Patcher", "Failed to copy Forge website to clipboard.");
                }
            }
        });
    }

    @SubscribeEvent
    public void connectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (event.isLocal) {
            GuiChatTransformer.maxChatLength = 256;
            return;
        }
        String serverIP = Minecraft.func_71410_x().func_147104_D().field_78845_b;
        if (serverIP == null || this.blacklistedServers.contains(serverIP)) {
            GuiChatTransformer.maxChatLength = 100;
            return;
        }
        boolean compatible = ProtocolVersionDetector.instance.isCompatibleWithVersion(serverIP, 315);
        GuiChatTransformer.maxChatLength = compatible ? 256 : 100;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EnhancementManager.getInstance().tick();
        }
    }

    private void checkLogs() {
        if (PatcherConfig.logOptimizer && this.logsDirectory.exists()) {
            File[] files = this.logsDirectory.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith("log.gz") || file.lastModified() > System.currentTimeMillis() - (long)PatcherConfig.logOptimizerLength * 86400000L) continue;
                file.delete();
            }
        }
    }

    private void registerKeybinds(KeyBinding ... keybinds) {
        for (KeyBinding keybind : keybinds) {
            ClientRegistry.registerKeyBinding((KeyBinding)keybind);
        }
    }

    private void registerEvents(Object ... events) {
        for (Object event : events) {
            MinecraftForge.EVENT_BUS.register(event);
        }
    }

    private void registerCommands(Object ... commands) {
        for (Object command : commands) {
            CommandManager.register((Object)command);
        }
    }

    private boolean isServerBlacklisted(String ip) {
        if (ip == null) {
            return false;
        }
        String trim = ip.trim();
        return !trim.isEmpty() && this.blacklistedServers.contains(trim);
    }

    public boolean addOrRemoveBlacklist(String input) {
        if (input == null || input.isEmpty() || input.trim().isEmpty()) {
            return false;
        }
        if (this.isServerBlacklisted(input = input.trim())) {
            this.blacklistedServers.remove(input);
            return false;
        }
        this.blacklistedServers.add(input);
        return true;
    }

    public void saveBlacklistedServers() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.blacklistedServersFile));){
            File parentFile = this.blacklistedServersFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                return;
            }
            if (!this.blacklistedServersFile.exists() && !this.blacklistedServersFile.createNewFile()) {
                return;
            }
            for (String server : this.blacklistedServers) {
                writer.write(server + System.lineSeparator());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save blacklisted servers.", (Throwable)e);
        }
    }

    private void loadBlacklistedServers() {
        if (!this.blacklistedServersFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.blacklistedServersFile));){
            String servers;
            while ((servers = reader.readLine()) != null) {
                this.blacklistedServers.add(servers);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load blacklisted servers.", (Throwable)e);
        }
    }

    private void fixSettings() {
        if (PatcherConfig.fireOverlayHeight < -0.5f || PatcherConfig.fireOverlayHeight > 1.5f) {
            PatcherConfig.fireOverlayHeight = 0.0f;
        }
        if (PatcherConfig.customZoomSensitivity > 1.0f) {
            PatcherConfig.customZoomSensitivity = 1.0f;
        }
        if (PatcherConfig.imagePreviewWidth > 1.0f) {
            PatcherConfig.imagePreviewWidth = 0.5f;
        }
        if (PatcherConfig.previewScale > 1.0f) {
            PatcherConfig.previewScale = 1.0f;
        }
        if (PatcherConfig.unfocusedFPSAmount < 15) {
            PatcherConfig.unfocusedFPSAmount = 15;
        }
        this.forceSaveConfig();
    }

    private void detectIncompatibilities(List<ModContainer> activeModList, Notifications notifications) {
        for (ModContainer container : activeModList) {
            String modId = container.getModId();
            String baseMessage = container.getName() + " has been detected. ";
            if (PatcherConfig.entityCulling && modId.equals("enhancements")) {
                notifications.send("Patcher", baseMessage + "Entity Culling is now disabled.");
                PatcherConfig.entityCulling = false;
            }
            if ((modId.equals("labymod") || modId.equals("enhancements") || modId.equals("hychat")) && PatcherConfig.compactChat) {
                notifications.send("Patcher", baseMessage + "Compact Chat is now disabled.");
                PatcherConfig.compactChat = false;
            }
            if (!PatcherConfig.optimizedFontRenderer || !modId.equals("smoothfont")) continue;
            notifications.send("Patcher", baseMessage + "Optimized Font Renderer is now disabled.");
            PatcherConfig.optimizedFontRenderer = false;
        }
        try {
            Class.forName("net.labymod.addons.resourcepacks24.Resourcepacks24", false, this.getClass().getClassLoader());
            notifications.send("Patcher", "The LabyMod addon \"Resourcepacks24\" conflicts with Patcher's resourcepack optimizations. Please remove it to make it work again.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.forceSaveConfig();
    }

    private void detectReplacements(List<ModContainer> activeModList, Notifications notifications) {
        Multithreading.runAsync(() -> {
            JsonObject replacedMods;
            try {
                replacedMods = NetworkUtils.getJsonElement((String)"https://static.sk1er.club/patcher/duplicate_mods.json").getAsJsonObject();
            }
            catch (Exception e) {
                this.logger.error("Failed to fetch list of replaced mods at \"https://static.sk1er.club/patcher/duplicate_mods.json\".", (Throwable)e);
                return;
            }
            if (replacedMods == null) {
                return;
            }
            HashSet<String> replacements = new HashSet<String>();
            Set modids = replacedMods.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
            for (ModContainer modContainer : activeModList) {
                if (!modids.contains(modContainer.getModId())) continue;
                replacements.add(modContainer.getName());
            }
            if (!replacements.isEmpty()) {
                for (String replacement : replacements) {
                    if (replacement.equals("Clean View")) {
                        notifications.send("PolyPatcher", replacement + " can be removed as it is replaced by OverflowParticles. Click here to download OverflowParticles", 6.0f, () -> UDesktop.browse((URI)URI.create("https://modrinth.com/mod/overflowparticles")));
                        continue;
                    }
                    notifications.send("PolyPatcher", replacement + " can be removed as it is replaced by PolyPatcher.", 6.0f);
                }
            }
        });
    }

    public PatcherConfig getPatcherConfig() {
        return this.patcherConfig;
    }

    public PatcherSoundConfig getPatcherSoundConfig() {
        return this.patcherSoundConfig;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public KeyBinding getDropModifier() {
        return this.dropModifier;
    }

    public KeyBinding getHideScreen() {
        return this.hideScreen;
    }

    public KeyBinding getCustomDebug() {
        return this.customDebug;
    }

    public KeyBinding getClearShaders() {
        return this.clearShaders;
    }

    public AudioSwitcher getAudioSwitcher() {
        return this.audioSwitcher;
    }

    public void forceSaveConfig() {
        this.patcherConfig.save();
    }

    public boolean isEssential() {
        return this.isEssential;
    }
}

