/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.asm.external.forge.loader;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class JarDiscovererTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraftforge.fml.common.discovery.JarDiscoverer"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            boolean isDiscover = method.name.equals("discover");
            boolean isFindClassesASM = false;
            if (!isDiscover && !isFindClassesASM) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof MethodInsnNode)) continue;
                MethodInsnNode insn = (MethodInsnNode)next;
                switch (insn.name) {
                    case "entries": {
                        method.instructions.insertBefore(next, this.discoverCachedJar());
                        break;
                    }
                    case "addClassEntry": {
                        method.instructions.insert(next, this.putCachedClass(false));
                        break;
                    }
                    case "bindMetadata": {
                        method.instructions.insert(next, this.putCachedClass(true));
                    }
                }
            }
        }
    }

    private void getInstance(InsnList list) {
        list.add((AbstractInsnNode)new FieldInsnNode(178, "club/sk1er/patcher/util/forge/EntrypointCaching", "INSTANCE", "Lclub/sk1er/patcher/util/forge/EntrypointCaching;"));
    }

    private InsnList discoverCachedJar() {
        InsnList list = new InsnList();
        this.getInstance(list);
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 4));
        list.add((AbstractInsnNode)new VarInsnNode(25, 6));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "club/sk1er/patcher/util/forge/EntrypointCaching", "discoverCachedEntrypoints", "(Lnet/minecraftforge/fml/common/discovery/ModCandidate;Lnet/minecraftforge/fml/common/discovery/ASMDataTable;Ljava/util/jar/JarFile;Lnet/minecraftforge/fml/common/MetadataCollection;)Ljava/util/List;", false));
        list.add((AbstractInsnNode)new InsnNode(89));
        LabelNode normalDiscovery = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(198, normalDiscovery));
        list.add((AbstractInsnNode)new InsnNode(176));
        list.add((AbstractInsnNode)normalDiscovery);
        list.add((AbstractInsnNode)new InsnNode(87));
        return list;
    }

    private InsnList putCachedClass(boolean entry) {
        InsnList list = new InsnList();
        this.getInstance(list);
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new VarInsnNode(25, 8));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "club/sk1er/patcher/util/forge/EntrypointCaching", entry ? "putCachedEntrypoints" : "putCachedClassEntries", "(Lnet/minecraftforge/fml/common/discovery/ModCandidate;Ljava/util/zip/ZipEntry;)V", false));
        return list;
    }
}

