/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.Button;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.Info;
import cc.polyfrost.oneconfig.config.annotations.Number;
import cc.polyfrost.oneconfig.config.annotations.Slider;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.config.migration.Migrator;
import cc.polyfrost.oneconfig.config.migration.VigilanceMigrator;
import cc.polyfrost.oneconfig.config.migration.VigilanceName;
import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.OldPatcherConfig;
import club.sk1er.patcher.tweaker.ClassTransformer;
import club.sk1er.patcher.util.forge.EntrypointCaching;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class PatcherConfig
extends Config {
    @Switch(name="Keep Shaders on Perspective Change", description="Resolve Vanilla shaders being cleared when changing perspective.", category="Bug Fixes", subcategory="General", size=2)
    public static boolean keepShadersOnPerspectiveChange = true;
    @Switch(name="Parallax Fix", description="Resolve the camera being too far back, seemingly making your eyes be in the back of your head.", category="Bug Fixes", subcategory="General", size=2)
    public static boolean parallaxFix;
    @Info(text="Culling Fix can negatively impact performance.", category="Bug Fixes", subcategory="General", type=InfoType.ERROR)
    private static String cullingFixInfo;
    @Switch(name="Culling Fix", description="Resolve false negatives in frustum culling, creating invisible chunks in some cases.", category="Bug Fixes", subcategory="General")
    public static boolean cullingFix;
    @Switch(name="Resource Exploit Fix", description="Resolve an exploit in 1.8 allowing servers to look through directories.", category="Bug Fixes", subcategory="Security")
    public static boolean resourceExploitFix;
    @Switch(name="Layers In Tab", description="Resolve players sometimes not having a hat layer in Tab.", category="Bug Fixes", subcategory="General")
    public static boolean layersInTab;
    @Switch(name="Player Void Rendering", description="Resolve the black box around the player while in the void.", category="Bug Fixes", subcategory="Rendering", size=2)
    public static boolean playerVoidRendering;
    @Info(text="OptiFine Custom Sky Fix also changes the rendering of the normal sky. Some people may prefer the original rendering.", category="Bug Fixes", subcategory="Rendering", type=InfoType.WARNING, size=2)
    private static String customSkyFixInfo;
    @Switch(name="OptiFine Custom Sky Fix", description="Resolve OptiFine creating a \"black box\" effect at the bottom of the sky when using custom skies.", category="Bug Fixes", subcategory="Rendering", size=2)
    public static boolean customSkyFix;
    @Info(text="Alex Arm Position requires a restart once toggled.", category="Bug Fixes", subcategory="Rendering", type=InfoType.WARNING)
    private static String fixedAlexArmsInfo;
    @Switch(name="Alex Arm Position", description="Resolve Alex-model arms being shifted down further than Steve-model arms.", category="Bug Fixes", subcategory="Rendering")
    public static boolean fixedAlexArms;
    @Switch(name="Add Background to Book GUI", description="Adds the dark background to the book GUI like all other containers/menus.", category="Bug Fixes", subcategory="Rendering")
    public static boolean bookBackground;
    @Dropdown(name="Keyboard Layout", description="The layout of your keyboard, used to fix input bugs accordingly.", category="Bug Fixes", subcategory="Linux", options={"QWERTY", "BE AZERTY", "FR AZERTY", "DE QWERTZ"})
    public static int keyboardLayout;
    @Switch(name="Vanilla Held Item Lighting", description="Amends a Forge bug causing item sides to have incorrect lighting compared to Vanilla 1.8.", category="Bug Fixes", subcategory="Forge")
    public static boolean heldItemLighting;
    @Switch(name="Vanilla Glass Panes", description="Reverts a Forge change causing Glass Panes and Iron Bars to connect where they shouldn't.", category="Bug Fixes", subcategory="Forge")
    public static boolean vanillaGlassPanes;
    @Info(text="Better Keybind Handling does not work on macOS due to LWJGL issues.", category="Miscellaneous", subcategory="General", type=InfoType.ERROR, size=2)
    private static String betterKeybindHandlingInfo;
    @Switch(name="Better Keybind Handling", description="Make keys re-register when closing a GUI, like in 1.12+.", category="Miscellaneous", subcategory="General")
    public static boolean newKeybindHandling;
    @Switch(name="Separate Sound & Texture Reloading", description="Separate reloading resources into reloading sounds (F3+S) and reloading textures (F3+T).", category="Miscellaneous", subcategory="General")
    public static boolean separateResourceLoading;
    @Info(text="Fullbright can positively impact performance. It may conflict with minimaps mods.", category="Miscellaneous", subcategory="Rendering", type=InfoType.WARNING, size=2)
    private static String fullbrightInfo;
    @Switch(name="Fullbright", description="Remove lighting updates, increasing visibility.", category="Miscellaneous", subcategory="Rendering")
    public static boolean fullbright;
    @Switch(name="Smart Fullbright", description="Automatically disable the Fullbright effect when using OptiFine shaders.", category="Miscellaneous", subcategory="Rendering")
    public static boolean smartFullbright;
    @Switch(name="Disable Night Vision", description="Completely disable the effects of night vision.", category="Miscellaneous", subcategory="Overlays")
    public static boolean disableNightVision;
    @Switch(name="Cleaner Night Vision", description="Make the night vision effect fade out instead of a flashing effect.", category="Miscellaneous", subcategory="Overlays")
    public static boolean cleanerNightVision;
    @Switch(name="Disable Achievements", description="Remove achievement notifications.", category="Miscellaneous", subcategory="Overlays")
    public static boolean disableAchievements;
    @Slider(name="Fire Overlay Height", description="Change the height of the fire overlay.", category="Miscellaneous", subcategory="Overlays", min=-0.5f, max=1.5f)
    public static float fireOverlayHeight;
    @Slider(name="Fire Overlay Opacity (%)", description="Change the opacity of the fire overlay.", category="Miscellaneous", subcategory="Overlays", min=0.0f, max=100.0f)
    public static int fireOverlayOpacityI;
    @Switch(name="Hide Fire Overlay with Fire Resistance", description="Hide the fire overlay when you have fire resistance active.\nThe overlay will blink 5 seconds before your fire resistance is about to run out.", category="Miscellaneous", subcategory="Overlays")
    public static boolean hideFireOverlayWithFireResistance;
    @Slider(name="Pumpkin Overlay Opacity (%)", description="Change the opacity of the pumpkin overlay.", category="Miscellaneous", subcategory="Overlays", min=0.0f, max=100.0f)
    public static int pumpkinOverlayOpacity;
    @Switch(name="Automatically Scale Title", description="Automatically scale titles if the title goes over the screen.", category="Miscellaneous", subcategory="Titles")
    public static boolean autoTitleScale;
    @Switch(name="Remove Water FOV", description="Remove FOV change when underwater.", category="Miscellaneous", subcategory="Field of View")
    public static boolean removeWaterFov;
    @Switch(name="FOV Modifier", description="Allow for modifying FOV change states.", category="Miscellaneous", subcategory="Field of View")
    public static boolean allowFovModifying;
    @Slider(name="Sprinting FOV", description="Modify your FOV when sprinting.", category="Miscellaneous", subcategory="Field of View", min=-5.0f, max=5.0f)
    public static float sprintingFovModifierFloat;
    @Slider(name="Flying FOV", description="Modify your FOV when flying.", category="Miscellaneous", subcategory="Field of View", min=-5.0f, max=5.0f)
    public static float flyingFovModifierFloat;
    @Slider(name="Bow FOV", description="Modify your FOV when pulling back a bow.", category="Miscellaneous", subcategory="Field of View", min=-5.0f, max=5.0f)
    public static float bowFovModifierFloat;
    @Slider(name="Speed FOV", description="Modify your FOV when having the speed effect.", category="Miscellaneous", subcategory="Field of View", min=-5.0f, max=5.0f)
    public static float speedFovModifierFloat;
    @Slider(name="Slowness FOV", description="Modify your FOV when having the slowness effect.", category="Miscellaneous", subcategory="Field of View", min=-5.0f, max=5.0f)
    public static float slownessFovModifierFloat;
    @Switch(name="Disable Hotbar Scrolling", description="Remove the ability to scroll through your hotbar.", category="Miscellaneous", subcategory="General")
    public static boolean disableHotbarScrolling;
    @Switch(name="Invert Hotbar Scrolling", description="Change the direction of scrolling in your hotbar.", category="Miscellaneous", subcategory="General")
    public static boolean invertHotbarScrolling;
    @Switch(name="Prevent Overflow Hotbar Scrolling", description="Prevent from directly scrolling between the first and last hotbar slot.", category="Miscellaneous", subcategory="General")
    public static boolean preventOverflowHotbarScrolling;
    @Slider(name="Unfocused Sounds", description="Change the volume of sounds when you're not tabbed into the window.", category="Miscellaneous", subcategory="General", min=0.0f, max=1.0f)
    public static float unfocusedSounds;
    @Switch(name="Unfocused FPS", description="Toggle changing your FPS to whatever Unfocused FPS is set to when not tabbed into the window.", category="Miscellaneous", subcategory="General")
    public static boolean unfocusedFPS;
    @Slider(name="Unfocused FPS Amount", description="Change the maximum FPS when you're not tabbed into the window, saving resources.", category="Miscellaneous", subcategory="General", min=15.0f, max=240.0f)
    public static int unfocusedFPSAmount;
    @Number(name="Custom FPS Limit", description="Change the maximum FPS to a value that Minecraft doesn't normally allow for. Setting this to 0 will go back to the value set in Minecraft.", category="Miscellaneous", subcategory="General", min=0.0f, max=2.1474836E9f)
    public static int customFpsLimit;
    @Switch(name="Remove Ground Foliage", description="Stop plants/flowers from rendering.", category="Miscellaneous", subcategory="Blocks")
    public static boolean removeGroundFoliage;
    @Switch(name="Clean Projectiles", description="Show projectiles 2 ticks after they're shot to stop them from obstructing your view.", category="Miscellaneous", subcategory="Rendering")
    public static boolean cleanProjectiles;
    @Slider(name="Ridden Horse Opacity (%)", description="Change the opacity of the horse you're currently riding for visibility.", category="Miscellaneous", subcategory="Rendering", min=0.0f, max=100.0f)
    public static int riddenHorseOpacityI;
    @Slider(name="Distortion Effects (%)", description="Changes the distortion effects (e.g. Nausea and nether portal distortion).", category="Miscellaneous", subcategory="Rendering", min=0.0f, max=100.0f)
    public static int distortionEffect;
    @Slider(name="Water Fog Density (%)", description="Changes the fog density in water to improve visibility.", category="Miscellaneous", subcategory="Fog", min=0.0f, max=100.0f)
    public static int waterDensity;
    @Switch(name="Hide Aura on Invisible Withers", description="Don't render the aura around a wither when it is invisible.", category="Miscellaneous", subcategory="Rendering")
    public static boolean hideAuraOnInvisibleWither;
    @Switch(name="Zoom Adjustment", description="Scroll when using OptiFine's zoom to adjust the zoom level.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean scrollToZoom;
    @Switch(name="Remove Smooth Camera While Zoomed", description="Remove the smooth camera effect when using zoom.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean normalZoomSensitivity;
    @Switch(name="Render Hand While Zoomed", description="Keep your hand on screen when you zoom in.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean renderHandWhenZoomed;
    @Slider(name="Zoom Sensitivity", description="Use a custom mouse sensitivity value when zoomed in.", category="Miscellaneous", subcategory="OptiFine", min=0.0f, max=1.0f)
    public static float customZoomSensitivity;
    @Switch(name="Dynamic Zoom Sensitivity", description="Reduce your mouse sensitivity the more you zoom in.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean dynamicZoomSensitivity;
    @Switch(name="Smooth Zoom Animation", description="Add a smooth animation when you zoom in and out.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean smoothZoomAnimation;
    @Switch(name="Smooth Scroll-to-Zoom Animation", description="Add a smooth animation when you scroll in and out while zoomed.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean smoothZoomAnimationWhenScrolling;
    @Dropdown(name="Smooth Zoom Function", description="Change the smoothing function used in the smooth zooming animation.", category="Miscellaneous", subcategory="OptiFine", options={"In Out Quad", "In Out Circular", "Out Quint"})
    public static int smoothZoomAlgorithm;
    @Switch(name="Toggle to Zoom", description="Make OptiFine's zoom key a toggle instead of requiring you to hold it.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean toggleToZoom;
    @Switch(name="Simplify FPS Counter", description="Remove the extra FPS counter added by OptiFine.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean normalFpsCounter;
    @Switch(name="Use Vanilla Metrics Renderer", description="Replace OptiFine's ALT+F3 metrics renderer with the Vanilla renderer.", category="Miscellaneous", subcategory="OptiFine")
    public static boolean useVanillaMetricsRenderer;
    @Switch(name="Numerical Enchantments", description="Use readable numbers instead of Roman numerals on enchants.", category="Miscellaneous", subcategory="Rendering")
    public static boolean numericalEnchants;
    @Switch(name="Translate Unknown Roman Numerals", description="Generate Roman numeral from enchantment and potion levels instead of using language file.", category="Miscellaneous", subcategory="Rendering")
    public static boolean betterRomanNumerals;
    @Switch(name="Windowed Fullscreen", description="Implement Windowed Fullscreen in Minecraft, allowing you to drag your mouse outside the window.", category="Miscellaneous", subcategory="Window")
    public static boolean windowedFullscreen;
    @Switch(name="Instant Fullscreen", description="Instant switching between fullscreen and non-fullscreen modes.", category="Miscellaneous", subcategory="Window")
    public static boolean instantFullscreen;
    @Switch(name="Remove Water Overlay", description="Remove the water texture overlay when underwater.", category="Miscellaneous", subcategory="Overlays")
    public static boolean removeWaterOverlay;
    @Switch(name="Disable Lightning Bolts", description="Stop lightning bolts from appearing.", category="Miscellaneous", subcategory="Rendering")
    public static boolean disableLightningBolts;
    @Info(text="Files deleted by Log Optimizer are not recoverable.", category="Miscellaneous", subcategory="General", type=InfoType.WARNING)
    private static boolean logOptimizerInfo;
    @Switch(name="Log Optimizer", description="Delete all files in the logs folder, as these can usually take up a lot of space.", category="Miscellaneous", subcategory="General")
    public static boolean logOptimizer;
    @Slider(name="Log Optimizer Amount", description="Choose how many days old a file must be before being deleted.", category="Miscellaneous", subcategory="General", min=1.0f, max=90.0f)
    public static int logOptimizerLength;
    @Info(text="1.12 Farm Selection Boxes only works on Hypixel & Singleplayer.", category="Miscellaneous", subcategory="Blocks", type=InfoType.WARNING, size=2)
    private static boolean farmSelectionBoxesInfo;
    @Switch(name="1.12 Farm Selection Boxes", description="Replaces the selection box for crops with the 1.12 variant.", category="Miscellaneous", subcategory="Blocks")
    public static boolean futureHitBoxes;
    @Info(text="Exclude Cacti from 1.12 Boxes requires a restart once toggled.", category="Miscellaneous", subcategory="Blocks", type=InfoType.WARNING, size=2)
    private static boolean cactusHitboxExclusionInfo;
    @Switch(name="Exclude Cacti from 1.12 Boxes", description="Exclude cacti from the 1.12 selection box changes, as it would actually shrink rather than increase in size.", category="Miscellaneous", subcategory="Blocks", size=2)
    public static boolean cactusHitboxExclusion;
    @Switch(name="Alternate Text Shadow", description="Change the text-shadow to only move down rather than move to the side.", category="Miscellaneous", subcategory="Rendering")
    public static boolean alternateTextShadow;
    @Info(text="Disable Text Shadow can positively impact performance.", category="Miscellaneous", subcategory="Rendering", type=InfoType.INFO)
    private static boolean disableTextShadowInfo;
    @Switch(name="Disable Text Shadow", description="Remove shadows from text.", category="Miscellaneous", subcategory="Rendering")
    public static boolean disableShadowedText;
    @Switch(name="Left Hand in First Person", description="Render the first-person hand on the left of the screen.", category="Miscellaneous", subcategory="Rendering")
    public static boolean leftHandInFirstPerson;
    @Switch(name="Better Camera", description="Stop tall grass, plants, reeds, etc. from affecting your FOV as done in 1.14+.", category="Miscellaneous", subcategory="General")
    public static boolean betterCamera;
    @Switch(name="Better F1", description="Hide nametags when in F1 mode.", category="Miscellaneous", subcategory="General")
    public static boolean betterHideGui;
    @Switch(name="Remove Screen Bobbing", description="While using View Bobbing, only remove the view aspect but have the hand still bounce around.", category="Miscellaneous", subcategory="General")
    public static boolean removeViewBobbing;
    @Switch(name="Remove Map Bobbing", description="While using View Bobbing, remove the hand bobbing when holding a map.", category="Miscellaneous", subcategory="General")
    public static boolean mapBobbing;
    @Switch(name="Static Items", description="Stop items from bobbing up and down when dropped on the ground.", category="Miscellaneous", subcategory="General")
    public static boolean staticItems;
    @Switch(name="Natural Capes", description="Changes some physics in capes to fix rotation bugs and look more natural.", category="Miscellaneous", subcategory="Rendering")
    public static boolean naturalCapes;
    @Switch(name="Smooth Scrolling", description="Smoothly scrolls through vanilla Minecraft GUIs.", category="Miscellaneous", subcategory="Rendering")
    public static boolean smoothScrolling;
    @Switch(name="Optimized World Swapping", description="Remove unnecessary garbage collection & screen displaying to make world swapping feel nearly instant.", category="Performance", subcategory="World")
    public static boolean optimizedWorldSwapping;
    @Switch(name="Limit Chunk Updates", description="Limit the number of chunk updates that happen a second.", category="Performance", subcategory="World")
    public static boolean limitChunks;
    @Slider(name="Chunk Update Limit", description="Specify the number of updates that can happen a second.", category="Performance", subcategory="World", min=5.0f, max=250.0f)
    public static int chunkUpdateLimit;
    @Switch(name="Downscale Pack Images", description="Change all pack icons to 64x64 to reduce memory usage.", category="Performance", subcategory="Resources")
    public static boolean downscalePackImages;
    @Switch(name="Low Animation Tick", description="Lowers the number of animations that happen a second from 1000 to 500.", category="Performance", subcategory="World")
    public static boolean lowAnimationTick;
    @Switch(name="Batch Model Rendering", description="Render models in a single draw call.", category="Performance", subcategory="World")
    public static boolean batchModelRendering;
    @Switch(name="Optimized Font Renderer", description="Use modern rendering techniques to improve the font renderer performance.", category="Performance", subcategory="Text Rendering")
    public static boolean optimizedFontRenderer;
    @Switch(name="Cache Font Data", description="Cache font data, allowing for it to be reused multiple times before needing recalculation.", category="Performance", subcategory="Text Rendering")
    public static boolean cacheFontData;
    @Info(text="Armor stands are commonly used for NPC nametags. Enabling Disable Armorstands will stop those from rendering as well.", category="Performance", subcategory="Entity Rendering", type=InfoType.ERROR, size=2)
    private static boolean armorStandInfo;
    @Switch(name="Disable Armorstands", description="Stop armor stands from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableArmorstands;
    @Switch(name="Disable Semitransparent Players", description="Stop semitransparent players from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableSemitransparentEntities;
    @Switch(name="Disable Enchantment Books", description="Stop enchantment table books from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableEnchantmentBooks;
    @Switch(name="Disable Item Frames", description="Stop item frames from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableItemFrames;
    @Switch(name="Disable Mapped Item Frames", description="Stop item frames only with maps as their item from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableMappedItemFrames;
    @Switch(name="Disable Grounded Arrows", description="Stop arrows that are in the ground from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableGroundedArrows;
    @Switch(name="Disable Attached Arrows", description="Stop arrows that are attached to a player from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableAttachedArrows;
    @Switch(name="Disable Moving Arrows", description="Stop arrows that are airborne from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableMovingArrows;
    @Switch(name="Disable Skulls", description="Stop skulls from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableSkulls;
    @Switch(name="Disable Falling Blocks", description="Stop falling blocks from rendering.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableFallingBlocks;
    @Switch(name="Disable End Portals", description="Stop end portals from rendering.", category="Performance", subcategory="General")
    public static boolean disableEndPortals;
    @Switch(name="Unstacked Items", description="Render stacks of items on the ground as just one instead of having up to 5 copies in one stack.", category="Performance", subcategory="Entity Rendering")
    public static boolean unstackedItems;
    @Info(text="Due to the way OptiFine shaders work, we are unable to make Entity Culling compatible with them.", category="Performance", subcategory="Culling", type=InfoType.ERROR, size=2)
    private static boolean entityCullingInfo;
    @Switch(name="Entity Culling", description="Check to see if an entity is visible to the player before attempting to render them.", category="Performance", subcategory="Culling")
    public static boolean entityCulling;
    @Dropdown(name="Entity Culling Interval", description="The amount of time in ms between performing visibility checks for entities.\nShorter periods are more costly toward performance but provide the most accurate information.\nLower values are recommended in competitive environments.", category="Performance", subcategory="Culling", options={"50", "25", "10"})
    public static int cullingInterval;
    @Switch(name="Smart Entity Culling", description="Disable Entity Culling effect when using OptiFine shaders.", category="Performance", subcategory="Culling")
    public static boolean smartEntityCulling;
    @Switch(name="Don't Cull Ender Dragons", description="Continue to render Ender Dragons when the entity is being occluded.", category="Performance", subcategory="Culling")
    public static boolean dontCullEnderDragons;
    @Switch(name="Don't Cull Withers", description="Continue to render Withers when the entity is being occluded.", category="Performance", subcategory="Culling")
    public static boolean dontCullWithers;
    @Switch(name="Don't Cull Player Nametags", description="Continue to render Player Nametags when the entity is being occluded.", category="Performance", subcategory="Culling")
    public static boolean dontCullNametags;
    @Switch(name="Don't Cull Entity Nametags", description="Continue to render Entity Nametags when the entity is being occluded.", category="Performance", subcategory="Culling")
    public static boolean dontCullEntityNametags;
    @Switch(name="Don't Cull Armorstand Nametags", description="Continue to render Armorstand Nametags when the entity is being occluded.", category="Performance", subcategory="Culling")
    public static boolean dontCullArmorStandNametags;
    @Switch(name="Check Armorstand Rules", description="Don't cull armor stands that have a specific rule assigned to them.\nThis will result in a lot of non-occluded armor stands in places like Hypixel Skyblock, but will resolve special entities being occluded when they typically shouldn't be.", category="Performance", subcategory="Culling")
    public static boolean checkArmorstandRules;
    @Switch(name="Disable Enchantment Glint", description="Disable the enchantment glint.", category="Performance", subcategory="General")
    public static boolean disableEnchantmentGlint;
    @Info(text="When back-face culling is enabled, being inside an entity will cause that body part to be invisible.", category="Performance", subcategory="Culling", type=InfoType.WARNING, size=2)
    private static boolean backFaceCullingInfo;
    @Info(text="Some models may have a transparent face and will cause the back face to not show, such as Wither Skeletons.", category="Performance", subcategory="Culling", type=InfoType.WARNING, size=2)
    private static boolean backFaceCullingInfo2;
    @Switch(name="Entity Back-face Culling", description="Stop rendering sides of entities that you cannot see.", category="Performance", subcategory="Culling")
    public static boolean entityBackFaceCulling;
    @Switch(name="Player Back-face Culling", description="Stop rendering sides of players that you cannot see.\nBeing inside a player will cause that body part to be invisible.", category="Performance", subcategory="Culling")
    public static boolean playerBackFaceCulling;
    @Switch(name="Entity Render Distance Toggle", description="Toggle allowing a custom entity render distance.", category="Performance", subcategory="Entity Rendering")
    public static boolean entityRenderDistanceToggle;
    @Slider(name="Global Entity Render Distance", description="Stop rendering all entities outside of a specified radius.\nThis will ignore the distance of other entity render distances if smaller.", category="Performance", subcategory="Entity Rendering", min=1.0f, max=64.0f)
    public static int entityRenderDistance;
    @Slider(name="Player Render Distance", description="Stop rendering players outside of a specified radius.", category="Performance", subcategory="Entity Rendering", min=1.0f, max=64.0f)
    public static int playerRenderDistance;
    @Slider(name="Passive Entity Render Distance", description="Stop rendering passive entities outside of a specified radius.", category="Performance", subcategory="Entity Rendering", min=1.0f, max=64.0f)
    public static int passiveEntityRenderDistance;
    @Slider(name="Hostile Entity Render Distance", description="Stop rendering hostile entities outside of a specified radius.", category="Performance", subcategory="Entity Rendering", min=1.0f, max=64.0f)
    public static int hostileEntityRenderDistance;
    @Slider(name="Tile Entity Render Distance", description="Stop rendering tile entities outside of a specified radius.", category="Performance", subcategory="Entity Rendering", min=1.0f, max=64.0f)
    public static int tileEntityRenderDistance;
    @Switch(name="Fixed Inventory Position", description="Stop potion effects from shifting your inventory to the right.", category="Screens", subcategory="Inventory")
    @VigilanceName(name="Inventory Position", category="Screens", subcategory="Inventory")
    public static boolean inventoryPosition;
    @Switch(name="Click Out of Containers", description="Click outside a container to close the menu.", category="Screens", subcategory="Inventory")
    public static boolean clickOutOfContainers;
    @Dropdown(name="Inventory Scale", description="Change the scale of your inventory independent of your GUI scale.", category="Screens", subcategory="Inventory", options={"Off", "1 (Small)", "2 (Normal)", "3 (Large)", "4", "5 (Auto)"})
    public static int inventoryScale;
    @Slider(name="Container Background Opacity (%)", description="Change the opacity of the dark background inside a container, or remove it completely. By default, this is 81.5%.", category="Screens", subcategory="General", min=0.0f, max=100.0f)
    public static float containerBackgroundOpacity;
    @Slider(name="Container Opacity (%)", description="Change the opacity of supported containers.\nIncludes Chests & Survival Inventory.", category="Screens", subcategory="General", min=0.0f, max=100.0f)
    public static float containerOpacity;
    @Info(text="Supported servers for 1.11 chat length are servers that support 1.11 or above.", category="Screens", subcategory="Chat", type=InfoType.WARNING, size=2)
    private static boolean chatLengthInfo;
    @Info(text="Some servers may kick you for this despite supporting 1.11 or above.", category="Screens", subcategory="Chat", type=InfoType.WARNING, size=2)
    private static boolean chatLengthInfo2;
    @Switch(name="1.11 Chat Length", description="Extend the number of characters you can type from 100 to 256 on supported servers.", category="Screens", subcategory="Chat")
    public static boolean extendedChatLength;
    @Switch(name="Remove Chat Message Limit", description="Remove the limit on how many messages can show up in chat.", category="Screens", subcategory="Chat")
    public static boolean removeChatMessageLimit;
    @Switch(name="Compact Chat", description="Clean up the chat by stacking duplicate messages.", category="Screens", subcategory="Chat")
    public static boolean compactChat;
    @Switch(name="Consecutive Compact Chat", description="Only compact messages if they're consecutive.", category="Screens", subcategory="Chat")
    public static boolean consecutiveCompactChat;
    @Slider(name="Compact Chat Time", description="Change the amount of time old messages take to stop being compacted. Measured in seconds.", category="Screens", subcategory="Chat", min=1.0f, max=120.0f)
    public static int compactChatTime;
    @Switch(name="Remove Blank Messages", description="Stop messages with no content from showing up in chat.", category="Screens", subcategory="Chat")
    public static boolean removeBlankMessages;
    @Switch(name="Shift Chat", description="Keep chat open while sending a message if Shift is held while pressing Enter.", category="Screens", subcategory="Chat")
    public static boolean shiftChat;
    @Slider(name="Chat Delay", description="Delay chat messages if they're sent within the selected timeframe after the previous message. Measured in seconds.", category="Screens", subcategory="Chat", min=0.0f, max=6.0f)
    public static int chatDelay;
    @Switch(name="Startup Notification", description="Notify how long the game took to start.", category="Screens", subcategory="General")
    public static boolean startupNotification;
    @Switch(name="Damage Glance", description="View the damage value of the currently held item above your hotbar.", category="Screens", subcategory="Combat Utilities")
    public static boolean damageGlance;
    @Switch(name="Item Count Glance", description="View the total amount of the currently held item above your hotbar.", category="Screens", subcategory="Combat Utilities")
    public static boolean itemCountGlance;
    @Switch(name="Enchantment Glance", description="View the enchantments of the currently held item above your hotbar.", category="Screens", subcategory="Combat Utilities")
    public static boolean enchantmentsGlance;
    @Switch(name="Protection Percentage", description="View how much total armor protection you have inside your inventory.", category="Screens", subcategory="Combat Utilities")
    public static boolean protectionPercentage;
    @Switch(name="Projectile Protection Percentage", description="View how much total projectile protection you have inside your inventory.", category="Screens", subcategory="Combat Utilities")
    public static boolean projectileProtectionPercentage;
    @Switch(name="Chat Timestamps", description="Add timestamps before a message.", category="Screens", subcategory="Chat")
    public static boolean timestamps;
    @Switch(name="Show Seconds on Timestamps", description="Show the seconds on a timestamped message.", category="Screens", subcategory="Chat")
    public static boolean secondsOnTimestamps;
    @Dropdown(name="Chat Timestamps Format", description="Change the time format of Chat Timestamps.", category="Screens", subcategory="Chat", options={"12 Hour", "24 Hour"})
    public static int timestampsFormat;
    @Dropdown(name="Chat Timestamps Style", description="Choose how Chat Timestamps should appear.", category="Screens", subcategory="Chat", options={"Always Present", "Message Hover"})
    public static int timestampsStyle;
    @Switch(name="Clean Main Menu", description="Remove the Realms button on the main menu as it's useless on older versions.", category="Screens", subcategory="General")
    public static boolean cleanMainMenu;
    @Dropdown(name="Open to LAN Replacement", description="Modify the Open to LAN button to either redirect to the server list or be removed.", category="Screens", subcategory="General", options={"Default", "Server List", "Remove"})
    public static int openToLanReplacement;
    @Switch(name="Image Preview", description="Preview image links when hovering over a supported URL.\nPress Shift to use fullscreen and Control to render in native image resolution.", category="Screens", subcategory="Image Preview")
    public static boolean imagePreview;
    @Slider(name="Image Preview Width", description="The %% of screen width to be used for image preview.", category="Screens", subcategory="Image Preview", min=0.0f, max=1.0f)
    public static float imagePreviewWidth;
    @Switch(name="Safe Chat Clicks", description="Show the command or link that is run/opened on click. ", category="Screens", subcategory="Chat")
    public static boolean safeChatClicks;
    @Switch(name="Safe Chat Clicks History", description="Adds commands sent from clicking chat messages to the chat history.", category="Screens", subcategory="Chat")
    public static boolean safeChatClicksHistory;
    @Switch(name="Smart Disconnect", description="Choose between disconnecting or relogging when clicking the disconnect button.\n\u00a7eOnly works on Multiplayer servers.", category="Screens", subcategory="General")
    public static boolean smartDisconnect;
    @Switch(name="Confirm Quit", description="Prevent closing the game through the Quit Game button without confirmation.", category="Screens", subcategory="General")
    public static boolean confirmQuit;
    @Info(text="Essential's Screenshot Manager must be disabled for this to work.", category="Screenshots", subcategory="General", type=InfoType.WARNING, size=2)
    private static boolean screenshotManagerWarning;
    @Switch(name="Screenshot Manager", description="Change the way screenshotting works as a whole, creating a whole new process to screenshotting such as uploading to Imgur, copying to clipboard, etc.", category="Screenshots", subcategory="General")
    public static boolean screenshotManager;
    @Switch(name="No Feedback", description="Remove the messages from screenshots entirely.", category="Screenshots", subcategory="Feedback")
    public static boolean screenshotNoFeedback;
    @Switch(name="Auto Copy Screenshot", description="Automatically copy screenshots to the clipboard when taken.", category="Screenshots", subcategory="General")
    public static boolean autoCopyScreenshot;
    @Switch(name="Screenshot Preview", description="Preview your screenshot when taken in the bottom right corner.", category="Screenshots", subcategory="General")
    public static boolean screenshotPreview;
    @Slider(name="Preview Time", description="Adjust how long the preview should stay on the screen before sliding out.\nTime is measured in seconds.", category="Screenshots", subcategory="General", min=1.0f, max=5.0f)
    public static int previewTime;
    @Dropdown(name="Preview Animation", description="Select an animation style for the screenshot preview.", category="Screenshots", subcategory="General", options={"iOS Style", "Slide Out", "None"})
    public static int previewAnimationStyle;
    @Slider(name="Preview Scale", description="Change the scale of the preview.", category="Screenshots", subcategory="General", min=0.0f, max=1.0f)
    public static float previewScale;
    @Switch(name="Compact Response", description="Compact the message given when screenshotting.", category="Screenshots", subcategory="Feedback")
    public static boolean compactScreenshotResponse;
    @Switch(name="Favorite Screenshot", description="Show a text component that allows you to favorite a screenshot.", category="Screenshots", subcategory="Feedback")
    public static boolean favoriteScreenshot;
    @Switch(name="Delete Screenshot", description="Show a text component that allows you to delete a screenshot.", category="Screenshots", subcategory="Feedback")
    public static boolean deleteScreenshot;
    @Switch(name="Upload Screenshot", description="Show a text component that allows you to upload a screenshot to Imgur.\nSupport for custom services is currently planned.", category="Screenshots", subcategory="Feedback")
    public static boolean uploadScreenshot;
    @Switch(name="Copy Screenshot", description="Show a text component that allows you to copy a screenshot.", category="Screenshots", subcategory="Feedback")
    public static boolean copyScreenshot;
    @Switch(name="Open Screenshots Folder", description="Show a text component that allows you to open the screenshots folder.", category="Screenshots", subcategory="Feedback")
    public static boolean openScreenshotsFolder;
    @Info(text="Requires two restarts to take full effect.", category="Experimental", subcategory="Forge", type=InfoType.WARNING)
    private static boolean cacheEntrypointsInfo;
    @Switch(name="Entrypoint Caching", description="Cache Forge mod entry points, improving startup time as Forge no longer needs to walk through every class to find the @Mod annotation.", category="Experimental", subcategory="Forge")
    public static boolean cacheEntrypoints;
    @Button(name="Reset Cache", description="Reset the cache of Forge mod entry points.", category="Experimental", subcategory="Forge", text="Reset", size=2)
    public static Runnable resetCache;
    @Info(text="Improved Skin Rendering can make some skins invisible. It requires a restart once toggled.", category="Experimental", subcategory="Skin Rendering", type=InfoType.WARNING, size=2)
    private static boolean improvedSkinRenderingInfo;
    @Switch(name="Improved Skin Rendering", description="Remove transparent pixels on skins instead of turning them black.", category="Experimental", subcategory="Skin Rendering")
    public static boolean improvedSkinRendering;
    @Info(text="This may cause stuff with animations to feel \"choppy\".", category="Experimental", subcategory="HUD Caching", type=InfoType.WARNING)
    private static boolean hudCachingWarning;
    @Switch(name="HUD Caching", description="Reuse frames from the HUD instead of constantly recreating them every frame, as most HUD elements will stay the same for a long amount of time.", category="Experimental", subcategory="HUD Caching")
    public static boolean hudCaching;
    @Slider(name="Cache FPS", description="The amount of frames to cache for the HUD.", category="Experimental", subcategory="HUD Caching", step=5, min=5.0f, max=60.0f)
    public static int cacheFPS;
    @Switch(name="Nausea Effect", description="Remove the nether portal effect appearing when clearing nausea.", category="Miscellaneous", subcategory="Overlays")
    public static boolean nauseaEffectOld;
    @Slider(name="Fire Overlay Opacity", description="Change the opacity of the fire overlay.", category="Miscellaneous", subcategory="Overlays", min=0.0f, max=1.0f)
    public static float fireOverlayOpacityOld;
    @Switch(name="Disable Titles", description="Stop titles from appearing.", category="Miscellaneous", subcategory="Overlays")
    public static boolean disableTitlesOld;
    @Slider(name="Title Scale", description="Set the scale for titles.", category="Miscellaneous", subcategory="Titles", min=0.0f, max=1.0f)
    public static float titleScaleOld;
    @Slider(name="Title Opacity", description="Change the opacity of titles.", category="Miscellaneous", subcategory="Titles", min=0.0f, max=1.0f)
    public static float titleOpacityOld;
    @Switch(name="Toggle Tab", description="Hold tab open without needing to hold down the tab key.", category="Miscellaneous", subcategory="Tab")
    public static boolean toggleTabOld;
    @Switch(name="Crosshair Perspective", description="Remove the crosshair when in third person.", category="Miscellaneous", subcategory="General")
    public static boolean crosshairPerspectiveOld;
    @Switch(name="Show Own Nametag", description="See your nametag in third person.", category="Miscellaneous", subcategory="Rendering")
    public static boolean showOwnNametagOld;
    @Slider(name="Ridden Horse Opacity", description="Change the opacity of the horse you're currently riding for visibility.", category="Miscellaneous", subcategory="Rendering", min=0.0f, max=100.0f)
    public static float riddenHorseOpacityOld;
    @Switch(name="Number Ping", description="Show a readable ping number in tab instead of bars.", category="Miscellaneous", subcategory="Tab")
    public static boolean numberPingOld;
    @Switch(name="Clean View", description="Stop rendering your potion effect particles.", category="Miscellaneous", subcategory="Rendering")
    public static boolean cleanViewOld;
    @Switch(name="Disable Breaking Particles", description="Remove block-breaking particles for visibility.", category="Miscellaneous", subcategory="Rendering")
    public static boolean disableBlockBreakParticlesOld;
    @Switch(name="Remove Inverted Colors from Crosshair", description="Remove the inverted color effect on the crosshair.", category="Miscellaneous", subcategory="Overlays")
    public static boolean removeInvertFromCrosshairOld;
    @Switch(name="Add Text Shadow to Nametags", description="Render nametags with shadowed text.", category="Miscellaneous", subcategory="Rendering")
    public static boolean shadowedNametagTextOld;
    @Switch(name="Add Text Shadow to Actionbar", description="Render actionbar messages with shadowed text.", category="Miscellaneous", subcategory="Rendering")
    public static boolean shadowedActionbarTextOld;
    @Switch(name="Add Background to Actionbar", description="Render a background behind the actionbar.", category="Miscellaneous", subcategory="Rendering")
    public static boolean actionbarBackgroundOld;
    @Switch(name="Remove Vertical Bobbing", description="While using View Bobbing, remove the vertical bobbing like in 1.14+.", category="Miscellaneous", subcategory="General")
    public static boolean removeVerticalViewBobbingOld;
    @Switch(name="Static Particle Color", description="Disable particle lighting checks each frame.", category="Performance", subcategory="Particles")
    public static boolean staticParticleColorOld;
    @Slider(name="Max Particle Limit", description="Stop additional particles from appearing when there are too many at once.", category="Performance", subcategory="Particles", min=1.0f, max=10000.0f)
    public static int maxParticleLimitOld;
    @Switch(name="Disable Nametag Boxes", description="Remove the transparent box around the nametag.", category="Performance", subcategory="Entity Rendering")
    public static boolean disableNametagBoxesOld;
    @Switch(name="Remove Container Background", description="Remove the dark background inside a container.", category="Screens", subcategory="General")
    public static boolean removeContainerBackgroundOld;
    @Switch(name="GUI Crosshair", description="Stop rendering the crosshair when in a GUI.", category="Screens", subcategory="General")
    public static boolean guiCrosshairOld;
    @Slider(name="Tab Opacity", description="Change the tab list opacity.", category="Screens", subcategory="Tab", min=0.0f, max=1.0f)
    public static float tabOpacityOld;
    @Slider(name="Tab Player Count", description="Change how many players can display on tab.", category="Screens", subcategory="Tab", min=10.0f, max=120.0f)
    public static int tabPlayerCountOld;
    @Switch(name="Tab Height", description="Move the tab overlay down the selected amount of pixels when there's an active bossbar.", category="Screens", subcategory="Tab")
    public static boolean tabHeightAllowOld;
    @Slider(name="Set Tab Height", description="Choose how many pixels tab will move down when there's an active bossbar.", category="Screens", subcategory="Tab", min=0.0f, max=24.0f)
    public static int tabHeightOld;
    @Switch(name="Fix Actionbar Overlap", description="Prevents the actionbar text from rendering above the armor/health bar.", category="Bug Fixes", subcategory="Rendering")
    public static boolean fixActionbarOverlapOld;
    @Switch(name="Transparent Chat", description="Remove the background from chat.", category="Screens", subcategory="Chat")
    public static boolean transparentChatOld;
    @Switch(name="Chat Background When Open", description="Add back the background when chat is open.", category="Screens", subcategory="Chat")
    public static boolean transparentChatOnlyWhenClosedOld;
    @Switch(name="Transparent Chat Input Field", description="Remove the background from chat's input field.", category="Screens", subcategory="Chat")
    public static boolean transparentChatInputFieldOld;
    @Switch(name="Extend Chat Background", description="Extend the chat background all the way to the left of the screen.", category="Screens", subcategory="Chat")
    public static boolean extendChatBackgroundOld;
    @Switch(name="Chat Position", description="Move the chat up 12 pixels to stop it from overlapping the health bar, as done in 1.12+.", category="Screens", subcategory="Chat")
    public static boolean chatPositionOld;
    @Info(text="These options have been replaced by other mods. Hover over the option name to see which mod replaces that feature.", category="Deprecated", type=InfoType.WARNING, size=2)
    private static boolean deprecatedInfo;
    @Exclude
    public static boolean nauseaEffect;
    @Exclude
    public static float fireOverlayOpacity;
    @Switch(name="Disable Titles", description="Stop titles from appearing.", category="Deprecated", subcategory="Titles")
    public static boolean disableTitles;
    @Slider(name="Title Scale", description="Set the scale for titles.", category="Deprecated", subcategory="Titles", min=0.0f, max=1.0f)
    public static float titleScale;
    @Slider(name="Title Opacity", description="Change the opacity of titles.", category="Deprecated", subcategory="Titles", min=0.0f, max=1.0f)
    public static float titleOpacity;
    @Switch(name="Toggle Tab", description="Hold tab open without needing to hold down the tab key.", category="Deprecated", subcategory="Tab")
    public static boolean toggleTab;
    @Switch(name="Crosshair Perspective", description="Remove the crosshair when in third person.", category="Deprecated", subcategory="Crosshair")
    public static boolean crosshairPerspective;
    @Switch(name="Remove Inverted Colors from Crosshair", description="Remove the inverted color effect on the crosshair.", category="Deprecated", subcategory="Crosshair")
    public static boolean removeInvertFromCrosshair;
    @Switch(name="Show Own Nametag", description="See your nametag in third person.", category="Deprecated", subcategory="Nametags")
    public static boolean showOwnNametag;
    @Switch(name="Add Text Shadow to Nametags", description="Render nametags with shadowed text.", category="Deprecated", subcategory="Nametags")
    public static boolean shadowedNametagText;
    @Exclude
    public static float riddenHorseOpacity;
    @Switch(name="Clean View", description="Stop rendering your potion effect particles.", category="Deprecated", subcategory="Particles")
    public static boolean cleanView;
    @Switch(name="Disable Breaking Particles", description="Remove block-breaking particles for visibility.", category="Deprecated", subcategory="Particles")
    public static boolean disableBlockBreakParticles;
    @Switch(name="Add Text Shadow to Actionbar", description="Render actionbar messages with shadowed text.", category="Deprecated", subcategory="Actionbar")
    public static boolean shadowedActionbarText;
    @Switch(name="Add Background to Actionbar", description="Render a background behind the actionbar.", category="Deprecated", subcategory="Actionbar")
    public static boolean actionbarBackground;
    @Switch(name="Remove Vertical Bobbing", description="While using View Bobbing, remove the vertical bobbing like in 1.14+.", category="Deprecated", subcategory="Animations")
    public static boolean removeVerticalViewBobbing;
    @Switch(name="Static Particle Color", description="Disable particle lighting checks each frame.", category="Deprecated", subcategory="Particles")
    public static boolean staticParticleColor;
    @Slider(name="Max Particle Limit", description="Stop additional particles from appearing when there are too many at once.", category="Deprecated", subcategory="Particles", min=1.0f, max=10000.0f)
    public static int maxParticleLimit;
    @Switch(name="Disable Nametag Boxes", description="Remove the transparent box around the nametag.", category="Deprecated", subcategory="Nametags")
    public static boolean disableNametagBoxes;
    @Exclude
    public static boolean removeContainerBackground;
    @Switch(name="GUI Crosshair", description="Stop rendering the crosshair when in a GUI.", category="Deprecated", subcategory="Crosshair")
    public static boolean guiCrosshair;
    @Slider(name="Tab Opacity", description="Change the tab list opacity.", category="Deprecated", subcategory="Tab", min=0.0f, max=1.0f)
    public static float tabOpacity;
    @Slider(name="Tab Player Count", description="Change how many players can display on tab.", category="Deprecated", subcategory="Tab", min=10.0f, max=120.0f)
    public static int tabPlayerCount;
    @Switch(name="Tab Height", description="Move the tab overlay down the selected amount of pixels when there's an active bossbar.", category="Deprecated", subcategory="Tab")
    public static boolean tabHeightAllow;
    @Slider(name="Set Tab Height", description="Choose how many pixels tab will move down when there's an active bossbar.", category="Deprecated", subcategory="Tab", min=0.0f, max=24.0f)
    public static int tabHeight;
    @Switch(name="Fix Actionbar Overlap", description="Prevents the actionbar text from rendering above the armor/health bar.", category="Deprecated", subcategory="Actionbar")
    public static boolean fixActionbarOverlap;
    @Switch(name="Transparent Chat", description="Remove the background from chat.", category="Deprecated", subcategory="Chat")
    public static boolean transparentChat;
    @Switch(name="Chat Background When Open", description="Add back the background when chat is open.", category="Deprecated", subcategory="Chat")
    public static boolean transparentChatOnlyWhenClosed;
    @Switch(name="Transparent Chat Input Field", description="Remove the background from chat's input field.", category="Deprecated", subcategory="Chat")
    public static boolean transparentChatInputField;
    @Switch(name="Extend Chat Background", description="Extend the chat background all the way to the left of the screen.", category="Deprecated", subcategory="Chat")
    public static boolean extendChatBackground;
    @Switch(name="Chat Position", description="Move the chat up 12 pixels to stop it from overlapping the health bar, as done in 1.12+.", category="Deprecated", subcategory="Chat")
    public static boolean chatPosition;
    public static boolean labyModMoment;
    public static String selectedAudioDevice;
    public static PatcherConfig INSTANCE;

    @Button(name="Modify Every Sound", text="Modify", description="Open a separate GUI allowing you to mute or amplify individual sounds.", category="Miscellaneous", subcategory="General")
    private void modifyEverySound() {
        Patcher.instance.getPatcherSoundConfig().openGui();
    }

    public static int getInventoryScale() {
        return inventoryScale == 0 ? -1 : inventoryScale;
    }

    public PatcherConfig() {
        super(new Mod("PolyPatcher", ModType.UTIL_QOL, "/patcher.svg", (Migrator)new VigilanceMigrator("./config/patcher.toml")), "patcher.json");
        this.initialize();
        boolean modified = false;
        if (removeContainerBackgroundOld) {
            containerBackgroundOpacity = 0.0f;
            modified = true;
        }
        if (nauseaEffectOld) {
            distortionEffect = 0;
            modified = true;
        }
        if (fireOverlayOpacityOld != 1.0f) {
            fireOverlayOpacityI = (int)(fireOverlayOpacityOld * 100.0f);
            riddenHorseOpacityI = (int)(riddenHorseOpacityOld * 100.0f);
            modified = true;
        }
        if (modified) {
            try {
                FileUtils.writeStringToFile((File)ConfigUtils.getProfileFile((String)"patcher-not-migrated.json"), (String)FileUtils.readFileToString((File)ConfigUtils.getProfileFile((String)"patcher.json"), (Charset)StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Patcher.instance.getLogger().error("Failed to copy over Patcher config before migration.", (Throwable)e);
            }
            this.save();
        }
        Runnable reloadWorld = () -> Minecraft.func_71410_x().field_71438_f.func_72712_a();
        this.addListener("fullbright", reloadWorld);
        this.addListener("removeGroundFoliage", reloadWorld);
        this.addListener("vanillaGlassPanes", reloadWorld);
        Runnable reloadTextures = () -> Minecraft.func_71410_x().func_110436_a();
        this.addListener("heldItemLighting", reloadTextures);
        this.hideIf("nauseaEffectOld", () -> true);
        this.hideIf("fireOverlayOpacityOld", () -> true);
        this.hideIf("disableTitlesOld", () -> true);
        this.hideIf("titleScaleOld", () -> true);
        this.hideIf("titleOpacityOld", () -> true);
        this.hideIf("toggleTabOld", () -> true);
        this.hideIf("crosshairPerspectiveOld", () -> true);
        this.hideIf("showOwnNametagOld", () -> true);
        this.hideIf("riddenHorseOpacityOld", () -> true);
        this.hideIf("numberPingOld", () -> true);
        this.hideIf("cleanViewOld", () -> true);
        this.hideIf("disableBlockBreakParticlesOld", () -> true);
        this.hideIf("removeInvertFromCrosshairOld", () -> true);
        this.hideIf("shadowedNametagTextOld", () -> true);
        this.hideIf("shadowedActionbarTextOld", () -> true);
        this.hideIf("actionbarBackgroundOld", () -> true);
        this.hideIf("removeVerticalViewBobbingOld", () -> true);
        this.hideIf("staticParticleColorOld", () -> true);
        this.hideIf("maxParticleLimitOld", () -> true);
        this.hideIf("disableNametagBoxesOld", () -> true);
        this.hideIf("removeContainerBackgroundOld", () -> true);
        this.hideIf("guiCrosshairOld", () -> true);
        this.hideIf("tabOpacityOld", () -> true);
        this.hideIf("tabPlayerCountOld", () -> true);
        this.hideIf("tabHeightAllowOld", () -> true);
        this.hideIf("tabHeightOld", () -> true);
        this.hideIf("fixActionbarOverlapOld", () -> true);
        this.hideIf("transparentChatOld", () -> true);
        this.hideIf("transparentChatOnlyWhenClosedOld", () -> true);
        this.hideIf("transparentChatInputFieldOld", () -> true);
        this.hideIf("extendChatBackgroundOld", () -> true);
        this.hideIf("chatPositionOld", () -> true);
        OldPatcherConfig.nauseaEffect = nauseaEffectOld;
        OldPatcherConfig.fireOverlayOpacity = fireOverlayOpacityOld;
        OldPatcherConfig.disableTitles = disableTitlesOld;
        OldPatcherConfig.titleScale = titleScaleOld;
        OldPatcherConfig.titleOpacity = titleOpacityOld;
        OldPatcherConfig.toggleTab = toggleTabOld;
        OldPatcherConfig.crosshairPerspective = crosshairPerspectiveOld;
        OldPatcherConfig.showOwnNametag = showOwnNametagOld;
        OldPatcherConfig.riddenHorseOpacity = riddenHorseOpacityOld;
        OldPatcherConfig.numberPing = numberPingOld;
        OldPatcherConfig.cleanView = cleanViewOld;
        OldPatcherConfig.disableBlockBreakParticles = disableBlockBreakParticlesOld;
        OldPatcherConfig.removeInvertFromCrosshair = removeInvertFromCrosshairOld;
        OldPatcherConfig.shadowedNametagText = shadowedNametagTextOld;
        OldPatcherConfig.shadowedActionbarText = shadowedActionbarTextOld;
        OldPatcherConfig.actionbarBackground = actionbarBackgroundOld;
        OldPatcherConfig.removeVerticalViewBobbing = removeVerticalViewBobbingOld;
        OldPatcherConfig.staticParticleColor = staticParticleColorOld;
        OldPatcherConfig.maxParticleLimit = maxParticleLimitOld;
        OldPatcherConfig.disableNametagBoxes = disableNametagBoxesOld;
        OldPatcherConfig.removeContainerBackground = removeContainerBackgroundOld;
        OldPatcherConfig.guiCrosshair = guiCrosshairOld;
        OldPatcherConfig.tabOpacity = tabOpacityOld;
        OldPatcherConfig.tabPlayerCount = tabPlayerCountOld;
        OldPatcherConfig.tabHeightAllow = tabHeightAllowOld;
        OldPatcherConfig.tabHeight = tabHeightOld;
        OldPatcherConfig.fixActionbarOverlap = fixActionbarOverlapOld;
        OldPatcherConfig.transparentChat = transparentChatOld;
        OldPatcherConfig.transparentChatOnlyWhenClosed = transparentChatOnlyWhenClosedOld;
        OldPatcherConfig.transparentChatInputField = transparentChatInputFieldOld;
        OldPatcherConfig.extendChatBackground = extendChatBackgroundOld;
        OldPatcherConfig.chatPosition = chatPositionOld;
        this.addDependency("disableTitles", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("titleScale", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("titleOpacity", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("toggleTab", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("crosshairPerspective", "Replaced by PolyCrosshair. Please install PolyCrosshair to use this feature.", () -> false);
        this.addDependency("showOwnNametag", "Replaced by PolyNametag. Please install PolyNametag to use this feature.", () -> false);
        this.addDependency("numberPing", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("cleanView", "Replaced by OverflowParticles. Please install OverflowParticles to use this feature.", () -> false);
        this.addDependency("disableBlockBreakParticles", "Replaced by OverflowParticles. Please install OverflowParticles to use this feature.", () -> false);
        this.addDependency("removeInvertFromCrosshair", "Replaced by PolyCrosshair. Please install PolyCrosshair to use this feature.", () -> false);
        this.addDependency("shadowedNametagText", "Replaced by PolyNametag. Please install PolyNametag to use this feature.", () -> false);
        this.addDependency("shadowedActionbarText", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("actionbarBackground", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("removeVerticalViewBobbing", "Replaced by OverflowAnimations. Please install OverflowAnimations to use this feature.", () -> false);
        this.addDependency("staticParticleColor", "Replaced by OverflowParticles. Please install OverflowParticles to use this feature.", () -> false);
        this.addDependency("maxParticleLimit", "Replaced by OverflowParticles. Please install OverflowParticles to use this feature.", () -> false);
        this.addDependency("disableNametagBoxes", "Replaced by PolyNametag. Please install PolyNametag to use this feature.", () -> false);
        this.addDependency("guiCrosshair", "Replaced by PolyCrosshair. Please install PolyCrosshair to use this feature.", () -> false);
        this.addDependency("tabOpacity", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("tabPlayerCount", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("tabHeightAllow", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("tabHeight", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("fixActionbarOverlap", "Replaced by VanillaHUD. Please install VanillaHUD to use this feature.", () -> false);
        this.addDependency("transparentChat", "Replaced by Chatting. Please install Chatting to use this feature.", () -> false);
        this.addDependency("transparentChatOnlyWhenClosed", "Replaced by Chatting. Please install Chatting to use this feature.", () -> false);
        this.addDependency("transparentChatInputField", "Replaced by Chatting. Please install Chatting to use this feature.", () -> false);
        this.addDependency("extendChatBackground", "Replaced by Chatting. Please install Chatting to use this feature.", () -> false);
        this.addDependency("chatPosition", "Replaced by Chatting. Please install Chatting to use this feature.", () -> false);
        try {
            this.addDependency("cactusHitboxExclusion", "futureHitBoxes");
            this.addDependency("smartFullbright", "fullbright");
            this.addDependency("cleanerNightVision", "disableNightVision", () -> !disableNightVision);
            this.addDependency("unfocusedFPSAmount", "unfocusedFPS");
            this.addDependency("instantFullscreen", "windowedFullscreen");
            this.addDependency("consecutiveCompactChat", "compactChat");
            this.addDependency("compactChatTime", "compactChat");
            this.addDependency("timestampsFormat", "timestamps");
            this.addDependency("timestampsStyle", "timestamps");
            this.addDependency("secondsOnTimestamps", "timestamps");
            this.addDependency("imagePreviewWidth", "imagePreview");
            Arrays.asList("slownessFovModifierFloat", "speedFovModifierFloat", "bowFovModifierFloat", "sprintingFovModifierFloat", "flyingFovModifierFloat").forEach(property -> this.addDependency((String)property, "allowFovModifying"));
            this.addDependency("logOptimizerLength", "logOptimizer");
            this.addDependency("dynamicZoomSensitivity", "scrollToZoom");
            this.addDependency("smoothZoomAnimation", "scrollToZoom");
            this.addDependency("smoothZoomAlgorithm", "smoothZoomAnimation");
            Arrays.asList("cullingInterval", "smartEntityCulling", "dontCullNametags", "dontCullEntityNametags", "dontCullArmorStandNametags", "checkArmorstandRules").forEach(property -> this.addDependency((String)property, "entityCulling"));
            Arrays.asList("entityRenderDistance", "playerRenderDistance", "passiveEntityRenderDistance", "hostileEntityRenderDistance", "tileEntityRenderDistance").forEach(property -> this.addDependency((String)property, "entityRenderDistanceToggle"));
            this.addDependency("cacheFontData", "optimizedFontRenderer");
            this.addDependency("chunkUpdateLimit", "limitChunks");
            Arrays.asList("screenshotNoFeedback", "compactScreenshotResponse", "autoCopyScreenshot", "screenshotPreview", "previewTime", "previewAnimationStyle", "previewScale", "favoriteScreenshot", "deleteScreenshot", "uploadScreenshot", "copyScreenshot", "openScreenshotsFolder").forEach(property -> this.addDependency((String)property, "screenshotManager"));
            this.hideIf("instantFullscreen", () -> !SystemUtils.IS_OS_WINDOWS);
            Supplier<Boolean> noOptiFine = () -> ClassTransformer.optifineVersion.equals("NONE");
            Arrays.asList("scrollToZoom", "normalZoomSensitivity", "customZoomSensitivity", "smoothZoomAnimation", "smoothZoomAnimationWhenScrolling", "smoothZoomAlgorithm", "toggleToZoom", "normalFpsCounter", "useVanillaMetricsRenderer", "renderHandWhenZoomed", "smartFullbright", "smartEntityCulling", "entityCullingInfo", "dynamicZoomSensitivity", "customSkyFix", "customSkyFixInfo").forEach(property -> this.hideIf((String)property, noOptiFine));
            Supplier<Boolean> smoothFontDetected = () -> ClassTransformer.smoothFontDetected;
            this.hideIf("optimizedFontRenderer", smoothFontDetected);
            this.hideIf("cacheFontData", smoothFontDetected);
            Supplier<Boolean> minecraft112 = () -> "1.8.9".equals("1.12.2");
            Arrays.asList("resourceExploitFix", "newKeybindHandling", "separateResourceLoading", "futureHitBoxes", "cactusHitboxExclusion", "farmSelectionBoxesInfo", "cactusHitboxExclusionInfo", "leftHandInFirstPerson", "extendedChatLength", "chatPosition", "parallaxFix", "extendChatBackground", "vanillaGlassPanes", "heldItemLighting").forEach(property -> this.hideIf((String)property, minecraft112));
            this.hideIf("keyboardLayout", () -> !SystemUtils.IS_OS_LINUX);
        }
        catch (Exception e) {
            Patcher.instance.getLogger().error("Failed to access property.", (Throwable)e);
        }
    }

    public void markDirty() {
    }

    public void writeData() {
        this.save();
    }

    static {
        cullingFixInfo = "";
        resourceExploitFix = true;
        layersInTab = true;
        playerVoidRendering = true;
        customSkyFixInfo = "";
        customSkyFix = true;
        fixedAlexArmsInfo = "";
        fixedAlexArms = true;
        bookBackground = false;
        keyboardLayout = 0;
        heldItemLighting = true;
        betterKeybindHandlingInfo = "";
        newKeybindHandling = true;
        fullbrightInfo = "";
        fullbright = true;
        smartFullbright = true;
        disableNightVision = false;
        cleanerNightVision = false;
        fireOverlayOpacityI = 100;
        pumpkinOverlayOpacity = 100;
        removeWaterFov = true;
        sprintingFovModifierFloat = 1.0f;
        flyingFovModifierFloat = 1.0f;
        bowFovModifierFloat = 1.0f;
        speedFovModifierFloat = 1.0f;
        slownessFovModifierFloat = 1.0f;
        unfocusedSounds = 1.0f;
        unfocusedFPSAmount = 60;
        customFpsLimit = 0;
        riddenHorseOpacityI = 100;
        distortionEffect = 100;
        waterDensity = 100;
        scrollToZoom = true;
        customZoomSensitivity = 1.0f;
        smoothZoomAlgorithm = 0;
        normalFpsCounter = true;
        useVanillaMetricsRenderer = true;
        betterRomanNumerals = true;
        logOptimizerInfo = true;
        logOptimizerLength = 30;
        farmSelectionBoxesInfo = true;
        futureHitBoxes = true;
        cactusHitboxExclusionInfo = true;
        cactusHitboxExclusion = true;
        disableTextShadowInfo = true;
        betterCamera = true;
        optimizedWorldSwapping = true;
        chunkUpdateLimit = 50;
        downscalePackImages = true;
        lowAnimationTick = true;
        batchModelRendering = true;
        optimizedFontRenderer = true;
        cacheFontData = true;
        armorStandInfo = true;
        entityCullingInfo = true;
        entityCulling = true;
        cullingInterval = 0;
        smartEntityCulling = true;
        dontCullEnderDragons = true;
        dontCullWithers = true;
        dontCullNametags = true;
        dontCullEntityNametags = true;
        dontCullArmorStandNametags = true;
        backFaceCullingInfo = true;
        backFaceCullingInfo2 = true;
        entityRenderDistance = 64;
        playerRenderDistance = 64;
        passiveEntityRenderDistance = 64;
        hostileEntityRenderDistance = 64;
        tileEntityRenderDistance = 64;
        inventoryPosition = true;
        inventoryScale = 0;
        containerBackgroundOpacity = 81.56863f;
        containerOpacity = 100.0f;
        chatLengthInfo = true;
        chatLengthInfo2 = true;
        extendedChatLength = true;
        removeChatMessageLimit = true;
        compactChat = true;
        compactChatTime = 60;
        chatDelay = 0;
        startupNotification = true;
        timestampsFormat = 0;
        timestampsStyle = 0;
        cleanMainMenu = true;
        openToLanReplacement = 0;
        imagePreview = true;
        imagePreviewWidth = 0.5f;
        screenshotManagerWarning = true;
        screenshotManager = false;
        previewTime = 3;
        previewAnimationStyle = 0;
        previewScale = 1.0f;
        favoriteScreenshot = true;
        deleteScreenshot = true;
        uploadScreenshot = true;
        copyScreenshot = true;
        openScreenshotsFolder = true;
        cacheEntrypointsInfo = true;
        cacheEntrypoints = true;
        resetCache = () -> EntrypointCaching.INSTANCE.resetCache();
        improvedSkinRendering = false;
        hudCachingWarning = true;
        cacheFPS = 20;
        fireOverlayOpacityOld = 1.0f;
        titleScaleOld = 1.0f;
        titleOpacityOld = 1.0f;
        riddenHorseOpacityOld = 1.0f;
        staticParticleColorOld = false;
        maxParticleLimitOld = 4000;
        removeContainerBackgroundOld = false;
        tabOpacityOld = 1.0f;
        tabPlayerCountOld = 80;
        tabHeightOld = 10;
        deprecatedInfo = true;
        nauseaEffect = false;
        fireOverlayOpacity = 1.0f;
        disableTitles = false;
        titleScale = 1.0f;
        titleOpacity = 1.0f;
        toggleTab = false;
        crosshairPerspective = false;
        removeInvertFromCrosshair = false;
        showOwnNametag = false;
        shadowedNametagText = false;
        riddenHorseOpacity = 1.0f;
        cleanView = false;
        disableBlockBreakParticles = false;
        shadowedActionbarText = false;
        actionbarBackground = false;
        removeVerticalViewBobbing = false;
        staticParticleColor = false;
        maxParticleLimit = 4000;
        disableNametagBoxes = false;
        removeContainerBackground = false;
        guiCrosshair = false;
        tabOpacity = 1.0f;
        tabPlayerCount = 80;
        tabHeightAllow = false;
        tabHeight = 0;
        fixActionbarOverlap = false;
        extendChatBackground = false;
        chatPosition = false;
        labyModMoment = true;
        selectedAudioDevice = "";
        INSTANCE = new PatcherConfig();
    }
}

