/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.config.migration.Migrator;
import cc.polyfrost.oneconfig.config.migration.VigilanceMigrator;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSlider;
import club.sk1er.patcher.Patcher;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;

public class PatcherSoundConfig
extends Config {
    private static final transient String CONFIG_NAME = "patcher_sounds.json";
    public static final transient Mod soundModImpl = new Mod("Patcher Sounds", ModType.UTIL_QOL, "/patcher.svg", (Migrator)new VigilanceMigrator("./config/" + "patcher_sounds.json".replace(".json", ".toml")));
    public final transient Map<ResourceLocation, BasicOption> data;
    public static boolean dummyBooleanForMigratorDONTTOUCH = false;

    public PatcherSoundConfig(Map<ResourceLocation, BasicOption> data, Map<ResourceLocation, SoundEventAccessorComposite> soundRegistry) {
        super(soundModImpl, CONFIG_NAME);
        this.mod.config = this;
        this.data = data;
        if (data == null || soundRegistry == null) {
            return;
        }
        this.initialize(data, soundRegistry);
    }

    public void initialize(Map<ResourceLocation, BasicOption> data, Map<ResourceLocation, SoundEventAccessorComposite> soundRegistry) {
        File profileFile = ConfigUtils.getProfileFile((String)this.configFile);
        Field dummyField = null;
        try {
            dummyField = ((Object)((Object)this)).getClass().getDeclaredField("dummyBooleanForMigratorDONTTOUCH");
        }
        catch (Exception e) {
            Patcher.instance.getLogger().error("Failed to get dummy field for migrator, this is a bug!", (Throwable)e);
        }
        try {
            for (Map.Entry<ResourceLocation, SoundEventAccessorComposite> entry : soundRegistry.entrySet()) {
                Field finalDummyField = dummyField;
                data.computeIfAbsent(entry.getKey(), location -> {
                    Object value;
                    String name = this.getName((ResourceLocation)location);
                    String category = WordUtils.capitalizeFully((String)((SoundEventAccessorComposite)entry.getValue()).func_148728_d().func_147155_a());
                    String subcategory = "Sounds";
                    OptionSubcategory subCategory = ConfigUtils.getSubCategory((OptionPage)this.mod.defaultPage, (String)category, (String)subcategory);
                    DummySlider slider = new DummySlider(name, category, subcategory);
                    subCategory.options.add(slider);
                    if (!profileFile.exists() && this.mod.migrator != null && finalDummyField != null && (value = this.mod.migrator.getValue(finalDummyField, name, category, subcategory)) != null) {
                        slider.value = (Integer)value;
                    }
                    return slider;
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (profileFile.exists()) {
            this.load();
        } else {
            this.save();
        }
        this.mod.config = this;
        this.generateOptionList((Object)this, this.mod.defaultPage, this.mod, false);
        Config.register((Mod)this.mod);
    }

    public void save() {
        JsonObject object = new JsonObject();
        for (Map.Entry<ResourceLocation, BasicOption> entry : this.data.entrySet()) {
            if (!(entry.getValue() instanceof DummySlider)) continue;
            DummySlider slider = (DummySlider)entry.getValue();
            object.addProperty(slider.name, (Number)slider.value);
        }
        ConfigUtils.getProfileFile((String)this.configFile).getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(ConfigUtils.getProfileFile((String)this.configFile).toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(this.gson.toJson((JsonElement)object));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(ConfigUtils.getProfileFile((String)this.configFile).toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonObject object = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry<ResourceLocation, BasicOption> entry : this.data.entrySet()) {
                if (!(entry.getValue() instanceof DummySlider)) continue;
                DummySlider slider = (DummySlider)entry.getValue();
                if (!object.has(slider.name)) continue;
                slider.value = object.get(slider.name).getAsInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = ConfigUtils.getProfileFile((String)this.configFile);
            file.renameTo(new File(file.getParentFile(), file.getName() + ".corrupted"));
        }
    }

    private String getName(ResourceLocation location) {
        return WordUtils.capitalizeFully((String)location.func_110623_a().replace(".", " ").replace("_", " "));
    }

    public void initialize() {
    }

    private static final class DummySlider
    extends ConfigSlider {
        private int value = 100;
        private final Field field;

        public DummySlider(String name, String category, String subcategory) {
            super(null, null, name, "Sound Multiplier for " + name, category, subcategory, 0.0f, 200.0f, 0);
            this.setParent((Object)this);
            try {
                this.field = ((Object)((Object)this)).getClass().getDeclaredField("value");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Field getField() {
            return this.field;
        }

        public Object get() {
            return this.value;
        }

        protected void set(Object object) {
            this.value = (Integer)object;
        }
    }
}

