/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import java.util.BitSet;
import java.util.EnumMap;
import net.minecraft.util.EnumFacing;

public class FaceDataHook {
    private final EnumMap<EnumFacing, BitSet> data = new EnumMap(EnumFacing.class);
    private final int vMax;

    public FaceDataHook(int uMax, int vMax) {
        this.vMax = vMax;
        int size = uMax * vMax;
        BitSet initialData = new BitSet(size);
        this.data.put(EnumFacing.WEST, initialData);
        this.data.put(EnumFacing.EAST, new BitSet(size));
        this.data.put(EnumFacing.UP, new BitSet(size));
        this.data.put(EnumFacing.DOWN, new BitSet(size));
    }

    public void set(EnumFacing facing, int u, int v) {
        BitSet dataSet = this.data.get(facing);
        dataSet.set(this.getIndex(u, v));
    }

    public boolean get(EnumFacing facing, int u, int v) {
        BitSet dataSet = this.data.get(facing);
        return dataSet.get(this.getIndex(u, v));
    }

    private int getIndex(int u, int v) {
        return v * this.vMax + u;
    }
}

