/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import java.lang.reflect.Constructor;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.Type;

public class ModContainerFactoryHook {
    public static ModContainer build(ASMModParser parser, ModCandidate container, Map<Type, Constructor<? extends ModContainer>> modTypes) {
        String className = parser.getASMType().getClassName();
        for (ModAnnotation annotation2 : parser.getAnnotations()) {
            if (!modTypes.containsKey(annotation2.getASMType())) continue;
            FMLLog.fine((String)"Identified a mod of type %s (%s) - loading", (Object[])new Object[]{annotation2.getASMType(), className});
            try {
                ModContainer ret = modTypes.get(annotation2.getASMType()).newInstance(className, container, annotation2.getValues());
                if (!ret.shouldLoadInEnvironment()) {
                    FMLLog.fine((String)"Skipping mod %s, container opted to not load.", (Object[])new Object[]{className});
                    return null;
                }
                return ret;
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to construct %s container", (Object[])new Object[]{annotation2.getASMType().getClassName()});
                return null;
            }
        }
        return null;
    }
}

