/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import cc.polyfrost.oneconfig.libs.elementa.constraints.animation.Animations;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.hooks.EntityRendererHook;
import org.lwjgl.input.Mouse;

public class ZoomHook {
    private static final float normalModifier = 4.0f;
    private static float currentModifier = 4.0f;
    private static boolean hasScrolledYet = false;
    private static long lastMillis = System.currentTimeMillis();
    private static float desiredModifier = currentModifier;
    public static boolean zoomed = false;
    public static float smoothZoomProgress = 0.0f;

    public static float getScrollZoomModifier() {
        int moved;
        if (!PatcherConfig.scrollToZoom) {
            return 4.0f;
        }
        long time = System.currentTimeMillis();
        long timeSinceLastChange = time - lastMillis;
        if (!zoomed) {
            lastMillis = time;
        }
        if ((moved = Mouse.getDWheel()) > 0) {
            smoothZoomProgress = 0.0f;
            hasScrolledYet = true;
            desiredModifier += 0.25f * desiredModifier;
        } else if (moved < 0) {
            smoothZoomProgress = 0.0f;
            hasScrolledYet = true;
            desiredModifier -= 0.25f * desiredModifier;
            EntityRendererHook.fixMissingChunks();
        }
        if (desiredModifier < 1.0f) {
            desiredModifier = 1.0f;
        }
        if (desiredModifier > 600.0f) {
            desiredModifier = 600.0f;
        }
        if (PatcherConfig.smoothZoomAnimationWhenScrolling) {
            if (hasScrolledYet && smoothZoomProgress < 1.0f) {
                EntityRendererHook.fixMissingChunks();
                smoothZoomProgress = smoothZoomProgress > 1.0f ? 1.0f : (smoothZoomProgress += 0.004f * (float)timeSinceLastChange);
                currentModifier += (desiredModifier - currentModifier) * ZoomHook.calculateZoomEasing(smoothZoomProgress);
                return currentModifier;
            }
        } else {
            currentModifier = desiredModifier;
        }
        return desiredModifier;
    }

    public static float getSmoothZoomModifier() {
        long time = System.currentTimeMillis();
        long timeSinceLastChange = time - lastMillis;
        lastMillis = time;
        if (zoomed) {
            if (hasScrolledYet) {
                return 1.0f;
            }
            if (smoothZoomProgress < 1.0f) {
                smoothZoomProgress = (smoothZoomProgress += 0.005f * (float)timeSinceLastChange) > 1.0f ? 1.0f : smoothZoomProgress;
                return 4.0f - 3.0f * ZoomHook.calculateZoomEasing(smoothZoomProgress);
            }
        } else {
            if (hasScrolledYet) {
                hasScrolledYet = false;
                smoothZoomProgress = 1.0f;
            }
            if (smoothZoomProgress > 0.0f) {
                smoothZoomProgress = (smoothZoomProgress -= 0.005f * (float)timeSinceLastChange) < 0.0f ? 0.0f : smoothZoomProgress;
                EntityRendererHook.fixMissingChunks();
                float progress = 1.0f - smoothZoomProgress;
                float diff = PatcherConfig.scrollToZoom ? 1.0f / currentModifier : 0.25f;
                return diff + (1.0f - diff) * ZoomHook.calculateZoomEasing(progress);
            }
        }
        return 1.0f;
    }

    private static float calculateZoomEasing(float x) {
        switch (PatcherConfig.smoothZoomAlgorithm) {
            case 0: {
                return Animations.IN_OUT_QUAD.getValue(x);
            }
            case 1: {
                return Animations.IN_OUT_CIRCULAR.getValue(x);
            }
            case 2: {
                return Animations.OUT_QUINT.getValue(x);
            }
        }
        return Animations.IN_OUT_QUAD.getValue(x);
    }

    public static void resetZoomState() {
        hasScrolledYet = false;
        currentModifier = 4.0f;
        desiredModifier = 4.0f;
        smoothZoomProgress = 0.0f;
    }

    public static void handleZoomStateChange(boolean newZoomed) {
        if (newZoomed && !zoomed) {
            Mouse.getDWheel();
        } else if (!newZoomed && zoomed) {
            EntityRendererHook.resetSensitivity();
        }
        zoomed = newZoomed;
    }
}

