/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.mixins.performance;

import club.sk1er.patcher.ducks.WorldExt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={World.class})
public class WorldMixin_TileEntityUnload
implements WorldExt {
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    @Shadow
    @Final
    public List<TileEntity> field_175730_i;
    @Unique
    private LongOpenHashSet patcher$tileEntitiesChunkToBeRemoved = new LongOpenHashSet();

    @Override
    public void patcher$markTileEntitiesInChunkForRemoval(Chunk chunk) {
        if (!chunk.func_177434_r().isEmpty()) {
            long pos = ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
            this.patcher$tileEntitiesChunkToBeRemoved.add(pos);
        }
    }

    @Inject(method={"updateEntities"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;processingLoadedTiles:Z", opcode=181, ordinal=1)})
    private void removeInUnloaded(CallbackInfo ci) {
        if (!this.patcher$tileEntitiesChunkToBeRemoved.isEmpty()) {
            Predicate<TileEntity> isInChunk = tileEntity -> {
                long tileChunkPos = ChunkCoordIntPair.func_77272_a((int)(tileEntity.func_174877_v().func_177958_n() >> 4), (int)(tileEntity.func_174877_v().func_177952_p() >> 4));
                return this.patcher$tileEntitiesChunkToBeRemoved.contains(tileChunkPos);
            };
            Predicate<TileEntity> isInChunkDoUnload = tileEntity -> {
                boolean inChunk = isInChunk.test((TileEntity)tileEntity);
                if (inChunk) {
                    tileEntity.onChunkUnload();
                }
                return inChunk;
            };
            this.field_175730_i.removeIf(isInChunk);
            this.field_147482_g.removeIf(isInChunkDoUnload);
            this.patcher$tileEntitiesChunkToBeRemoved.clear();
        }
    }
}

