/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.mixins.performance.forge;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.hooks.FaceDataHook;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ItemLayerModel.class}, remap=false)
public abstract class ItemLayerModelMixin_ReduceQuadCount {
    @Unique
    private static final EnumFacing[] patcher$HORIZONTALS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    @Unique
    private static final EnumFacing[] patcher$VERTICALS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    @Unique
    private static int patcher$size;

    @Shadow
    private static BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform2, EnumFacing side, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        return null;
    }

    @Overwrite
    public ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform2) {
        int off2;
        int off;
        boolean face;
        boolean building;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        FaceDataHook faceData = new FaceDataHook(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] pixels2 = sprite.func_147965_a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t;
                    int alpha = ItemLayerModelMixin_ReduceQuadCount.patcher$getAlpha(pixels2, uMax, vMax, u, v);
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(EnumFacing.WEST, u, v);
                    }
                    if (!ptu && t) {
                        faceData.set(EnumFacing.EAST, u - 1, v);
                    }
                    if (ptv[u] && !t) {
                        faceData.set(EnumFacing.UP, u, v);
                    }
                    if (!ptv[u] && t) {
                        faceData.set(EnumFacing.DOWN, u, v - 1);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                faceData.set(EnumFacing.EAST, uMax - 1, v);
            }
            for (int u2 = 0; u2 < uMax; ++u2) {
                if (ptv[u2]) continue;
                faceData.set(EnumFacing.DOWN, u2, vMax - 1);
            }
        }
        for (EnumFacing facing : patcher$HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            uStart = u3;
                        }
                        uEnd = u3 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off = facing == EnumFacing.DOWN ? 1 : 0;
                        builder.add((Object)ItemLayerModelMixin_ReduceQuadCount.patcher$buildSideQuad(format, transform2, facing, tint, sprite, uStart, v + off, u3 - uStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off2 = facing == EnumFacing.DOWN ? 1 : 0;
                builder.add((Object)ItemLayerModelMixin_ReduceQuadCount.patcher$buildSideQuad(format, transform2, facing, tint, sprite, uStart, v + off2, uEnd - uStart));
            }
        }
        for (EnumFacing facing : patcher$VERTICALS) {
            for (int u2 = 0; u2 < uMax; ++u2) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v2 = 0; v2 < vMax; ++v2) {
                    face = faceData.get(facing, u2, v2);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            vStart = v2;
                        }
                        vEnd = v2 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off = facing == EnumFacing.EAST ? 1 : 0;
                        builder.add((Object)ItemLayerModelMixin_ReduceQuadCount.patcher$buildSideQuad(format, transform2, facing, tint, sprite, u2 + off, vStart, v2 - vStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v2;
                }
                if (!building) continue;
                off2 = facing == EnumFacing.EAST ? 1 : 0;
                builder.add((Object)ItemLayerModelMixin_ReduceQuadCount.patcher$buildSideQuad(format, transform2, facing, tint, sprite, u2 + off2, vStart, vEnd - vStart));
            }
        }
        builder.add((Object)Objects.requireNonNull(ItemLayerModelMixin_ReduceQuadCount.buildQuad(format, transform2, EnumFacing.NORTH, tint, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h())));
        builder.add((Object)Objects.requireNonNull(ItemLayerModelMixin_ReduceQuadCount.buildQuad(format, transform2, EnumFacing.SOUTH, tint, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g())));
        return builder.build();
    }

    @Unique
    private static BakedQuad patcher$buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform2, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v, int size) {
        patcher$size = size;
        return ItemLayerModelMixin_ReduceQuadCount.buildSideQuad(format, transform2, side, tint, sprite, u, v);
    }

    @Unique
    private static int patcher$getAlpha(int[] pixels2, int uMax, int vMax, int u, int v) {
        return pixels2[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF;
    }

    @Overwrite
    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform2, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.4683f;
        float z1 = 0.5317f;
        switch (side) {
            case WEST: {
                z0 = 0.5317f;
                z1 = 0.4683f;
            }
            case EAST: {
                y1 = (float)(v + patcher$size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.5317f;
                z1 = 0.4683f;
            }
            case UP: {
                x1 = (float)(u + patcher$size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.5f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.5f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        switch (side) {
            case WEST: 
            case EAST: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)height;
                v1 += 0.5f / (float)width;
                break;
            }
            case DOWN: 
            case UP: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)width;
                u1 -= 0.5f / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case WEST: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case EAST: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case DOWN: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case UP: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModelMixin_ReduceQuadCount.buildQuad(format, transform2, ItemLayerModelMixin_ReduceQuadCount.patcher$remap(side), tint, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    @Unique
    private static EnumFacing patcher$remap(EnumFacing side) {
        return !PatcherConfig.heldItemLighting || side.func_176740_k() == EnumFacing.Axis.Y ? side.func_176734_d() : side;
    }
}

