/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.mixins.plugin;

import club.sk1er.patcher.tweaker.ClassTransformer;
import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.Set;
import kotlin.text.StringsKt;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PatcherMixinPlugin
implements IMixinConfigPlugin {
    private static final String LABYMOD_CLASS = "net/labymod/main/LabyMod.class";
    private static final String SMOOTHFONT_CLASS = "bre/smoothfont/mod_SmoothFont.class";
    private static final String OF_CONFIG_CLASS = "Config.class";
    private static final ArrayListMultimap<String, String> CONFLICTING_CLASSES = ArrayListMultimap.create();
    private static boolean isEarsMod = false;

    public void onLoad(String mixinPackage) {
        try {
            Class.forName("com.unascribed.ears.Ears", false, this.getClass().getClassLoader());
            isEarsMod = true;
        }
        catch (ClassNotFoundException ignored) {
            isEarsMod = false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("_EarsMod")) {
            return isEarsMod;
        }
        String mixinPackage = StringsKt.substringBeforeLast((String)mixinClassName, (char)'.', (String)mixinClassName);
        if (mixinPackage.endsWith("optifine") && "NONE".equals(ClassTransformer.optifineVersion)) {
            return false;
        }
        for (String conflictingClass : CONFLICTING_CLASSES.get((Object)StringsKt.substringAfterLast((String)mixinClassName, (char)'.', (String)mixinClassName))) {
            if (this.getClass().getClassLoader().getResource(conflictingClass) == null) continue;
            return false;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        MixinEnvironment.getDefaultEnvironment().addTransformerExclusion("com.unascribed.ears.asm.PlatformTransformerAdapter");
        CONFLICTING_CLASSES.put((Object)"GuiContainerMixin_MouseBindFixThatLabyBreaks", (Object)LABYMOD_CLASS);
        CONFLICTING_CLASSES.put((Object)"FontRendererMixin_Optimization", (Object)SMOOTHFONT_CLASS);
        CONFLICTING_CLASSES.put((Object)"MathHelperMixin_CompactLUT", (Object)OF_CONFIG_CLASS);
    }
}

