/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render.caching;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.GuiIngameAccessor;
import club.sk1er.patcher.mixins.accessors.GuiIngameForgeAccessor;
import club.sk1er.patcher.tweaker.ClassTransformer;
import club.sk1er.patcher.util.chat.ChatUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class HUDCaching {
    private static final Minecraft mc = Minecraft.func_71410_x();
    @Nullable
    public static Framebuffer hudFramebuffer;
    private static boolean hudDirty;
    public static boolean renderingCacheOverride;
    private static long nextHudRefresh;
    private static int lastHotbar;
    private static boolean isChatOpen;
    public static boolean renderVignetteCaptured;
    public static boolean renderHelmetCaptured;
    public static float renderPortalCapturedTicks;
    public static boolean renderCrosshairsCaptured;

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && PatcherConfig.hudCaching && HUDCaching.mc.field_71439_g != null) {
            if (!OpenGlHelper.func_148822_b()) {
                String statement = (!ClassTransformer.optifineVersion.equals("NONE") ? "\n&cTry to disable OptiFine's Fast Render/Anti-aliasing option." : "") + "\n&7Are Framebuffers supported?: &e&l" + OpenGlHelper.field_148823_f;
                ChatUtilities.sendMessage("&cFramebuffers appear to be disabled, automatically disabling HUDCaching." + statement);
                PatcherConfig.hudCaching = false;
            } else {
                if (lastHotbar != HUDCaching.mc.field_71439_g.field_71071_by.field_70461_c) {
                    hudDirty = true;
                    lastHotbar = HUDCaching.mc.field_71439_g.field_71071_by.field_70461_c;
                }
                if (isChatOpen != HUDCaching.mc.field_71456_v.func_146158_b().func_146241_e()) {
                    hudDirty = true;
                    isChatOpen = HUDCaching.mc.field_71456_v.func_146158_b().func_146241_e();
                }
            }
        }
    }

    public static void renderCachedHud(EntityRenderer renderer, GuiIngame ingame, float partialTicks) {
        if (!OpenGlHelper.func_148822_b() || !PatcherConfig.hudCaching) {
            ingame.func_175180_a(partialTicks);
        } else {
            GlStateManager.func_179126_j();
            ScaledResolution resolution = new ScaledResolution(mc);
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            renderer.func_78478_c();
            GlStateManager.func_179147_l();
            if (hudFramebuffer != null && System.currentTimeMillis() > nextHudRefresh) {
                hudDirty = true;
            }
            if (hudDirty || hudFramebuffer == null) {
                hudDirty = false;
                nextHudRefresh = System.currentTimeMillis() + (long)(1000 / PatcherConfig.cacheFPS);
                hudFramebuffer = HUDCaching.checkFramebufferSizes(hudFramebuffer, HUDCaching.mc.field_71443_c, HUDCaching.mc.field_71440_d);
                hudFramebuffer.func_147614_f();
                hudFramebuffer.func_147610_a(false);
                GlStateManager.func_179084_k();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179106_n();
                renderingCacheOverride = true;
                ingame.func_175180_a(partialTicks);
                renderingCacheOverride = false;
                mc.func_147110_a().func_147610_a(false);
                GlStateManager.func_179147_l();
            }
            if (hudFramebuffer != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiIngameAccessor gui = (GuiIngameAccessor)ingame;
                if (renderVignetteCaptured) {
                    gui.invokeRenderVignette(HUDCaching.mc.field_71439_g.func_70013_c(partialTicks), resolution);
                } else {
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                WorldRenderer worldRenderer = tessellator.func_178180_c();
                if (ingame instanceof GuiIngameForge) {
                    GuiIngameForgeAccessor guiForge = (GuiIngameForgeAccessor)ingame;
                    if (renderHelmetCaptured) {
                        guiForge.callRenderHelmet(resolution, partialTicks);
                    }
                    if (renderPortalCapturedTicks > 0.0f) {
                        guiForge.callRenderPortal(resolution, partialTicks);
                    }
                    if (renderCrosshairsCaptured) {
                        guiForge.callRenderCrosshairs(width, height);
                    }
                } else {
                    if (renderHelmetCaptured) {
                        gui.invokeRenderPumpkinOverlay(resolution);
                    }
                    if (renderPortalCapturedTicks > 0.0f) {
                        gui.invokeRenderPortal(renderPortalCapturedTicks, resolution);
                    }
                    if (renderCrosshairsCaptured) {
                        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                        GlStateManager.func_179141_d();
                        HUDCaching.drawTexturedModalRect(tessellator, worldRenderer, (width >> 1) - 7, (height >> 1) - 7);
                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    }
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                hudFramebuffer.func_147612_c();
                HUDCaching.drawTexturedRect(tessellator, worldRenderer, (float)resolution.func_78327_c(), (float)resolution.func_78324_d());
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            }
            GlStateManager.func_179126_j();
        }
    }

    private static Framebuffer checkFramebufferSizes(Framebuffer framebuffer, int width, int height) {
        if (framebuffer == null || framebuffer.field_147621_c != width || framebuffer.field_147618_d != height) {
            if (framebuffer == null) {
                framebuffer = new Framebuffer(width, height, true);
                framebuffer.enableStencil();
                framebuffer.field_147625_i[0] = 0.0f;
                framebuffer.field_147625_i[1] = 0.0f;
                framebuffer.field_147625_i[2] = 0.0f;
            } else {
                framebuffer.func_147613_a(width, height);
            }
            framebuffer.func_147607_a(9728);
        }
        return framebuffer;
    }

    private static void drawTexturedRect(Tessellator tessellator, WorldRenderer worldrenderer, float width, float height) {
        GlStateManager.func_179098_w();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(0.0, (double)height, 0.0).func_181673_a(0.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)width, (double)height, 0.0).func_181673_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)width, 0.0, 0.0).func_181673_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b(0.0, 0.0, 0.0).func_181673_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    private static void drawTexturedModalRect(Tessellator tessellator, WorldRenderer worldrenderer, int x, int y) {
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + 16), 100.0).func_181673_a(0.0, 0.0625).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 16), (double)(y + 16), 100.0).func_181673_a(0.0625, 0.0625).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 16), (double)y, 100.0).func_181673_a(0.0625, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 100.0).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    static {
        hudDirty = true;
        isChatOpen = false;
    }
}

