/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render.overlay;

import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.ItemAccessor;
import club.sk1er.patcher.mixins.accessors.ItemStackAccessor;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GlanceRenderer {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final DecimalFormat format = new DecimalFormat("#.###");
    private boolean renderingArrows;
    private boolean renderingDamage;
    private final Map<Integer, String> shortEnchantmentNames = new HashMap<Integer, String>(){
        {
            this.put(0, "P");
            this.put(1, "FP");
            this.put(2, "FF");
            this.put(3, "BP");
            this.put(4, "PP");
            this.put(5, "R");
            this.put(6, "AA");
            this.put(7, "T");
            this.put(8, "DS");
            this.put(9, "FW");
            this.put(16, "SH");
            this.put(17, "SM");
            this.put(18, "BoA");
            this.put(19, "KB");
            this.put(20, "FA");
            this.put(21, "L");
            this.put(32, "EFF");
            this.put(33, "ST");
            this.put(34, "UNB");
            this.put(35, "F");
            this.put(48, "POW");
            this.put(49, "PUN");
            this.put(50, "FLA");
            this.put(51, "INF");
            this.put(61, "LoS");
            this.put(62, "LU");
            this.put(70, "MEN");
        }
    };

    @SubscribeEvent
    public void renderDamage(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        RenderGameOverlayEvent.ElementType type = event.type;
        ScaledResolution res = event.resolution;
        if (type != RenderGameOverlayEvent.ElementType.TEXT || !PatcherConfig.damageGlance || player == null || player.func_175149_v()) {
            return;
        }
        ItemStack heldItemStack = player.field_71071_by.func_70448_g();
        if (heldItemStack != null) {
            String attackDamage = this.getAttackDamageString(heldItemStack);
            if (attackDamage == null) {
                return;
            }
            this.renderingDamage = true;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            int x = res.func_78326_a() - (this.mc.field_71466_p.func_78256_a(attackDamage) >> 1);
            int y = (res.func_78328_b() - 56 + (this.mc.field_71442_b.func_78755_b() ? -1 : 14) + 9 << 1) + 9;
            this.mc.field_71466_p.func_175065_a(attackDamage, (float)x, (float)y, -1, true);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void renderItemCount(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        RenderGameOverlayEvent.ElementType type = event.type;
        ScaledResolution res = event.resolution;
        if (type != RenderGameOverlayEvent.ElementType.TEXT || !PatcherConfig.itemCountGlance || player == null || player.func_175149_v()) {
            return;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null) {
            boolean shouldRenderArrowCount;
            boolean holdingBow = currentItem.func_77973_b() instanceof ItemBow;
            int count = this.getHeldItemCount(holdingBow);
            this.renderingArrows = shouldRenderArrowCount = holdingBow && count > 0;
            if (count > 1 || shouldRenderArrowCount) {
                int offset2 = this.mc.field_71442_b.func_178889_l() == WorldSettings.GameType.CREATIVE ? -12 : 0;
                this.mc.field_71466_p.func_175065_a(String.valueOf(count), (float)(res.func_78326_a() - this.mc.field_71466_p.func_78256_a(String.valueOf(count)) >> 1), (float)(res.func_78328_b() - 43 - offset2), -1, true);
            }
        }
    }

    @SubscribeEvent
    public void renderEnchantments(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        RenderGameOverlayEvent.ElementType type = event.type;
        ScaledResolution res = event.resolution;
        if (type != RenderGameOverlayEvent.ElementType.TEXT || !PatcherConfig.enchantmentsGlance || player == null || player.func_175149_v()) {
            return;
        }
        ItemStack heldItemStack = player.field_71071_by.func_70448_g();
        if (heldItemStack != null) {
            String toDraw;
            String string = toDraw = heldItemStack.func_77973_b() instanceof ItemPotion ? this.getPotionEffectString(heldItemStack) : this.getEnchantmentString(heldItemStack);
            if (toDraw == null) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            int x = res.func_78326_a() - (this.mc.field_71466_p.func_78256_a(toDraw) >> 1);
            int y = res.func_78328_b() - 56 + (this.mc.field_71442_b.func_78755_b() ? 2 : 14) + 9 << 1;
            if (this.renderingArrows || this.renderingDamage) {
                y -= 7;
            }
            this.mc.field_71466_p.func_175065_a(toDraw, (float)x, (float)y, -1, true);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            GlStateManager.func_179121_F();
        }
    }

    private String getAttackDamageString(ItemStack stack) {
        Multimap modifiers;
        if (stack != null && !(modifiers = stack.func_111283_C()).isEmpty()) {
            double damage = 0.0;
            int operation = 0;
            for (Map.Entry entry : modifiers.entries()) {
                double baseDamage;
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                if (modifier.func_111167_a() != ItemAccessor.getItemModifierUUID() || !((baseDamage = modifier.func_111164_d() + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)) > 0.0)) continue;
                operation = modifier.func_111169_c();
                damage = operation != 1 && operation != 2 ? baseDamage : baseDamage * 100.0;
                break;
            }
            if (damage > 0.0) {
                return StatCollector.func_74837_a((String)("attribute.modifier.plus." + operation), (Object[])new Object[]{this.format.format(damage), ""});
            }
        }
        return null;
    }

    private int getHeldItemCount(boolean holdingBow) {
        ItemStack currentItem = this.mc.field_71439_g.field_71071_by.func_70448_g();
        if (currentItem == null) {
            return 0;
        }
        int id2 = Item.func_150891_b((Item)currentItem.func_77973_b());
        int data = currentItem.func_77952_i();
        int count = 0;
        if (holdingBow) {
            id2 = Item.func_150891_b((Item)Items.field_151032_g);
            data = 0;
        }
        for (ItemStack itemStack : this.mc.field_71439_g.field_71071_by.field_70462_a) {
            Item item;
            if (itemStack == null || Item.func_150891_b((Item)(item = itemStack.func_77973_b())) != id2 || itemStack.func_77952_i() != data) continue;
            count += ((ItemStackAccessor)itemStack).getStackSize();
        }
        return count;
    }

    private String getPotionEffectString(ItemStack heldItemStack) {
        ItemPotion potion = (ItemPotion)heldItemStack.func_77973_b();
        List effects = potion.func_77832_l(heldItemStack);
        if (effects == null) {
            return null;
        }
        StringBuilder potionBuilder = new StringBuilder();
        for (PotionEffect entry : effects) {
            int duration = entry.func_76459_b() / 20;
            potionBuilder.append(ChatColor.BOLD).append(StatCollector.func_74838_a((String)entry.func_76453_d())).append(" ").append(entry.func_76458_c() + 1).append(" ").append("(").append(duration / 60).append(String.format(":%02d", duration % 60)).append(") ");
        }
        return potionBuilder.toString().trim();
    }

    private String getEnchantmentString(ItemStack heldItemStack) {
        StringBuilder builder = new StringBuilder();
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)heldItemStack);
        for (Map.Entry entry : enchantmentMap.entrySet()) {
            builder.append(ChatColor.BOLD).append(this.shortEnchantmentNames.get(entry.getKey())).append(" ").append(entry.getValue()).append(" ");
        }
        return builder.toString().trim();
    }
}

