/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.other;

import club.sk1er.patcher.asm.external.mods.essential.EssentialModelRendererTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.EntityCullingTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.EntityRendererTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.FullbrightTickerTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.GuiDetailSettingsOFTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.LagometerTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.OptiFineHookTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.OptifineFontRendererTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.RandomEntitiesTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.RendererLivingEntityTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.common.BakedQuadReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.common.EntityRendererReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.common.ExtendedBlockStorageReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.common.FaceBakeryReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.common.ModelRotationReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.modern.CustomColorsReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.modern.ItemModelMesherReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.reflectionoptimizations.modern.RenderChunkReflectionOptimizer;
import club.sk1er.patcher.asm.external.mods.optifine.signfix.GuiEditSignTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.signfix.TileEntitySignRendererTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.witherfix.EntityWitherTransformer;
import club.sk1er.patcher.asm.external.mods.optifine.xpfix.GuiIngameForgeTransformer;
import club.sk1er.patcher.asm.external.mods.pingtag.TagRendererListenerTransformer;
import club.sk1er.patcher.asm.external.mods.pingtag.TagRendererTransformer;
import club.sk1er.patcher.asm.external.mods.sidebarmod.GuiSidebarTransformer;
import club.sk1er.patcher.asm.external.mods.ve.BetterChatTransformer;
import club.sk1er.patcher.asm.external.optifine.WorldVertexBufferUploaderTransformer;
import club.sk1er.patcher.asm.render.screen.InventoryEffectRendererTransformer;
import club.sk1er.patcher.optifine.OptiFineGenerations;
import club.sk1er.patcher.tweaker.ClassTransformer;
import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class ModClassTransformer
implements IClassTransformer {
    private final Logger logger = LogManager.getLogger((String)"Patcher - Mod Class Transformer");
    private final Multimap<String, PatcherTransformer> transformerMap = ArrayListMultimap.create();

    public ModClassTransformer() {
        MixinEnvironment.getCurrentEnvironment().addTransformerExclusion(this.getClass().getName());
        this.registerTransformer(new EntityRendererTransformer());
        this.registerTransformer(new RendererLivingEntityTransformer());
        this.registerTransformer(new TagRendererTransformer());
        this.registerTransformer(new TagRendererListenerTransformer());
        this.registerTransformer(new BetterChatTransformer());
        this.registerTransformer(new EssentialModelRendererTransformer());
        if (!ModClassTransformer.isDevelopment()) {
            this.registerTransformer(new InventoryEffectRendererTransformer());
        }
        this.registerTransformer(new GuiSidebarTransformer());
        String optifineVersion = ClassTransformer.optifineVersion;
        OptiFineGenerations generations = ClassTransformer.generations;
        if (generations.getIGeneration().contains(optifineVersion)) {
            this.registerCommonTransformers();
            this.registerI7Transformers();
        } else if (generations.getLGeneration().contains(optifineVersion)) {
            this.registerCommonTransformers();
            this.registerLSeriesTransformers();
            this.registerLSeriesFixesTransformers();
        } else if (generations.getMGeneration().contains(optifineVersion) || generations.getFutureGeneration().contains(optifineVersion)) {
            this.registerCommonTransformers();
            this.registerLSeriesTransformers();
        } else {
            this.logger.info("User's OptiFine version ({}) does not support any reflection optimizations, none will be applied.", new Object[]{optifineVersion});
        }
    }

    private void registerTransformer(PatcherTransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        return ClassTransformer.createTransformer(transformedName, bytes, this.transformerMap, this.logger);
    }

    private void registerCommonTransformers() {
        this.registerTransformer(new BakedQuadReflectionOptimizer());
        this.registerTransformer(new FaceBakeryReflectionOptimizer());
        this.registerTransformer(new ModelRotationReflectionOptimizer());
        this.registerTransformer(new ExtendedBlockStorageReflectionOptimizer());
        this.registerTransformer(new EntityRendererReflectionOptimizer());
        this.registerTransformer(new LagometerTransformer());
        this.registerTransformer(new GuiIngameForgeTransformer());
        this.registerTransformer(new OptifineFontRendererTransformer());
        this.registerTransformer(new OptiFineHookTransformer());
        this.registerTransformer(new FullbrightTickerTransformer());
        this.registerTransformer(new EntityCullingTransformer());
        this.registerTransformer(new WorldVertexBufferUploaderTransformer());
    }

    private void registerI7Transformers() {
    }

    private void registerLSeriesTransformers() {
        this.registerTransformer(new ItemModelMesherReflectionOptimizer());
        this.registerTransformer(new CustomColorsReflectionOptimizer());
        this.registerTransformer(new RenderChunkReflectionOptimizer());
        this.registerTransformer(new GuiDetailSettingsOFTransformer());
    }

    private void registerLSeriesFixesTransformers() {
        this.registerTransformer(new GuiEditSignTransformer());
        this.registerTransformer(new TileEntitySignRendererTransformer());
        this.registerTransformer(new RandomEntitiesTransformer());
        this.registerTransformer(new EntityWitherTransformer());
    }

    public static boolean isDevelopment() {
        Object o = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return o != null && (Boolean)o != false;
    }
}

