/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.chat;

import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.GuiNewChatAccessor;
import club.sk1er.patcher.util.chat.ChatComponentIgnored;
import club.sk1er.patcher.util.chat.ChatUtilities;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChatHandler {
    private static final Map<Integer, ChatEntry> chatMessageMap = new HashMap<Integer, ChatEntry>();
    private static final Map<Integer, Set<ChatLine>> messagesForHash = new HashMap<Integer, Set<ChatLine>>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final String chatTimestampRegex = "^(?:\\[\\d\\d:\\d\\d(:\\d\\d)?(?: AM| PM|)]|<\\d\\d:\\d\\d>) ";
    private static final DecimalFormat decimalFormat = new DecimalFormat("#,###");
    public static int currentMessageHash = -1;
    private int ticks;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatMessage(ClientChatReceivedEvent event) {
        IChatComponent message = event.message;
        byte type = event.type;
        byte gameInfoType = 2;
        if (PatcherConfig.timestamps && !message.func_150260_c().trim().isEmpty() && type != gameInfoType) {
            String time = ChatHandler.getCurrentTime();
            if (PatcherConfig.timestampsStyle == 0) {
                ChatComponentIgnored component2 = new ChatComponentIgnored(ChatColor.GRAY + "[" + time + "] " + ChatColor.RESET);
                component2.func_150257_a(event.message);
                event.message = component2;
            } else if (PatcherConfig.timestampsStyle == 1) {
                LinkedList<IChatComponent> queue = new LinkedList<IChatComponent>();
                queue.add(event.message);
                while (!queue.isEmpty()) {
                    IChatComponent component3 = (IChatComponent)queue.remove();
                    List siblings = component3.func_150253_a();
                    if (siblings.isEmpty()) {
                        HoverEvent hoverEvent = component3.func_150256_b().func_150210_i();
                        if (hoverEvent == null) {
                            component3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentIgnored(ChatUtilities.translate("&7Sent at &e" + time + "&7."))));
                            continue;
                        }
                        IChatComponent value = hoverEvent.func_150702_b();
                        value.func_150258_a("\n");
                        value.func_150258_a(ChatUtilities.translate("&7Sent at &e" + time + "&7."));
                        continue;
                    }
                    queue.addAll(component3.func_150253_a());
                }
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.ticks++ >= 12000) {
            long time = System.currentTimeMillis();
            for (Map.Entry<Integer, ChatEntry> entry : chatMessageMap.entrySet()) {
                if (time - entry.getValue().lastSeenMessageMillis <= (long)PatcherConfig.compactChatTime * 1000L) continue;
                messagesForHash.remove(entry.getKey());
            }
            this.ticks = 0;
        }
    }

    @SubscribeEvent
    public void setChatMessageMap(ClientChatReceivedEvent event) {
        IChatComponent message = event.message;
        String clearMessage = ChatHandler.cleanColor(message.func_150254_d()).trim();
        if (clearMessage.isEmpty() && PatcherConfig.removeBlankMessages) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void changeWorld(WorldEvent.Load event) {
        this.ticks = 0;
    }

    public static void appendMessageCounter(IChatComponent chatComponent, boolean refresh) {
        if (Loader.isModLoaded((String)"hychat") || Loader.isModLoaded((String)"labymod") || !PatcherConfig.compactChat) {
            return;
        }
        if (!refresh) {
            String message = ChatHandler.cleanColor(chatComponent.func_150254_d()).trim();
            if (message.isEmpty() || ChatHandler.isDivider(message)) {
                return;
            }
            currentMessageHash = ChatHandler.getChatComponentHash(chatComponent);
            long currentTime = System.currentTimeMillis();
            if (!chatMessageMap.containsKey(currentMessageHash)) {
                chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
            } else {
                ChatEntry entry = chatMessageMap.get(currentMessageHash);
                if (currentTime - entry.lastSeenMessageMillis > (long)PatcherConfig.compactChatTime * 1000L) {
                    chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
                } else {
                    boolean deleted = ChatHandler.deleteMessageByHash(currentMessageHash);
                    if (!deleted) {
                        chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
                    } else {
                        ++entry.messageCount;
                        entry.lastSeenMessageMillis = currentTime;
                        chatComponent.func_150257_a((IChatComponent)new ChatComponentIgnored(ChatColor.GRAY + " (" + decimalFormat.format(entry.messageCount) + ")"));
                    }
                }
            }
        }
    }

    public static void setChatLine_addToList(ChatLine line) {
        if (currentMessageHash != -1) {
            messagesForHash.computeIfAbsent(currentMessageHash, k -> new HashSet()).add(line);
        }
    }

    public static void resetMessageHash() {
        currentMessageHash = -1;
    }

    private static boolean deleteMessageByHash(int hashCode) {
        ChatLine chatLine;
        int index;
        if (!messagesForHash.containsKey(hashCode) || messagesForHash.get(hashCode).isEmpty()) {
            return false;
        }
        Set<ChatLine> toRemove = messagesForHash.get(hashCode);
        messagesForHash.remove(hashCode);
        int normalSearchLength = 100;
        int wrappedSearchLength = 300;
        boolean removedMessage = false;
        List<ChatLine> chatLines = ((GuiNewChatAccessor)ChatHandler.mc.field_71456_v.func_146158_b()).getChatLines();
        for (index = 0; index < chatLines.size() && index < 100; ++index) {
            chatLine = chatLines.get(index);
            if (toRemove.contains(chatLine)) {
                removedMessage = true;
                chatLines.remove(index);
                if (--index < 0 || index >= chatLines.size()) continue;
                index = ChatHandler.getMessageIndex(chatLines, index, chatLine);
                continue;
            }
            if (PatcherConfig.consecutiveCompactChat) break;
        }
        if (!removedMessage) {
            return false;
        }
        List<ChatLine> chatLinesWrapped = ((GuiNewChatAccessor)ChatHandler.mc.field_71456_v.func_146158_b()).getDrawnChatLines();
        for (index = 0; index < chatLinesWrapped.size() && index < 300; ++index) {
            chatLine = chatLinesWrapped.get(index);
            if (toRemove.contains(chatLine)) {
                chatLinesWrapped.remove(index);
                --index;
                if (ChatHandler.mc.field_71456_v.func_146158_b().func_146241_e()) {
                    ChatHandler.mc.field_71456_v.func_146158_b().func_146229_b(-1);
                }
                if (index <= 0 || index >= chatLinesWrapped.size()) continue;
                index = ChatHandler.getMessageIndex(chatLinesWrapped, index, chatLine);
                continue;
            }
            if (PatcherConfig.consecutiveCompactChat) break;
        }
        return true;
    }

    private static int getMessageIndex(List<ChatLine> chatMessageList, int index, ChatLine chatLine) {
        ChatLine prevLine = chatMessageList.get(index);
        if (ChatHandler.isDivider(ChatHandler.cleanColor(prevLine.func_151461_a().func_150260_c())) && Math.abs(chatLine.func_74540_b() - prevLine.func_74540_b()) <= 2) {
            chatMessageList.remove(index);
        }
        if (index >= chatMessageList.size()) {
            return index;
        }
        ChatLine nextLine = chatMessageList.get(index);
        if (ChatHandler.isDivider(ChatHandler.cleanColor(nextLine.func_151461_a().func_150260_c())) && Math.abs(chatLine.func_74540_b() - nextLine.func_74540_b()) <= 2) {
            chatMessageList.remove(index);
        }
        return --index;
    }

    private static int getChatStyleHash(ChatStyle style) {
        HoverEvent hoverEvent = style.func_150210_i();
        HoverEvent.Action hoverAction = null;
        int hoverChatHash = 0;
        if (hoverEvent != null) {
            hoverAction = hoverEvent.func_150701_a();
            hoverChatHash = ChatHandler.getChatComponentHash(hoverEvent.func_150702_b());
        }
        return Objects.hash(style.func_150215_a(), style.func_150223_b(), style.func_150242_c(), style.func_150234_e(), style.func_150236_d(), style.func_150233_f(), hoverAction, hoverChatHash, style.func_150235_h(), style.func_179986_j());
    }

    private static int getChatComponentHash(IChatComponent chatComponent) {
        ArrayList<Integer> siblingHashes = new ArrayList<Integer>();
        for (IChatComponent sibling : chatComponent.func_150253_a()) {
            if (sibling instanceof ChatComponentIgnored || !(sibling instanceof ChatComponentStyle)) continue;
            siblingHashes.add(ChatHandler.getChatComponentHash(sibling));
        }
        if (chatComponent instanceof ChatComponentIgnored) {
            return Objects.hash(siblingHashes);
        }
        String unformattedText = chatComponent.func_150260_c();
        String cleanedMessage = unformattedText.replaceAll(chatTimestampRegex, "").trim();
        return Objects.hash(cleanedMessage, siblingHashes, ChatHandler.getChatStyleHash(chatComponent.func_150256_b()));
    }

    private static boolean isDivider(String clean) {
        clean = clean.replaceAll(chatTimestampRegex, "").trim();
        boolean divider = true;
        if (clean.length() < 5) {
            divider = false;
        } else {
            for (int i = 0; i < clean.length(); ++i) {
                char c = clean.charAt(i);
                if (c == '-' || c == '=' || c == '\u25ac') continue;
                divider = false;
                break;
            }
        }
        return divider;
    }

    private static String cleanColor(String in) {
        return in.replaceAll("(?i)\\u00A7.", "");
    }

    public static String getCurrentTime() {
        String timestampsPattern = "[hh:mm a]";
        if (PatcherConfig.secondsOnTimestamps) {
            timestampsPattern = "[hh:mm:ss a]";
        }
        if (PatcherConfig.timestampsFormat == 1) {
            timestampsPattern = "[HH:mm]";
            if (PatcherConfig.secondsOnTimestamps) {
                timestampsPattern = "[HH:mm:ss]";
            }
        }
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(timestampsPattern));
    }

    static class ChatEntry {
        int messageCount;
        long lastSeenMessageMillis;

        ChatEntry(int messageCount, long lastSeenMessageMillis) {
            this.messageCount = messageCount;
            this.lastSeenMessageMillis = lastSeenMessageMillis;
        }
    }
}

