/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.forge;

import cc.polyfrost.oneconfig.utils.Notifications;
import club.sk1er.patcher.config.PatcherConfig;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntrypointCaching {
    public static EntrypointCaching INSTANCE = new EntrypointCaching();
    public final Logger logger = LogManager.getLogger((String)"Patcher Entrypoint Cache");
    private final Type mapType = new TypeToken<List<Map<String, List<String>>>>(){}.getType();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File cacheFile = new File("patcher/entrypoint_cache.json");
    private List<Map<String, List<String>>> readMap;
    private List<Map<String, List<String>>> usedMap = ImmutableList.of(new HashMap(), new HashMap());
    private Map<File, String> hashCache = new HashMap<File, String>();

    private EntrypointCaching() {
        if (!PatcherConfig.cacheEntrypoints) {
            return;
        }
        try {
            if (this.cacheFile.exists()) {
                String cacheText = FileUtils.readFileToString((File)this.cacheFile);
                this.readMap = (List)this.gson.fromJson(cacheText, this.mapType);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to read entrypoint cache", (Throwable)e);
        }
        this.readMap = ImmutableList.of(new HashMap(), new HashMap());
    }

    public List<ModContainer> discoverCachedEntrypoints(ModCandidate candidate, ASMDataTable table, JarFile file, MetadataCollection mc) {
        if (!PatcherConfig.cacheEntrypoints || this.readMap == null) {
            return null;
        }
        File modFile = candidate.getModContainer();
        String hash = this.getHash(modFile);
        if (hash == null) {
            return null;
        }
        List<String> entryClasses = this.readMap.get(0).get(hash);
        List<String> modClasses = this.readMap.get(1).get(hash);
        if (entryClasses == null && modClasses == null) {
            return null;
        }
        ArrayList<ModContainer> foundMods = new ArrayList<ModContainer>();
        ArrayList<String> validEntries = null;
        if (entryClasses != null && !entryClasses.isEmpty()) {
            validEntries = new ArrayList<String>(entryClasses.size());
            for (String string : entryClasses) {
                this.iterateThroughClass(true, candidate, table, file, mc, modFile, foundMods, validEntries, string);
            }
        }
        ArrayList<String> validClasses = null;
        if (modClasses != null && !modClasses.isEmpty()) {
            validClasses = new ArrayList<String>(modClasses.size());
            for (String modClass : modClasses) {
                this.iterateThroughClass(false, candidate, table, file, mc, modFile, foundMods, validClasses, modClass);
            }
        }
        this.logger.info("Found cached entrypoints for " + modFile);
        try {
            file.close();
        }
        catch (Exception exception) {
            this.logger.error("Error closing mod jar " + modFile, (Throwable)exception);
        }
        this.usedMap.get(0).put(hash, validEntries);
        this.usedMap.get(1).put(hash, validClasses);
        return foundMods;
    }

    private void iterateThroughClass(boolean entry, ModCandidate candidate, ASMDataTable table, JarFile file, MetadataCollection mc, File modFile, List<ModContainer> foundMods, List<String> validMods, String modClass) {
        candidate.addClassEntry(modClass);
        if (entry) {
            try (InputStream is = file.getInputStream(new JarEntry(modClass));){
                ASMModParser modParser = new ASMModParser(is);
                modParser.validate();
                modParser.sendToTable(table, candidate);
                ModContainer container = ModContainerFactory.instance().build(modParser, modFile, candidate);
                if (container != null) {
                    table.addContainer(container);
                    foundMods.add(container);
                    validMods.add(modClass);
                    container.bindMetadata(mc);
                }
            }
            catch (Exception e) {
                this.logger.error("Error parsing mod class " + modClass + " from jar " + modFile, (Throwable)e);
            }
        } else {
            validMods.add(modClass);
        }
    }

    public void putCachedEntrypoints(ModCandidate candidate, ZipEntry ze) {
        if (!PatcherConfig.cacheEntrypoints || this.readMap == null) {
            return;
        }
        File modFile = candidate.getModContainer();
        String modClass = ze.getName();
        String hash = this.hashCache.computeIfAbsent(modFile, this::getHash);
        List modClasses = this.usedMap.get(0).computeIfAbsent(hash, h -> new ArrayList());
        if (!modClasses.contains(modClass)) {
            modClasses.add(modClass);
        }
        this.logger.info("Added entrypoint {} for mod jar {}", new Object[]{modClass, modFile});
    }

    public void putCachedClassEntries(ModCandidate candidate, ZipEntry ze) {
        if (!PatcherConfig.cacheEntrypoints || this.readMap == null) {
            return;
        }
        File modFile = candidate.getModContainer();
        String modClass = ze.getName();
        String hash = this.hashCache.computeIfAbsent(modFile, this::getHash);
        List modClasses = this.usedMap.get(1).computeIfAbsent(hash, h -> new ArrayList());
        if (!modClasses.contains(modClass)) {
            modClasses.add(modClass);
        }
    }

    public void onInit() {
        if (!PatcherConfig.cacheEntrypoints || this.readMap == null) {
            return;
        }
        this.readMap = null;
        File patcherDir = new File("patcher");
        if (!patcherDir.exists() && !patcherDir.mkdir()) {
            this.logger.error("Failed to create patcher directory!");
        }
        try {
            if (!this.cacheFile.exists() && !this.cacheFile.createNewFile()) {
                this.logger.error("Failed to create entrypoint cache");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create entrypoint cache", (Throwable)e);
        }
        String jsonString = this.gson.toJson(this.usedMap, this.mapType);
        try {
            FileUtils.write((File)this.cacheFile, (CharSequence)jsonString);
        }
        catch (Exception e) {
            this.logger.error("Failed to write entrypoint cache", (Throwable)e);
        }
        this.usedMap = null;
        this.hashCache = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHash(File modFile) {
        try (FileInputStream fis = new FileInputStream(modFile);){
            byte[] bytes = new byte[2048];
            int read = fis.read(bytes);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes, 0, read);
            long length = modFile.length();
            md.update(new byte[]{(byte)(length >> 56 & 0xFFL), (byte)(length >> 48 & 0xFFL), (byte)(length >> 40 & 0xFFL), (byte)(length >> 32 & 0xFFL), (byte)(length >> 24 & 0xFFL), (byte)(length >> 16 & 0xFFL), (byte)(length >> 8 & 0xFFL), (byte)(length & 0xFFL)});
            String string = Hex.encodeHexString((byte[])md.digest());
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.logger.error("Error hashing mod {}", new Object[]{modFile, e});
            return null;
        }
    }

    public void resetCache() {
        if (this.cacheFile.exists()) {
            if (this.cacheFile.delete()) {
                Notifications.INSTANCE.send("PolyPatcher", "Deleted entrypoint cache", 5000.0f);
                this.logger.info("Deleted entrypoint cache");
            } else {
                Notifications.INSTANCE.send("PolyPatcher", "Failed to delete entrypoint cache!", 5000.0f);
                this.logger.error("Failed to delete entrypoint cache");
            }
        }
    }
}

