/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.forge;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedStateImplementation
extends BlockState.StateImplementation
implements IExtendedBlockState {
    private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
    private final IBlockState cleanState;

    public ExtendedStateImplementation(Block block, ImmutableMap<IProperty, Comparable> properties2, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<IProperty, Comparable, IBlockState> table, IBlockState clean) {
        super(block, properties2, table);
        this.unlistedProperties = unlistedProperties;
        this.cleanState = clean == null ? this : clean;
    }

    @Nonnull
    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(@Nonnull IProperty<T> property, @Nonnull V value) {
        IBlockState clean = super.func_177226_a(property, value);
        if (clean == this.cleanState) {
            return this;
        }
        if (this == this.cleanState) {
            return clean;
        }
        return new ExtendedStateImplementation(this.func_177230_c(), (ImmutableMap<IProperty, Comparable>)clean.func_177228_b(), this.unlistedProperties, (ImmutableTable<IProperty, Comparable, IBlockState>)((BlockState.StateImplementation)clean).getPropertyValueTable(), this.cleanState);
    }

    public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, @Nullable V value) {
        Optional oldValue = (Optional)this.unlistedProperties.get(property);
        if (oldValue == null) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        if (Objects.equals(oldValue.orNull(), value)) {
            return this;
        }
        if (!property.isValid(value)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
        }
        boolean clean = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.unlistedProperties.entrySet()) {
            Optional newValue;
            IUnlistedProperty key = (IUnlistedProperty)entry.getKey();
            Optional optional = newValue = key.equals(property) ? Optional.fromNullable(value) : (Optional)entry.getValue();
            if (newValue.isPresent()) {
                clean = false;
            }
            builder.put((Object)key, (Object)newValue);
        }
        if (clean) {
            return (IExtendedBlockState)this.cleanState;
        }
        return new ExtendedStateImplementation(this.func_177230_c(), (ImmutableMap<IProperty, Comparable>)this.func_177228_b(), builder.build(), (ImmutableTable<IProperty, Comparable, IBlockState>)this.field_177238_c, this.cleanState);
    }

    public Collection<IUnlistedProperty<?>> getUnlistedNames() {
        return this.unlistedProperties.keySet();
    }

    @Nullable
    public <V> V getValue(IUnlistedProperty<V> property) {
        Optional value = (Optional)this.unlistedProperties.get(property);
        if (value == null) {
            throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        return (V)property.getType().cast(value.orNull());
    }

    public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    public IBlockState getClean() {
        return this.cleanState;
    }
}

