/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.fov;

import club.sk1er.patcher.config.PatcherConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FovHandler {
    private static final float MODIFIER_SPEED = 0.1f;
    private static final float MODIFIER_SLOWNESS = -0.075f;
    private static final float MAX_BOW_TICKS = 20.0f;
    private static final Map<Integer, Float> MODIFIER_BY_TICK = new HashMap<Integer, Float>();

    @SubscribeEvent
    public void fovChange(FOVUpdateEvent event) {
        Collection effects;
        if (!PatcherConfig.allowFovModifying) {
            return;
        }
        float base = 1.0f;
        EntityPlayer entity = event.entity;
        ItemStack item = entity.func_71011_bu();
        int useDuration = entity.func_71057_bx();
        if (entity.field_71075_bZ.field_75100_b) {
            base += 0.1f * PatcherConfig.flyingFovModifierFloat;
        }
        if (entity.func_70051_ag()) {
            base += 0.15f * PatcherConfig.sprintingFovModifierFloat;
        }
        if (!(effects = entity.func_70651_bq()).isEmpty()) {
            for (PotionEffect effect : effects) {
                int potionID = effect.func_76456_a();
                if (potionID == 1) {
                    base += 0.1f * ((float)(effect.func_76458_c() & 0xFF) + 1.0f) * PatcherConfig.speedFovModifierFloat;
                }
                if (potionID != 2) continue;
                base += -0.075f * ((float)(effect.func_76458_c() & 0xFF) + 1.0f) * PatcherConfig.slownessFovModifierFloat;
            }
        }
        if (Float.isNaN(base) || Float.isInfinite(base)) {
            base = 1.0f;
        }
        if (item != null && item.func_77973_b() == Items.field_151031_f) {
            int duration = (int)Math.min((float)useDuration, 20.0f);
            float modifier = MODIFIER_BY_TICK.get(duration).floatValue();
            base -= modifier * PatcherConfig.bowFovModifierFloat;
        }
        event.newfov = base;
    }

    @SubscribeEvent
    public void fovModifier(EntityViewRenderEvent.FOVModifier event) {
        if (!PatcherConfig.removeWaterFov) {
            return;
        }
        if (event.block.func_149688_o() != Material.field_151586_h) {
            return;
        }
        event.setFOV(event.getFOV() * 70.0f / 60.0f);
    }

    static {
        MODIFIER_BY_TICK.put(0, Float.valueOf(0.0f));
        MODIFIER_BY_TICK.put(1, Float.valueOf(3.7497282E-4f));
        MODIFIER_BY_TICK.put(2, Float.valueOf(0.0015000105f));
        MODIFIER_BY_TICK.put(3, Float.valueOf(0.0033749938f));
        MODIFIER_BY_TICK.put(4, Float.valueOf(0.0059999824f));
        MODIFIER_BY_TICK.put(5, Float.valueOf(0.009374976f));
        MODIFIER_BY_TICK.put(6, Float.valueOf(0.013499975f));
        MODIFIER_BY_TICK.put(7, Float.valueOf(0.01837498f));
        MODIFIER_BY_TICK.put(8, Float.valueOf(0.023999989f));
        MODIFIER_BY_TICK.put(9, Float.valueOf(0.030375004f));
        MODIFIER_BY_TICK.put(10, Float.valueOf(0.037500024f));
        MODIFIER_BY_TICK.put(11, Float.valueOf(0.04537499f));
        MODIFIER_BY_TICK.put(12, Float.valueOf(0.05400002f));
        MODIFIER_BY_TICK.put(13, Float.valueOf(0.063374996f));
        MODIFIER_BY_TICK.put(14, Float.valueOf(0.07349998f));
        MODIFIER_BY_TICK.put(15, Float.valueOf(0.084375024f));
        MODIFIER_BY_TICK.put(16, Float.valueOf(0.096000016f));
        MODIFIER_BY_TICK.put(17, Float.valueOf(0.10837501f));
        MODIFIER_BY_TICK.put(18, Float.valueOf(0.121500015f));
        MODIFIER_BY_TICK.put(19, Float.valueOf(0.13537502f));
        MODIFIER_BY_TICK.put(20, Float.valueOf(0.14999998f));
    }
}

