/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.sound;

import cc.polyfrost.oneconfig.config.elements.BasicOption;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.config.PatcherSoundConfig;
import club.sk1er.patcher.mixins.accessors.PositionedSoundAccessor;
import club.sk1er.patcher.mixins.accessors.RegistrySimpleAccessor;
import club.sk1er.patcher.mixins.accessors.SoundHandlerAccessor;
import club.sk1er.patcher.mixins.accessors.SoundRegistryAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.Display;

public class SoundHandler
implements IResourceManagerReloadListener {
    private final boolean isWeirdASMMod;
    private final Map<ResourceLocation, BasicOption> data = new HashMap<ResourceLocation, BasicOption>();
    private boolean previousActive = Display.isActive();
    private float previousVolume = -1.0f;

    public SoundHandler() {
        this.handleFocusChange();
        boolean isWeirdASMMod = false;
        try {
            Class.forName("zone.rong.loliasm.api.mixins.RegistrySimpleExtender", false, this.getClass().getClassLoader());
            isWeirdASMMod = true;
        }
        catch (ClassNotFoundException ignored) {
            try {
                Class.forName("mirror.normalasm.api.mixins.RegistrySimpleExtender", false, this.getClass().getClassLoader());
                isWeirdASMMod = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.isWeirdASMMod = isWeirdASMMod;
    }

    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ISound soundResult = event.result;
        if (soundResult instanceof PositionedSoundAccessor) {
            PositionedSoundAccessor result = (PositionedSoundAccessor)soundResult;
            result.setVolume(result.getVolumeField() * this.getVolumeMultiplier(soundResult.func_147650_b()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean active = Display.isActive();
        if (active != this.previousActive) {
            this.previousActive = active;
            this.handleFocusChange();
        }
    }

    private void handleFocusChange() {
        if (!this.previousActive) {
            SoundManager soundManager = ((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndManager();
            this.previousVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
            if (this.previousVolume == -1.0f) {
                return;
            }
            soundManager.func_148601_a(SoundCategory.MASTER, PatcherConfig.unfocusedSounds * this.previousVolume);
        } else {
            ((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndManager().func_148601_a(SoundCategory.MASTER, this.previousVolume);
            this.previousVolume = -1.0f;
        }
    }

    private float getVolumeMultiplier(ResourceLocation sound) {
        BasicOption propertyData = this.data.get(sound);
        if (propertyData != null) {
            Object asAny;
            try {
                asAny = propertyData.get();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (asAny instanceof Integer) {
                return ((Integer)asAny).floatValue() / 100.0f;
            }
        }
        return 1.0f;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        SoundRegistry soundRegistry = ((SoundHandlerAccessor)Minecraft.func_71410_x().func_147118_V()).getSndRegistry();
        Map<ResourceLocation, SoundEventAccessorComposite> sounds = this.isWeirdASMMod ? ((RegistrySimpleAccessor)soundRegistry).getRegistryObjects() : ((SoundRegistryAccessor)soundRegistry).getSoundRegistry();
        new PatcherSoundConfig(this.data, sounds);
    }
}

