/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.math;

import java.lang.reflect.Field;
import net.minecraft.util.MathHelper;

public class CompactSineLUT {
    private static final int[] SINE_TABLE_INT;
    private static final float SINE_TABLE_MIDPOINT;

    public static float sin(float f) {
        return CompactSineLUT.lookup((int)(f * 10430.378f) & 0xFFFF);
    }

    public static float cos(float f) {
        return CompactSineLUT.lookup((int)(f * 10430.378f + 16384.0f) & 0xFFFF);
    }

    private static float lookup(int index) {
        if (index == 32768) {
            return SINE_TABLE_MIDPOINT;
        }
        int neg = (index & 0x8000) << 16;
        int mask = index << 17 >> 31;
        int pos = (0x8001 & mask) + (index ^ mask);
        return Float.intBitsToFloat(SINE_TABLE_INT[pos &= Short.MAX_VALUE] ^ neg);
    }

    static {
        int i;
        float[] SINE_TABLE;
        SINE_TABLE_INT = new int[16385];
        try {
            Field field2;
            try {
                field2 = MathHelper.class.getDeclaredField("SIN_TABLE");
            }
            catch (NoSuchFieldException e) {
                field2 = MathHelper.class.getDeclaredField("field_76144_a");
            }
            field2.setAccessible(true);
            SINE_TABLE = (float[])field2.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            SINE_TABLE = new float[65536];
            for (int i2 = 0; i2 < 65536; ++i2) {
                SINE_TABLE[i2] = (float)Math.sin((double)i2 * Math.PI * 2.0 / 65536.0);
            }
        }
        for (i = 0; i < SINE_TABLE_INT.length; ++i) {
            CompactSineLUT.SINE_TABLE_INT[i] = Float.floatToRawIntBits(SINE_TABLE[i]);
        }
        SINE_TABLE_MIDPOINT = SINE_TABLE[SINE_TABLE.length / 2];
        for (i = 0; i < SINE_TABLE.length; ++i) {
            float expected = SINE_TABLE[i];
            float value = CompactSineLUT.lookup(i);
            if (expected == value) continue;
            throw new IllegalArgumentException(String.format("LUT error at index %d (expected: %s, found: %s)", i, Float.valueOf(expected), Float.valueOf(value)));
        }
    }
}

