/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class FoamyItemLayerModel
implements IRetexturableModel<ItemLayerModel> {
    private static final ResourceLocation MISSINGNO = new ResourceLocation("missingno");
    private static final MethodHandle BUILD_QUAD;
    private static final MethodHandle TEXTURES_GET;
    private final ItemLayerModel parent;

    public FoamyItemLayerModel(ItemLayerModel parent) {
        this.parent = parent;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new FoamyItemLayerModel((ItemLayerModel)this.parent.retexture(textures));
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.parent.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.parent.getTextures();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return FoamyItemLayerModel.bake(this.parent, state, format, bakedTextureGetter);
    }

    public static IFlexibleBakedModel bake(ItemLayerModel parent, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite sprite;
        int i;
        List textures;
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional transform = state.apply(Optional.absent());
        try {
            textures = TEXTURES_GET.invoke(parent);
        }
        catch (Throwable t) {
            return ItemLayerModel.instance.bake(state, format, bakedTextureGetter);
        }
        ImmutableList.Builder textureAtlas = new ImmutableList.Builder();
        if (BUILD_QUAD != null) {
            for (i = 0; i < textures.size(); ++i) {
                sprite = (TextureAtlasSprite)bakedTextureGetter.apply(textures.get(i));
                textureAtlas.add((Object)sprite);
                try {
                    builder.add((Object)BUILD_QUAD.invokeExact(format, transform, EnumFacing.SOUTH, i, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        } else {
            for (i = 0; i < textures.size(); ++i) {
                sprite = (TextureAtlasSprite)bakedTextureGetter.apply(textures.get(i));
                for (BakedQuad quad : ItemLayerModel.instance.getQuadsForSprite(i, sprite, format, transform)) {
                    if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                    builder.add((Object)quad);
                }
            }
        }
        TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply((Object)(textures.isEmpty() ? MISSINGNO : (ResourceLocation)textures.get(0)));
        ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new DynamicItemModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, (List<TextureAtlasSprite>)textureAtlas.build(), format, (Optional<TRSRTransformation>)transform).otherModel;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    static {
        MethodHandle handle = null;
        try {
            handle = MethodHandles.lookup().unreflect(ReflectionHelper.findMethod(ItemLayerModel.class, null, (String[])new String[]{"buildQuad"}, (Class[])new Class[]{VertexFormat.class, Optional.class, EnumFacing.class, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BUILD_QUAD = handle;
        handle = null;
        try {
            handle = MethodHandles.lookup().unreflectGetter(ReflectionHelper.findField(ItemLayerModel.class, (String[])new String[]{"textures"}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TEXTURES_GET = handle;
    }

    public static class DynamicItemModel
    implements IPerspectiveAwareModel,
    IFlexibleBakedModel {
        private final List<TextureAtlasSprite> textures;
        private final TextureAtlasSprite particle;
        private final ImmutableList<BakedQuad> fastQuads;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final Optional<TRSRTransformation> transform;
        private final IFlexibleBakedModel otherModel;

        public DynamicItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, List<TextureAtlasSprite> textures, VertexFormat format, Optional<TRSRTransformation> transform) {
            this.fastQuads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.textures = textures;
            this.format = format;
            this.transform = transform;
            this.otherModel = new Dynamic3DItemModel(this);
        }

        public List<BakedQuad> func_177551_a(EnumFacing facing) {
            return Collections.emptyList();
        }

        public List<BakedQuad> func_177550_a() {
            return this.fastQuads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
            if (type != ItemCameraTransforms.TransformType.GUI) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }

        public VertexFormat getFormat() {
            return this.format;
        }
    }

    public static class Dynamic3DItemModel
    implements IPerspectiveAwareModel,
    IFlexibleBakedModel {
        private final DynamicItemModel parent;
        private SoftReference<List<BakedQuad>> quadsSoft = null;

        public Dynamic3DItemModel(DynamicItemModel parent) {
            this.parent = parent;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, (ImmutableMap)this.parent.transforms, (ItemCameraTransforms.TransformType)type);
            if (type == ItemCameraTransforms.TransformType.GUI && pair.getRight() == null) {
                return Pair.of((Object)this.parent, null);
            }
            return pair;
        }

        public List<BakedQuad> func_177551_a(EnumFacing facing) {
            return Collections.EMPTY_LIST;
        }

        public List<BakedQuad> func_177550_a() {
            if (this.quadsSoft == null || this.quadsSoft.get() == null) {
                ImmutableList.Builder builder = new ImmutableList.Builder();
                for (int i = 0; i < this.parent.textures.size(); ++i) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)this.parent.textures.get(i);
                    builder.addAll((Iterable)ItemLayerModel.instance.getQuadsForSprite(i, sprite, this.parent.format, this.parent.transform));
                }
                this.quadsSoft = new SoftReference<ImmutableList>(builder.build());
            }
            return this.quadsSoft.get();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public VertexFormat getFormat() {
            return this.parent.getFormat();
        }
    }
}

