/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.polynametag.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.annotations.CustomOption;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.Info;
import cc.polyfrost.oneconfig.config.annotations.Slider;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.utils.Notifications;
import club.sk1er.patcher.config.OldPatcherConfig;
import club.sk1er.patcher.config.PatcherConfig;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.polyfrost.polynametag.PolyNametag;
import org.polyfrost.polynametag.render.NametagPreview;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8F@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0012\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R\"\u0010(\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u0012\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\"\u0010+\u001a\u00020\u001e8F@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010 \u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R\"\u0010/\u001a\u00020.8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00106\u001a\u0002058\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\"\u0010:\u001a\u00020\u001e8F@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010 \u001a\u0004\b;\u0010\"\"\u0004\b<\u0010$R\"\u0010=\u001a\u00020\u001e8F@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010 \u001a\u0004\b>\u0010\"\"\u0004\b?\u0010$R\"\u0010@\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010\u0012\u001a\u0004\bA\u0010\u0014\"\u0004\bB\u0010\u0016R\"\u0010C\u001a\u00020\u001e8F@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010 \u001a\u0004\bD\u0010\"\"\u0004\bE\u0010$R\"\u0010F\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010\u0012\u001a\u0004\bG\u0010\u0014\"\u0004\bH\u0010\u0016R\"\u0010I\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010\u0012\u001a\u0004\bJ\u0010\u0014\"\u0004\bK\u0010\u0016R\"\u0010L\u001a\u00020.8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bL\u00100\u001a\u0004\bM\u00102\"\u0004\bN\u00104\u00a8\u0006O"}, d2={"Lorg/polyfrost/polynametag/config/ModConfig;", "Lcc/polyfrost/oneconfig/config/Config;", "<init>", "()V", "Ljava/lang/reflect/Field;", "field", "Lcc/polyfrost/oneconfig/config/annotations/CustomOption;", "annotation", "Lcc/polyfrost/oneconfig/config/elements/OptionPage;", "page", "Lcc/polyfrost/oneconfig/config/data/Mod;", "mod", "", "migrate", "Lcc/polyfrost/oneconfig/config/elements/BasicOption;", "getCustomOption", "(Ljava/lang/reflect/Field;Lcc/polyfrost/oneconfig/config/annotations/CustomOption;Lcc/polyfrost/oneconfig/config/elements/OptionPage;Lcc/polyfrost/oneconfig/config/data/Mod;Z)Lcc/polyfrost/oneconfig/config/elements/BasicOption;", "background", "Z", "getBackground", "()Z", "setBackground", "(Z)V", "Lcc/polyfrost/oneconfig/config/core/OneColor;", "backgroundColor", "Lcc/polyfrost/oneconfig/config/core/OneColor;", "getBackgroundColor", "()Lcc/polyfrost/oneconfig/config/core/OneColor;", "setBackgroundColor", "(Lcc/polyfrost/oneconfig/config/core/OneColor;)V", "", "cornerRadius", "F", "getCornerRadius", "()F", "setCornerRadius", "(F)V", "essentialOffset", "getEssentialOffset", "setEssentialOffset", "hasMigratedPatcher", "getHasMigratedPatcher", "setHasMigratedPatcher", "heightOffset", "getHeightOffset", "setHeightOffset", "", "info1", "I", "getInfo1", "()I", "setInfo1", "(I)V", "Lorg/polyfrost/polynametag/render/NametagPreview;", "nametagPreview", "Lorg/polyfrost/polynametag/render/NametagPreview;", "getNametagPreview", "()Lorg/polyfrost/polynametag/render/NametagPreview;", "paddingX", "getPaddingX", "setPaddingX", "paddingY", "getPaddingY", "setPaddingY", "rounded", "getRounded", "setRounded", "scale", "getScale", "setScale", "showInInventory", "getShowInInventory", "setShowInInventory", "showOwnNametag", "getShowOwnNametag", "setShowOwnNametag", "textType", "getTextType", "setTextType", "PolyNametag-1.8.9-forge"})
public final class ModConfig
extends Config {
    @NotNull
    public static final ModConfig INSTANCE = new ModConfig();
    @Slider(name="Height offset", min=-0.5f, max=0.5f, description="How much to offset the nametag vertically")
    private static float heightOffset;
    @Slider(name="Scale", min=0.0f, max=1.0f, description="How much to scale the nametag")
    private static float scale;
    @Switch(name="Rounded Corners")
    private static boolean rounded;
    @Slider(name="Corner Radius", min=0.0f, max=10.0f)
    private static float cornerRadius;
    @Slider(name="Padding X", min=0.0f, max=10.0f)
    private static float paddingX;
    @Slider(name="Padding Y", min=0.0f, max=10.0f)
    private static float paddingY;
    @Dropdown(name="Text Type", options={"No Shadow", "Shadow", "Full Shadow"}, description="The type of shadow to render")
    private static int textType;
    @Info(text="Using Full Shadow may cause performance issues on low-end devices", type=InfoType.WARNING)
    private static int info1;
    @Switch(name="Show own nametag", description="Whether to show your own nametag")
    private static boolean showOwnNametag;
    @Switch(name="Show in inventory")
    private static boolean showInInventory;
    @Switch(name="Background", description="Whether to render a background behind the nametag")
    private static boolean background;
    @Color(name="Background color", description="The color of the background")
    @NotNull
    private static OneColor backgroundColor;
    @Switch(name="Offset Essential Indicator", description="Offset nametag to center if the player has essential indicator drawn")
    private static boolean essentialOffset;
    @CustomOption
    @NotNull
    private static final transient NametagPreview nametagPreview;
    private static boolean hasMigratedPatcher;

    private ModConfig() {
        super(new Mod("Nametags", ModType.UTIL_QOL, "/polynametag.svg"), "polynametag.json");
    }

    public final float getHeightOffset() {
        return RangesKt.coerceIn((float)heightOffset, (float)-0.5f, (float)0.5f);
    }

    public final void setHeightOffset(float f) {
        heightOffset = f;
    }

    public final float getScale() {
        return RangesKt.coerceIn((float)scale, (float)0.0f, (float)1.0f);
    }

    public final void setScale(float f) {
        scale = f;
    }

    public final boolean getRounded() {
        return rounded;
    }

    public final void setRounded(boolean bl) {
        rounded = bl;
    }

    public final float getCornerRadius() {
        return RangesKt.coerceIn((float)cornerRadius, (float)0.0f, (float)10.0f);
    }

    public final void setCornerRadius(float f) {
        cornerRadius = f;
    }

    public final float getPaddingX() {
        return RangesKt.coerceIn((float)paddingX, (float)0.0f, (float)10.0f);
    }

    public final void setPaddingX(float f) {
        paddingX = f;
    }

    public final float getPaddingY() {
        return RangesKt.coerceIn((float)paddingY, (float)0.0f, (float)10.0f);
    }

    public final void setPaddingY(float f) {
        paddingY = f;
    }

    public final int getTextType() {
        return textType;
    }

    public final void setTextType(int n) {
        textType = n;
    }

    public final int getInfo1() {
        return info1;
    }

    public final void setInfo1(int n) {
        info1 = n;
    }

    public final boolean getShowOwnNametag() {
        return showOwnNametag;
    }

    public final void setShowOwnNametag(boolean bl) {
        showOwnNametag = bl;
    }

    public final boolean getShowInInventory() {
        return showInInventory;
    }

    public final void setShowInInventory(boolean bl) {
        showInInventory = bl;
    }

    public final boolean getBackground() {
        return background;
    }

    public final void setBackground(boolean bl) {
        background = bl;
    }

    @NotNull
    public final OneColor getBackgroundColor() {
        return backgroundColor;
    }

    public final void setBackgroundColor(@NotNull OneColor oneColor) {
        Intrinsics.checkNotNullParameter((Object)oneColor, (String)"<set-?>");
        backgroundColor = oneColor;
    }

    public final boolean getEssentialOffset() {
        return essentialOffset;
    }

    public final void setEssentialOffset(boolean bl) {
        essentialOffset = bl;
    }

    @NotNull
    public final NametagPreview getNametagPreview() {
        return nametagPreview;
    }

    public final boolean getHasMigratedPatcher() {
        return hasMigratedPatcher;
    }

    public final void setHasMigratedPatcher(boolean bl) {
        hasMigratedPatcher = bl;
    }

    @NotNull
    protected BasicOption getCustomOption(@NotNull Field field, @NotNull CustomOption annotation, @NotNull OptionPage page, @NotNull Mod mod, boolean migrate) {
        NametagPreview nametagPreview;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        NametagPreview it = nametagPreview = ModConfig.nametagPreview;
        boolean bl = false;
        ConfigUtils.getSubCategory((OptionPage)page, (String)it.category, (String)it.subcategory).options.add(it);
        return nametagPreview;
    }

    private static final Boolean _init_$lambda$0() {
        return !PolyNametag.INSTANCE.isPatcher() || !PatcherConfig.disableNametagBoxes;
    }

    private static final Boolean _init_$lambda$1() {
        return !PolyNametag.INSTANCE.isPatcher() || !PatcherConfig.showOwnNametag;
    }

    private static final Boolean _init_$lambda$2() {
        return !PolyNametag.INSTANCE.isEssential();
    }

    static {
        scale = 1.0f;
        showOwnNametag = true;
        background = true;
        backgroundColor = new OneColor(0, 0, 0, 63);
        essentialOffset = true;
        nametagPreview = new NametagPreview(null, "General", null, 5, null);
        INSTANCE.initialize();
        INSTANCE.addDependency("backgroundColor", "background");
        INSTANCE.addDependency("background", "Patcher's Disable Nametag Boxes. Please turn it off to use this feature.", ModConfig::_init_$lambda$0);
        INSTANCE.addDependency("showOwnNametag", "Patcher's Show Own Nametag. Please turn it off to use this feature.", ModConfig::_init_$lambda$1);
        INSTANCE.addDependency("cornerRadius", "rounded");
        INSTANCE.addDependency("showInInventory", "showOwnNametag");
        INSTANCE.hideIf("essentialOffset", ModConfig::_init_$lambda$2);
        if (!hasMigratedPatcher) {
            try {
                Class.forName("club.sk1er.patcher.config.OldPatcherConfig");
                boolean didAnything = false;
                if (OldPatcherConfig.shadowedNametagText) {
                    textType = 1;
                    didAnything = true;
                }
                if (OldPatcherConfig.disableNametagBoxes) {
                    background = false;
                    didAnything = true;
                }
                if (OldPatcherConfig.showOwnNametag) {
                    showOwnNametag = true;
                    didAnything = true;
                }
                hasMigratedPatcher = true;
                INSTANCE.save();
                if (didAnything) {
                    Notifications.INSTANCE.send("PolyNametag", "Migrated Patcher settings replaced by PolyNametag. Please check PolyNametag's settings to make sure they are correct.");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

