/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.polynametag.render;

import cc.polyfrost.oneconfig.renderer.TextRenderer;
import cc.polyfrost.oneconfig.utils.dsl.ColorUtilsDSLKt;
import cc.polyfrost.oneconfig.utils.dsl.DSLsKt;
import club.sk1er.patcher.config.PatcherConfig;
import gg.essential.universal.UMatrixStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.polyfrost.polynametag.PolyNametag;
import org.polyfrost.polynametag.config.ModConfig;
import org.polyfrost.polynametag.mixin.FontRendererAccessor;
import org.polyfrost.polynametag.render.EssentialBSManager;
import org.polyfrost.polynametag.render.Vec2;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u001aE\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001aE\u0010\r\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\f\u001a%\u0010\r\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a=\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0011\u001a\u001d\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0012\u001a%\u0010\u0015\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\r\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u000f\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0011\u0010\u001c\u001a\u00020\u0019*\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a3\u0010#\u001a\u00020\u0003*\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b#\u0010$\"\"\u0010%\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010)\"\"\u0010*\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010&\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010)\"\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/\"\u001d\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u001d\u00106\u001a\b\u0012\u0004\u0012\u000201008\u0006\u00a2\u0006\f\n\u0004\b6\u00103\u001a\u0004\b7\u00105\u00a8\u00068"}, d2={"", "xStart", "xEnd", "", "red", "green", "blue", "alpha", "Lnet/minecraft/entity/Entity;", "entity", "", "drawBackground", "(DDIIIILnet/minecraft/entity/Entity;)V", "drawFrontBackground", "(DDLnet/minecraft/entity/Entity;)V", "", "text", "(Ljava/lang/String;IIIILnet/minecraft/entity/Entity;)V", "(Ljava/lang/String;Lnet/minecraft/entity/Entity;)V", "string", "light", "drawIndicator", "(Lnet/minecraft/entity/Entity;Ljava/lang/String;I)V", "getBackBackgroundAlpha", "()I", "", "shouldDrawBackground", "()Z", "canDrawIndicator", "(Lnet/minecraft/entity/Entity;)Z", "Lnet/minecraft/client/gui/FontRenderer;", "", "x", "y", "color", "drawStringWithoutZFighting", "(Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;FFI)I", "drawingText", "Z", "getDrawingText", "setDrawingText", "(Z)V", "drawingWithDepth", "getDrawingWithDepth", "setDrawingWithDepth", "Lorg/polyfrost/polynametag/render/EssentialBSManager;", "essentialBSManager", "Lorg/polyfrost/polynametag/render/EssentialBSManager;", "", "Lorg/polyfrost/polynametag/render/Vec2;", "points", "Ljava/util/List;", "getPoints", "()Ljava/util/List;", "translate", "getTranslate", "PolyNametag-1.8.9-forge"})
public final class NametagRenderingKt {
    private static boolean drawingText;
    private static boolean drawingWithDepth;
    @NotNull
    private static final EssentialBSManager essentialBSManager;
    @NotNull
    private static final List<Vec2> points;
    @NotNull
    private static final List<Vec2> translate;

    public static final boolean getDrawingText() {
        return drawingText;
    }

    public static final void setDrawingText(boolean bl) {
        drawingText = bl;
    }

    public static final boolean getDrawingWithDepth() {
        return drawingWithDepth;
    }

    public static final void setDrawingWithDepth(boolean bl) {
        drawingWithDepth = bl;
    }

    public static final boolean shouldDrawBackground() {
        return ModConfig.INSTANCE.getBackground() && (!PolyNametag.INSTANCE.isPatcher() || !PatcherConfig.disableNametagBoxes);
    }

    public static final int getBackBackgroundAlpha() {
        return NametagRenderingKt.shouldDrawBackground() ? RangesKt.coerceAtMost((int)ModConfig.INSTANCE.getBackgroundColor().getAlpha(), (int)63) : 0;
    }

    public static final void drawFrontBackground(@NotNull String text, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NametagRenderingKt.drawFrontBackground(text, ModConfig.INSTANCE.getBackgroundColor().getRed(), ModConfig.INSTANCE.getBackgroundColor().getGreen(), ModConfig.INSTANCE.getBackgroundColor().getBlue(), ModConfig.INSTANCE.getBackgroundColor().getAlpha(), entity);
    }

    public static final void drawFrontBackground(@NotNull String text, int red, int green, int blue, int alpha, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double halfWidth = (double)(DSLsKt.getMc().field_71466_p.func_78256_a(text) / 2) + 1.0;
        NametagRenderingKt.drawBackground(-halfWidth, halfWidth, red, green, blue, alpha, entity);
    }

    @NotNull
    public static final List<Vec2> getPoints() {
        return points;
    }

    @NotNull
    public static final List<Vec2> getTranslate() {
        return translate;
    }

    public static final void drawFrontBackground(double xStart, double xEnd, int red, int green, int blue, int alpha, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NametagRenderingKt.drawBackground(xStart, xEnd, red, green, blue, alpha, entity);
    }

    public static final void drawFrontBackground(double xStart, double xEnd, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NametagRenderingKt.drawBackground(xStart, xEnd, ModConfig.INSTANCE.getBackgroundColor().getRed(), ModConfig.INSTANCE.getBackgroundColor().getGreen(), ModConfig.INSTANCE.getBackgroundColor().getBlue(), ModConfig.INSTANCE.getBackgroundColor().getAlpha(), entity);
    }

    public static final void drawBackground(double xStart, double xEnd, int red, int green, int blue, int alpha, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!ModConfig.INSTANCE.enabled) {
            return;
        }
        if (!NametagRenderingKt.shouldDrawBackground()) {
            return;
        }
        double realStart = xStart - (double)(PolyNametag.INSTANCE.getShouldDrawIndicator() ? 10 : 0);
        GL11.glEnable((int)2848);
        GlStateManager.func_179090_x();
        GL11.glPushMatrix();
        GL11.glTranslated((double)((realStart + xEnd) / (double)2.0f), (double)3.5, (double)0.01);
        GL11.glBegin((int)6);
        int a = RangesKt.coerceAtMost((int)alpha, (int)63);
        float realAlpha = drawingWithDepth ? (float)(alpha - a) / (float)(255 - a) : (float)alpha / 255.0f;
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)realAlpha);
        drawingWithDepth = false;
        double halfWidth = (xEnd - realStart) / (double)2.0f + (double)ModConfig.INSTANCE.getPaddingX();
        float radius = ModConfig.INSTANCE.getRounded() ? RangesKt.coerceAtMost((float)RangesKt.coerceAtMost((float)ModConfig.INSTANCE.getCornerRadius(), (float)(4.5f + ModConfig.INSTANCE.getPaddingY())), (float)((float)halfWidth)) : 0.0f;
        double width = halfWidth - (double)radius;
        float distanceFromPlayer = entity.func_70032_d((Entity)DSLsKt.getMc().field_71439_g);
        int quality = (int)(RangesKt.coerceAtMost((float)(distanceFromPlayer * (float)4 + (float)10), (float)350.0f) / (float)4);
        for (int a2 = 0; a2 < 4; ++a2) {
            Vec2 vec2 = translate.get(a2);
            int transX = vec2.component1();
            int transY = vec2.component2();
            double x = (double)points.get(a2).getX() * width;
            double y = (double)points.get(a2).getY() * (4.5 + (double)ModConfig.INSTANCE.getPaddingY() - (double)radius);
            if (ModConfig.INSTANCE.getRounded()) {
                int n = 90 / quality;
                for (int b = 0; b < n; ++b) {
                    double radian = Math.toRadians(a2 * 90 + b * quality);
                    GL11.glVertex2d((double)(x + Math.sin(radian) * (double)radius), (double)(y + Math.cos(radian) * (double)radius));
                }
                GL11.glVertex2d((double)(x + (double)((float)transX * radius)), (double)(y + (double)((float)transY * radius)));
                continue;
            }
            GL11.glVertex2d((double)x, (double)y);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2848);
    }

    public static final void drawIndicator(@NotNull Entity entity, @NotNull String string, int light) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        PolyNametag.INSTANCE.setDrawingIndicator(true);
        essentialBSManager.drawIndicator(new UMatrixStack(), entity, string, light);
        PolyNametag.INSTANCE.setDrawingIndicator(false);
    }

    public static final boolean canDrawIndicator(@NotNull Entity $this$canDrawIndicator) {
        Intrinsics.checkNotNullParameter((Object)$this$canDrawIndicator, (String)"<this>");
        return essentialBSManager.canDrawIndicator($this$canDrawIndicator);
    }

    public static final int drawStringWithoutZFighting(@NotNull FontRenderer $this$drawStringWithoutZFighting, @NotNull String text, float x, float y, int color) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$drawStringWithoutZFighting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!($this$drawStringWithoutZFighting instanceof FontRendererAccessor)) {
            return 0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
        drawingText = true;
        switch (ModConfig.INSTANCE.getTextType()) {
            case 0: {
                n2 = $this$drawStringWithoutZFighting.func_175065_a(text, x, y, color, false);
                break;
            }
            case 1: {
                n2 = $this$drawStringWithoutZFighting.func_175065_a(text, x, y, color, true);
                break;
            }
            case 2: {
                n2 = TextRenderer.drawBorderedText((String)text, (float)x, (float)y, (int)color, (int)ColorUtilsDSLKt.getAlpha((int)color));
                break;
            }
            default: {
                n2 = 0;
            }
        }
        int $this$drawStringWithoutZFighting_u24lambda_u240 = n = n2;
        boolean bl = false;
        drawingText = false;
        GlStateManager.func_179121_F();
        return n;
    }

    static {
        essentialBSManager = new EssentialBSManager();
        Object[] objectArray = new Vec2[]{new Vec2(1, 1), new Vec2(1, -1), new Vec2(-1, -1), new Vec2(-1, 1)};
        points = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Vec2[]{new Vec2(1, 0), new Vec2(0, -1), new Vec2(-1, 0), new Vec2(0, 1)};
        translate = CollectionsKt.listOf((Object[])objectArray);
    }
}

