/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud;

import Apec.Components.Gui.GuiIngame.ApecGuiIngameForge;
import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.config.features.gui.customscoreboard.CustomScoreboardConfig;
import at.hannibal2.skyhanni.config.features.misc.compacttablist.CompactTabListConfig;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabListReader;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.events.event.TickEvent;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.utils.Notifications;
import club.sk1er.patcher.config.OldPatcherConfig;
import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.core.Feature;
import codes.biscuit.skyblockaddons.features.tablist.TabListParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.jetbrains.annotations.Nullable;
import org.polyfrost.overflowanimations.config.OldAnimationsSettings;
import org.polyfrost.vanillahud.config.ModConfig;
import org.polyfrost.vanillahud.hud.Air;
import org.polyfrost.vanillahud.hud.Armor;
import org.polyfrost.vanillahud.hud.BossBar;
import org.polyfrost.vanillahud.hud.Experience;
import org.polyfrost.vanillahud.hud.Health;
import org.polyfrost.vanillahud.hud.Hotbar;
import org.polyfrost.vanillahud.hud.Hunger;
import org.polyfrost.vanillahud.hud.TabList;
import org.polyfrost.vanillahud.utils.TabListManager;
import org.polyfrost.vanillahud.utils.Utils;

@Mod(modid="vanillahud", name="VanillaHUD", version="2.2.12")
public class VanillaHUD {
    public static final String MODID = "vanillahud";
    public static final String NAME = "VanillaHUD";
    public static final String VERSION = "2.2.12";
    public static ModConfig modConfig;
    private static boolean apec;
    public static boolean isPatcher;
    public static boolean isHytils;
    private static boolean isSBA;
    private static boolean isSkyHanni;
    private static boolean isOAM;
    private static boolean forceDisableCompactTab;
    private static boolean skyHanniField;
    @Nullable
    private static MethodHandle skyHanniGetGuiHandle;
    @Nullable
    private static MethodHandle skyHanniGetCompactTabListHandle;
    @Nullable
    private static MethodHandle skyHanniGetCustomScoreboardHandle;
    private static BooleanSupplier isCompactTab;
    private static BooleanSupplier isCustomScoreboard;

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        modConfig = new ModConfig();
        TabListManager.asyncUpdateList();
        EventManager.INSTANCE.register((Object)this);
        EventManager.INSTANCE.register((Object)new Utils());
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"bossbar_customizer")) {
            Notifications.INSTANCE.send(NAME, "Bossbar Customizer has been replaced by VanillaHUD and thus can be removed (they will also not work with each other).");
        }
        if (Loader.isModLoaded((String)"sidebarmod")) {
            Notifications.INSTANCE.send(NAME, "Sidebar Mod Revamp has been replaced by VanillaHUD and thus can be removed (they will also not work with each other).");
        }
        apec = Loader.isModLoaded((String)"apec");
        isPatcher = Loader.isModLoaded((String)"patcher");
        isHytils = Loader.isModLoaded((String)"hytils-reborn");
        isSBA = Loader.isModLoaded((String)"skyblockaddons") || Loader.isModLoaded((String)"sbaunofficial");
        isSkyHanni = Loader.isModLoaded((String)"skyhanni");
        isOAM = Loader.isModLoaded((String)"overflowanimations");
        this.checkForSkyHanni();
        this.doDebugMigration();
        this.updateHeight();
        this.doPatcherMigration();
    }

    @Subscribe
    private void onTick(TickEvent event) {
        if (forceDisableCompactTab || !isSkyHanni || !skyHanniField) {
            return;
        }
        if (event.stage == Stage.START) {
            try {
                Object customScoreboardObj;
                Object compactTabListObj;
                Object gui = VanillaHUD.getSkyHanniGuiFeature();
                if (gui == null) {
                    return;
                }
                if (skyHanniGetCompactTabListHandle != null && (compactTabListObj = skyHanniGetCompactTabListHandle.invoke(gui)) instanceof CompactTabListConfig) {
                    isCompactTab = () -> (Boolean)((CompactTabListConfig)compactTabListObj).enabled.get();
                }
                if (skyHanniGetCustomScoreboardHandle != null && (customScoreboardObj = skyHanniGetCustomScoreboardHandle.invoke(gui)) instanceof CustomScoreboardConfig) {
                    isCustomScoreboard = () -> (Boolean)((CustomScoreboardConfig)customScoreboardObj).enabled.get();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                forceDisableCompactTab = true;
            }
        }
    }

    private void checkForSkyHanni() {
        if (isSkyHanni) {
            try {
                Class<?> guiConfig = Class.forName("at.hannibal2.skyhanni.config.features.gui.GUIConfig");
                try {
                    guiConfig.getDeclaredField("compactTabList");
                    guiConfig.getDeclaredField("customScoreboard");
                }
                catch (NoSuchFieldException e) {
                    forceDisableCompactTab = true;
                    System.out.println("SkyHanni: compactTabList not found");
                    return;
                }
                Class<?> property = Class.forName("at.hannibal2.skyhanni.deps.moulconfig.observer.Property");
                Class.forName("at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter");
                Class<?> compactTabListConfig = Class.forName("at.hannibal2.skyhanni.config.features.misc.compacttablist.CompactTabListConfig");
                Class<?> customScoreboardConfig = Class.forName("at.hannibal2.skyhanni.config.features.gui.customscoreboard.CustomScoreboardConfig");
                try {
                    Field enabledTab = compactTabListConfig.getDeclaredField("enabled");
                    if (enabledTab.getType() != property) {
                        forceDisableCompactTab = true;
                        System.out.println("SkyHanni: enabled not found");
                        return;
                    }
                    Field enabledScoreboard = customScoreboardConfig.getDeclaredField("enabled");
                    if (enabledScoreboard.getType() != property) {
                        forceDisableCompactTab = true;
                        System.out.println("SkyHanni: enabled not found");
                        return;
                    }
                }
                catch (NoSuchFieldException e) {
                    forceDisableCompactTab = true;
                    System.out.println("SkyHanni: enabled not found");
                    return;
                }
                Class<?> features = Class.forName("at.hannibal2.skyhanni.config.Features");
                try {
                    features.getDeclaredField("gui");
                }
                catch (NoSuchFieldException e) {
                    forceDisableCompactTab = true;
                    System.out.println("SkyHanni: gui not found");
                    return;
                }
                Class<?> renderColumn = Class.forName("at.hannibal2.skyhanni.features.misc.compacttablist.RenderColumn");
                Class<?> tabListReader = Class.forName("at.hannibal2.skyhanni.features.misc.compacttablist.TabListReader");
                try {
                    Method method = tabListReader.getDeclaredMethod("getRenderColumns", new Class[0]);
                    Type returnType = method.getGenericReturnType();
                    if (!(returnType instanceof ParameterizedType)) {
                        System.out.println("SkyHanni: !(returnType instanceof java.lang.reflect.ParameterizedType)");
                        forceDisableCompactTab = true;
                        return;
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)returnType;
                    Type[] typeParameters = parameterizedType.getActualTypeArguments();
                    if (typeParameters.length != 1) {
                        System.out.println("SkyHanni: typeParameters.length != 1");
                        forceDisableCompactTab = true;
                        return;
                    }
                    Type renderColumnParameter = typeParameters[0];
                    if (renderColumnParameter == null || !renderColumn.getName().equals(renderColumnParameter.getTypeName())) {
                        System.out.println("SkyHanni: renderColumnParameter == null || !renderColumn.equals(renderColumnParameter.getGenericDeclaration())");
                        forceDisableCompactTab = true;
                        return;
                    }
                }
                catch (NoSuchMethodException e) {
                    forceDisableCompactTab = true;
                    System.out.println("SkyHanni: getRenderColumns not found");
                    return;
                }
                Class<?> lorenzUtils = Class.forName("at.hannibal2.skyhanni.utils.LorenzUtils");
                try {
                    lorenzUtils.getDeclaredMethod("getInSkyBlock", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    forceDisableCompactTab = true;
                    System.out.println("SkyHanni: getInSkyBlock not found");
                    return;
                }
                Class<?> clazz = Class.forName("at.hannibal2.skyhanni.SkyHanniMod", true, this.getClass().getClassLoader());
                try {
                    clazz.getDeclaredField("feature");
                    skyHanniField = true;
                }
                catch (NoSuchFieldException e) {
                    skyHanniField = false;
                    try {
                        clazz.getDeclaredMethod("getFeature", new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        forceDisableCompactTab = true;
                        System.out.println("SkyHanni: getFeature not found");
                        return;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.out.println("SkyHanni: class not found");
                forceDisableCompactTab = true;
                e.printStackTrace();
            }
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Features features = SkyHanniMod.feature;
                Field guiField = features.getClass().getDeclaredField("gui");
                Class<?> guiConfigClass = guiField.getType();
                skyHanniGetGuiHandle = lookup.findGetter(Features.class, "gui", guiConfigClass);
                Field compactTabListField = guiConfigClass.getDeclaredField("compactTabList");
                compactTabListField.setAccessible(true);
                skyHanniGetCompactTabListHandle = lookup.unreflectGetter(compactTabListField);
                Field customScoreboardField = guiConfigClass.getDeclaredField("customScoreboard");
                customScoreboardField.setAccessible(true);
                skyHanniGetCustomScoreboardHandle = lookup.unreflectGetter(customScoreboardField);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private void doDebugMigration() {
        if (!ModConfig.doneDebugMigration) {
            if (!ModConfig.actionBar.hud.showInDebug) {
                ModConfig.actionBar.hud.showInDebug = true;
                ModConfig.actionBar.save();
            }
            if (!Air.hud.showInDebug) {
                Air.hud.showInDebug = true;
                ModConfig.air.save();
            }
            if (!Armor.hud.showInDebug) {
                Armor.hud.showInDebug = true;
                ModConfig.armor.save();
            }
            if (!BossBar.hud.showInDebug) {
                BossBar.hud.showInDebug = true;
                ModConfig.bossBar.save();
            }
            if (!Experience.hud.showInDebug) {
                Experience.hud.showInDebug = true;
                ModConfig.experience.save();
            }
            if (!Health.hud.showInDebug) {
                Health.hud.showInDebug = true;
                ModConfig.health.save();
            }
            if (!Hotbar.hud.showInDebug) {
                Hotbar.hud.showInDebug = true;
                ModConfig.hotBar.save();
            }
            if (!Hunger.hud.showInDebug) {
                Hunger.hud.showInDebug = true;
                ModConfig.hunger.save();
            }
            if (!Hunger.mountHud.showInDebug) {
                Hunger.mountHud.showInDebug = true;
                ModConfig.hunger.save();
            }
            if (!ModConfig.itemTooltip.hud.showInDebug) {
                ModConfig.itemTooltip.hud.showInDebug = true;
                ModConfig.itemTooltip.save();
            }
            if (!ModConfig.scoreboard.hud.showInDebug) {
                ModConfig.scoreboard.hud.showInDebug = true;
                ModConfig.scoreboard.save();
            }
            if (!TabList.hud.showInDebug) {
                TabList.hud.showInDebug = true;
                ModConfig.tab.save();
            }
            if (TabList.TabHud.selfAtTop) {
                TabList.TabHud.selfAtTop = false;
                ModConfig.tab.save();
            }
            if (!ModConfig.title.titleHUD.showInDebug) {
                ModConfig.title.titleHUD.showInDebug = true;
                ModConfig.title.save();
            }
            if (!ModConfig.title.subtitleHUD.showInDebug) {
                ModConfig.title.subtitleHUD.showInDebug = true;
                ModConfig.title.save();
            }
            ModConfig.doneDebugMigration = true;
            modConfig.save();
        }
    }

    private void updateHeight() {
        if (!TabList.TabHud.updatedHeight) {
            TabList.TabHud.updatedHeight = true;
            if (TabList.hud.position.getY() == 10.0f) {
                TabList.hud.position.setY(TabList.hud.position.getY() + 10.0f);
                ModConfig.tab.save();
            }
        }
    }

    private void doPatcherMigration() {
        if (isPatcher) {
            try {
                if (ModConfig.hasMigratedPatcher) {
                    return;
                }
                Class.forName("club.sk1er.patcher.config.OldPatcherConfig");
                boolean saveTitle = false;
                boolean saveTab = false;
                boolean saveActionBar = false;
                if (OldPatcherConfig.disableTitles) {
                    ModConfig.title.enabled = false;
                    saveTitle = true;
                }
                if (OldPatcherConfig.titleScale != 1.0f) {
                    ModConfig.title.titleHUD.setScale(ModConfig.title.titleHUD.getScale() * OldPatcherConfig.titleScale, true);
                    ModConfig.title.subtitleHUD.setScale(ModConfig.title.subtitleHUD.getScale() * OldPatcherConfig.titleScale, true);
                    saveTitle = true;
                }
                if (OldPatcherConfig.titleOpacity != 1.0f) {
                    ModConfig.title.titleHUD.getColor().setAlpha((int)(OldPatcherConfig.titleOpacity * 255.0f));
                    ModConfig.title.subtitleHUD.getColor().setAlpha((int)(OldPatcherConfig.titleOpacity * 255.0f));
                    saveTitle = true;
                }
                if (OldPatcherConfig.toggleTab) {
                    TabList.TabHud.displayMode = true;
                    saveTab = true;
                }
                if (OldPatcherConfig.tabOpacity != 1.0f) {
                    TabList.hud.getBackgroundColor().setAlpha((int)((float)TabList.hud.getBackgroundColor().getAlpha() * OldPatcherConfig.tabOpacity));
                    TabList.TabHud.tabWidgetColor.setAlpha((int)((float)TabList.TabHud.tabWidgetColor.getAlpha() * OldPatcherConfig.tabOpacity));
                    saveTab = true;
                }
                if (OldPatcherConfig.tabPlayerCount != 80) {
                    TabList.TabHud.tabPlayerLimit = OldPatcherConfig.tabPlayerCount;
                    saveTab = true;
                }
                if (!OldPatcherConfig.tabHeightAllow) {
                    TabList.hud.position.setY(TabList.hud.position.getY() - 10.0f);
                    saveTab = true;
                } else if (OldPatcherConfig.tabHeight != 10) {
                    TabList.hud.position.setY(TabList.hud.position.getY() + (float)(OldPatcherConfig.tabHeight - 10));
                    saveTab = true;
                }
                if (OldPatcherConfig.shadowedActionbarText) {
                    ModConfig.actionBar.hud.setTextType(1);
                    saveActionBar = true;
                }
                if (OldPatcherConfig.actionbarBackground) {
                    ModConfig.actionBar.hud.setBackground(true);
                    saveActionBar = true;
                }
                if (saveTitle) {
                    ModConfig.title.save();
                }
                if (saveTab) {
                    ModConfig.tab.save();
                }
                if (saveActionBar) {
                    ModConfig.actionBar.save();
                }
                ModConfig.hasMigratedPatcher = true;
                modConfig.save();
                if (saveTitle || saveTab || saveActionBar) {
                    Notifications.INSTANCE.send(NAME, "Migrated Patcher settings replaced by VanillaHUD. Please check VanillaHUD's settings to make sure they are correct.");
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isApec() {
        return apec && Minecraft.func_71410_x().field_71456_v instanceof ApecGuiIngameForge;
    }

    public static boolean isCompactTab() {
        return VanillaHUD.isSBACompactTab() || VanillaHUD.isSkyHanniCompactTab();
    }

    public static boolean isForceDisableCompactTab() {
        return VanillaHUD.isCompactTab();
    }

    private static boolean isSBACompactTab() {
        return isSBA && SkyblockAddons.getInstance().getUtils().isOnSkyblock() && SkyblockAddons.getInstance().getConfigValues().isEnabled(Feature.COMPACT_TAB_LIST) && TabListParser.getRenderColumns() != null;
    }

    private static boolean isSkyHanniCompactTab() {
        if (!isSkyHanni) {
            return false;
        }
        if (forceDisableCompactTab) {
            return Utils.inSkyblock;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return false;
        }
        if (skyHanniField ? isCompactTab == null || !isCompactTab.getAsBoolean() : (Boolean)SkyHanniMod.getFeature().gui.compactTabList.enabled.get() == false) {
            return false;
        }
        return TabListReader.INSTANCE.getRenderColumns() != null;
    }

    public static boolean isSkyHanniScoreboard() {
        if (!isSkyHanni) {
            return false;
        }
        if (forceDisableCompactTab) {
            return Utils.inSkyblock;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return false;
        }
        if (skyHanniField) {
            try {
                return isCustomScoreboard != null && isCustomScoreboard.getAsBoolean();
            }
            catch (Throwable t) {
                forceDisableCompactTab = true;
                t.printStackTrace();
                return Utils.inSkyblock;
            }
        }
        return (Boolean)SkyHanniMod.getFeature().gui.customScoreboard.enabled.get();
    }

    @Nullable
    private static Object getSkyHanniGuiFeature() throws Throwable {
        Features features = SkyHanniMod.feature;
        if (skyHanniGetGuiHandle == null) {
            return null;
        }
        return skyHanniGetGuiHandle.invoke(features);
    }

    public static boolean isLegacyTablist() {
        return isOAM && OldAnimationsSettings.INSTANCE.enabled && OldAnimationsSettings.INSTANCE.tabMode == 0;
    }

    static {
        apec = false;
        isPatcher = false;
        isHytils = false;
        isSBA = false;
        isSkyHanni = false;
        isOAM = false;
        forceDisableCompactTab = false;
        skyHanniField = false;
    }
}

